function [U, N] = lyngby_nn_vw2u(V, W)

% lyngby_nn_vw2u       - Vectorize neural network weights
%
%       function [U, N] = lyngby_nn_vw2u(V, W)
%
%       Input:  V   Input weights
%               W   Output weights
%
%       Output: U   Vectorized weights (V first, then W)
%               N   Network structure
%
%       This function assumes that there is an input threshold.
%
%       See also: lyngby_nn_vw2u, lyngby_nn_qmain, lyngby_nn_emain

% cvs : $Id: lyngby_nn_vw2u.m,v 1.2 1997/09/11 11:31:03 fnielsen Exp $
%       $Revision: 1.2 $

    [Nii, Nh] = size(V);
    [Nhh, No] = size(W);
    Ni = Nii-1;

    U = [V(:) ; W(:)];
    N = [ [Nii Nhh No] ; [Nii-1 Nh No] ];
