function S = lyngby_nns_esalmap(X, B, H, O, D, V, W, factor)

% lyngby_nns_esalmap	- Saliency map with entropic cost function
%
%	function S = lyngby_nns_esalmap(X, B, H, O, D, V, W, factor)
%
%	Input:	D		Desired input
%		H		Hidden units value
%		O		Output from neural network
%		V		Hidden weights
%		W		Output weights
%		factor		factor to be multiplied (normalization between
%				neural network input and eigenimages)
%
%	Output:	S		Saliency map
%
%	NOTE this function is not finisish: the matrice are transposed!

% cvs : $Id: lyngby_nns_esalmap.m,v 1.3 1997/11/22 16:07:00 pto Exp $
%       $Revision: 1.3 $

    [Nh,Nii] = size(V);
    [No, Nhh] = size(W);
    [No, Np] = size(D);
    [Nx,NiB] = size(B);	
    Ni = Nii - 1;

    % Cut the threshold from the weights
    VI = find(any(V));
    VI = VI(find(VI <= NiB));
    V = V(:,VI);
    W = W(:,1:Nh);
    factor = ones(Nh,1) * factor(VI);
    
    E = D - O;
    H12 = 1- H.^2;
    
    lyngby_log('Shortening the basis');
    B = B(:,VI);
    lyngby_log('Ending shortening of the basis');
    
    
    % First order term	
    WE	= W' * E;		% h p
    WEH12	= WE .* H12;		% h p
    lyngby_log('Begining VB big multiplication');
    VB	= (V./factor) * B';		% h x
    lyngby_log('Ending VB big multiplication');
%clear B;
    lyngby_log('Begining VB x WEH12 big multiplication');
    VBWEH12	= VB' * WEH12;		% x p
    lyngby_log('Ending VB x WEH12 big multiplication');
%clear WEH12;
%clear VB;
    S = zeros(Nx,1);
    for pp = 1:Np
      S =  S + VBWEH12(:,pp) .* X(:,pp);
      lyngby_log(sprintf('Loaded and added pattern: %d / %d', pp, Np));
    end
    
    % For loop version - First order term
    %	for xx = 1:Nx
    %	  for oo = 1:No
    %	    for hh = 1:Nh
    %	      for ii = 1:Ni
    %		for pp = 1:Np
    %	S(xx) =	E(oo,pp) * W(oo,hh) * H12(hh,pp) * V(hh,ii) * B(ii,xx) * X(xx,pp);
    %		end
    %	      end
    %	    end
    %	  end
    %   end
















