function P = lyngby_paradigm();

% lyngby_paradigm      - Returns the paradigm
%
%       function P = lyngby_paradigm();
%
%       Output: P   The paradigm in a column vector 
%                   The indices correspond to the indices 
%                   in the lyngby_getvolume function
%
%       This function will first try to read a file
%       'data_paradigm.mat'. There should be a variable called
%       PARADIGM in this file. If the file is not defined then it will
%       try the function data_paradigm.m. Still, if this not succeed it will
%       finally try the file data_paradigm.txt. 
%       The user should define one of the function/files.
%
%       See also: LYNGBY_RUN, LYNGBY_GETVOLUME

% cvs : $Id: lyngby_paradigm.m,v 1.7 2000/05/08 15:10:06 fnielsen Exp $
%       $Revision: 1.7 $


    if exist('data_paradigm.mat') == 2
      load data_paradigm.mat
      if exist('PARADIGM')
	if ~length(PARADIGM) 
	  error(['data_paradigm.mat file did not contain any'  ...
		' PARADIGM variable.']);
	else
	  P = PARADIGM;
	end
      else
	error('The data_paradigm.mat file does not contain the paradigm variable P');
      end
      
    elseif exist('data_paradigm') == 2
      
      clear data_paradigm
      eval('P = data_paradigm;');
      if ~length(P)
	error('data_paradigm function did not give any values.');
      end
      
    elseif exist('data_paradigm.txt') == 2
      load data_paradigm.txt
      if exist('data_paradigm') == 1
	if ~length(data_paradigm)
	  P = data_paradigm;
	else
	   error('The data_paradigm.txt file did not contain any values.');
	end
      else
	error('Could not load from data_paradigm.txt');
      end
    else
      P = [];
      % error('The is no paradigm defined. Neither a The user should provide a ''data_paradigm'' function');
    end
    
    % The user might have entered the values the wrong way
    if size(P,1) < size(P,2)
      P = P';
    end





















