function P = lyngby_pca_eqtest(S,n)

% lyngby_pca_eqtest    - PCA test for equal eigenvalues
%
%       function p = lyngby_pca_eqtest(S,n)
%
%       Input:  S   The eigenvalues (vector)
%               n   Number of samples
%
%       Output: p   p-value for the test.
%
%       See also: lyngby_svd

% cvs : $Id: lyngby_pca_eqtest.m,v 1.1 1998/03/17 17:41:43 fnielsen Exp $
%       $Revision: 1.1 $


    p = length(S);

    nBartlett = n - (2*p+11)/6;

    P = zeros(length(S), 1);
    
    for k = 0:(p-2)
      
      l = nBartlett * (p-k) * log(mean(S((1+k):p)) / ... ...
	  lyngby_meangeo(S((1+k):p)));
      dof = (p-k+2) * (p-k-1) / 2;

      P(k+1) = 1 - lyngby_cdf_chi2(l, dof);
      
    end

    P(p) = 1;