function [Xnew,V] = lyngby_pcafilter(X, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8)

% lyngby_pcafilter	- Reduce the dimension or filter a matrix with PCA filtering
%
%	function [Xnew,V] = pcareduc(X,'PropertyName',PropertyValue)
%
%	Input:	X:	matrix
%		PropertyNames
%			'Direction'		[ {v} | h ] vertical or horizontal
%			'FilterComponents'	{ 20 }
%			'ReduceComponents'	{ all } Number of components to reduce to 
%
%	Output:	Xnew:	X projected on the dim number of principal components
%		V:	The rotation (eigenmatrix) used for the PCA
%
%	500^2 element eigenvalue ~10s second

%	1996-11-28	fnielsen	Initial version

% cvs :  $Revision: 1.1.1.1 $

	[nt,nv] = size(X);

	direction = 'v';
	filterComponents = -1;
	reduceComponents = -1; 

	n = 1;
	while n < nargin-1
		eval(sprintf('arg = lower(arg%d);', n)); 
		if strcmp(arg, 'direction')
			n = n + 1;
			eval(sprintf('arg = lower(arg%d);', n));
			if arg == 'v'
				direction = 'v';
			elseif arg == 'h'
				direction = 'h';
			else
				error(sprintf('Type ''%s'' not recognized', arg));
			end
		elseif strcmp(arg, 'filtercomponents')
			n = n + 1;
			eval(sprintf('arg = arg%d;', n));
			filterComponents = arg;
			if filterComponents < 1
				error('The number of filter components should a value larger or equal to 1.')
			end
		elseif strcmp(arg, 'reducecomponents')
			n = n + 1;
			eval(sprintf('arg = arg%d;', n));
			reduceComponents = arg;
			if reduceComponents < 1
				error('The number of iterations should be a value larger than 1.')
			end
		else
			error('Invalid property');
		end
		n = n + 1;
	end


	if direction == 'v'
		if reduceComponents == -1
			reduceComponents = nt;
		end
		if filterComponents == -1
			filterComponents = nt;
		end

		[V,D] =	eig(X*X');
		[D,I] = sort(-diag(D));
				
		V = [ V(:,I(1:filterComponents))  zeros(size(V,1), reduceComponents-filterComponents) ];
		Xnew = V * V' * X;

	else 
		if reduceComponents == -1
			reduceComponents = nv;
		end
		if filterComponents == -1
			filterComponents = nv;
		end

		[V,D] =	eig(X'*X);
		[D,I] = sort(-diag(D));

		V = [ V(I(1:filterComponents),:) ; zeros(reduceComponents-filterComponents+1,size(V,1)) ];
		Xnew = X * V' * V;

	end







