function p = lyngby_pdf_beta(x, a, b)

% lyngby_pdf_beta      - Beta probability density function
%
%       function p = lyngby_pdf_beta(X, a, b)
%
%       Input:  x   Data point 
%               a   first parameter
%               b   second parameter
%
%       Output: p   Beta probability density function
%
%       The Beta probability density function is defined as
% 
%       p(x) = 1/B(a,b) * x^(a-1) * (1-x)^(b-1)
%
%       This is the "Beta type I distribution" form. 
%       x should be in the interval [0;1], and a,b > 0
%
%       Example:
%         figure, x = 0:0.01:1; plot(x, lyngby_pdf_beta(x, 5, 5)) 
%
%       See also LYNGBY, LYNGBY_CDF_BETA, LYNGBY_PDF_BETA,
%                LYNGBY_PDF_GAUSS 
%
% $Id: lyngby_pdf_beta.m,v 1.2 2003/10/08 17:05:04 fnielsen Exp $


    p = (1/beta(a,b)) * ( x.^(a-1) .* (1-x).^(b-1) );

