function q = lyngby_pdf_bin(X, n, p)

% lyngby_pdf_bin       - Binomial probability density function
%
%       function p = lyngby_pdf_bin(X, n, p)
%
%       Input:  X   Data point 
%               n   "Number of coin flips"     
%               p   Probability, "Irregularity of coin"
%
%       Output: q   Binomial density function
%
%       See also: lyngby_pdf_gauss

% cvs:  $Id: lyngby_pdf_bin.m,v 1.1 1999/01/12 17:25:33 fnielsen Exp $
%       $Revision: 1.1 $


    q = nchoosek(n,X) * p^X * (1-p)^(n-X);

