function p = lyngby_pdf_f(x, r1, r2)

% lyngby_pdf_f         - F probability density function
%
%       function P = lyngby_pdf_f(x, r1, r2)
%
%       Input:  x   Value where the function is evaluated
%               r1  Numerator degrees of freedom
%               r2  Denominator degrees of freedom
%
%       Output: p   Probability density funtion
%
%       This function returns the probability density function for
%       Fisher's F-distribution. The function is zero for negative x,
%       and an error is returned if it is called with negative
%       values.
%
%       See also: lyngby_cdf_f, lyngby_cdf_gauss

% cvs : $Id: lyngby_pdf_f.m,v 1.1 1999/09/16 09:22:01 fnielsen Exp $
%       $Revision: 1.1 $

    if any(x < 0)
      error('x cannot be less than zero')
    end
    if any(r1 < 1)
      error('r1 cannot be less than one');
    end
    if any(r2 < 1)
      error('r2 cannot be less than one');
    end
    

    a = gamma( (r1+r2) / 2) .* r1.^(r1/2) .* r2.^(r2/2);
    b = gamma(r1/2) * gamma(r2/2);
    
    p = a * x .^( (r1/2) - 1) ./ ( b * (r2 + r1*x).^( (r1+r2)/2 ));
