function p = lyngby_pdf_gamma(x, n, lambda)

% lyngby_pdf_gamma     - Gamma distribution density
%
%       p = lyngby_pdf_gamma(x, n, lambda)
%
%       Input:  x       Data
%               n       Parameter 
%               lambda  Parameter 
%
%       Output: p       Probability density value
%
%       The probability density function of the gamma
%       distribution. This is defined as 
%
%        p = (lambda^n / gamma(n)) * x^(n-1) * exp(-lambda*x);
%
%       The mean of this is n/lambda and the variance n/lambda^2.
%
%       See also LYNGBY, LYNGBY_PDF_GAUSS.
%
% $Id: lyngby_pdf_gamma.m,v 1.2 2003/05/23 16:28:54 fnielsen Exp $


  p = (lambda^n / gamma(n)) * x.^(n-1) .* exp(-lambda*x);


