function p = lyngby_pdf_gauss(X, my, Sigma)

% lyngby_pdf_gauss   - Gaussian (normal) density function
%
%       function p = lyngby_pdf_gauss(X, my, Sigma)
%
%       Input:  X       Data points (object x variables)
%               my      Mean or mean vector 
%               Sigma   Variance or covariance matrix
%
%       Output: p       Gaussian density function

% cvs:  $Id: lyngby_pdf_gauss.m,v 1.1 1997/08/25 10:09:32 fnielsen Exp $
%       $Revision: 1.1 $


    dim = length(my);
    Np = size(X, 1);
    if size(my,1) < size(my,2)
      my = my';
    end
    if size(X,2) ~= dim
      error(['The number of variables in X does not fit with ' ...
	    'variables in my.']);
    end
    if dim == 1
      p = (2*pi*Sigma)^(-0.5) * exp(- (X-my).^2 / (2*Sigma) );
    else
      X = X - ones(Np,1) * my;
      p = ( 1 / ( (2*pi)^(dim/2) * sqrt(det(Sigma)) ) ) * ...
	  exp(-0.5 * diag(X * pinv(Sigma) * X'));  % This should be optimized !!!
    end