function p = lyngby_pdf_poisson(X, lambda)

% lyngby_pdf_poisson   - Poisson probability density function
%
%       function p = lyngby_pdf_poisson(X, lambda)
%
%       Input:  X        Data points (object x variables)
%               lambda   Poisson parameter(s) 
%
%       Output: p        Poisson density function
%
%       Poisson probability desity function.
%
%           f(x) = lambda^x * e^(-lambda) / x!  
%
%       where x! is the factorial or gamma(x+1).
%       Both X and lambda can be matrices or vectors.
%
%       See also: lyngby_pdf_gauss

% cvs:  $Id: lyngby_pdf_poisson.m,v 1.1 1998/02/20 14:17:53 fnielsen Exp $
%       $Revision: 1.1 $

    [mx, nx] = size(X);
    [ml, nl] = size(lambda);

    t = 0:(mx*ml-1);
    ix = fix(t/ml) + 1;
    il = rem(t,ml) + 1;
    t = 0:(nx*nl-1);
    jx = fix(t/nl) + 1;
    jl = rem(t,nl) + 1;
    
    p = lambda(il,jl) .^ X(ix,jx) .* exp(-lambda(il,jl)) ./ ...
	gamma(X(ix,jx)+1);
        
