function lyngby_plot_boxplot(x, middle, boxBottom, boxTop, bottom, ...
    top) 

% lyngby_plot_boxplot  - Box plot
%
%	function lyngby_plot_boxplot(x, middle, boxBottom, ...
%           boxTop, bottom, top)
%                                                  
%       Input:  x           X-axis values      
%               middle      Middle in box      
%               boxBottom   Bottom of box       
%               boxTop      Top of box
%               bottom      Bottom
%               top         Top 
%
%       This plotting function is suitable to give a summary of an
%       empirical distributions. It will produce vertical version of
%       this type:
%                          __________
%                   |-----[______|___]---|
%
%
%       See also LYNGBY.
%
% $Id: lyngby_plot_boxplot.m,v 1.2 2002/09/02 11:08:09 fnielsen Exp $


   
    boxwidth = min(diff(x))/4;
    
   
    for n = 1:length(x)
      if ~isempty(middle)
	line([x(n)-boxwidth/2 x(n)+boxwidth/2 ], middle([n n])); 
      end
      
      if ~isempty(bottom)
	line([x(n)-boxwidth/2 x(n)+boxwidth/2 ], boxBottom([n n])) 
      end
      if ~isempty(top)
	line([x(n)-boxwidth/2 x(n)+boxwidth/2 ], boxTop([n n])) 
      end

      
      if ~isempty(bottom)
	line([x(n)-boxwidth/2 x(n)+boxwidth/2 ], bottom([n n])) 
      end
      if ~isempty(top)
	line([x(n)-boxwidth/2 x(n)+boxwidth/2 ], top([n n])) 
      end

      if ~isempty(bottom) % ~isempty(boxBottom)
	line([x(n) x(n) ], [bottom(n) boxBottom(n)]) 
      end
      if ~isempty(top) % ~isempty(boxTop)
	line([x(n) x(n) ], [top(n) boxTop(n)]) 
      end

      if ~isempty(boxBottom) % ~isempty(boxTop)
	line([x(n)-boxwidth/2 x(n)-boxwidth/2 ], [boxBottom(n) ...
	      boxTop(n)]) 
	line([x(n)+boxwidth/2 x(n)+boxwidth/2 ], [boxBottom(n) boxTop(n)]) 
      end
    end






