function lyngby_plotmatch(hand, paradigm, datavec, response)

% lyngby_plotmatch	- Plot paradigm, data and model
%
%	function lyngby_plotmatch(hand, paradigm, datavec, response)
%
%	Input:	hand		Grafical handle

%	Date		Author		Version
%	1996-09-18	Peter Toft	Initial Version
%	1996-09-19	Peter Toft	Now uses lyngby_lz_lambda
%	1996-11-04	fnielsen	Split: lyngby_plotmatch, 
%					lyngby_lz_plot, lyngby_fir_plot
%	1996-11-27	fnielsen	hold off
%	1996-01-22	fnielsen	Bugfix: legend wrong

% cvs :  $Revision: 1.1.1.1 $

	hold off
	time = 1:length(paradigm);

	if hand==0,
  		figure;
  		hand = axes;
	else
  		axes(hand);
	end
	cla;

	model = conv(paradigm, response);

	plot(time, datavec, 'g-');
	hold on
		h = plot(time, model(1:length(paradigm)), 'r-.');
		set(h, 'LineWidth', 2);
		plot(time, paradigm, 'b.');
		%axis([0 length(paradigm)-1 -3 3]);
	
		legend('Data', 'Model', 'Paradigm');
	hold off;
  








