function [E, EY] = lyngby_pois_error(T, Y)	
	
% lyngby_pois_error    - Poisson residual signal (Quadratic error)
%
%	function function [E, EY] = lyngby_pois_error(T, Y)	
%
%	Input:	T    Target output
%		Y    Poisson filter prediction
%
%	Output:	EY   Error matrix for output units (T-Y)
%		E    Qudratic error, normalized for the number of
%		     examples
%
%       The function computes this:   1/(Np) * (sum( (T-Y).^2 ))
%
%       If T has more rows than Y it will only use the last samples of
%       T in the subtraction with Y, ie., it will assume that the
%       first samples are not forwarded with lyngby_pois_forward.
%
%       T and Y can be vectors or matrices.
%
%       See also: lyngby_pois_main, lyngby_pois_forward

% cvs : $Id: lyngby_pois_error.m,v 1.3 1998/03/06 15:33:06 fnielsen Exp $
%       $Revision: 1.3 $

    [rT, cT] = size(T);
    [rY, cY] = size(Y);

    if rT > rY
      if cT == cY 
	EY = T((rT-rY+1):rT,:) - Y;
      elseif cT == 1
	EY = T((rT-rY+1):rT,ones(cY,1)) - Y;
      elseif cY == 1
      	EY = T((rT-rY+1):rT,:) - Y(:,ones(cT,1));
      else
	error('Wrong size ')
      end
    elseif rT == rY
      if cT == cY 
	EY = T - Y;
      elseif cT == 1
	EY = T(:,ones(cY,1)) - Y;
      elseif cY == 1
      	EY = T - Y(:,ones(cT,1));
      else
	error('Wrong size ')
      end
    else
      error('Wrong size ')
    end
      
    E  = 1/rY * sum(EY.^2);
















