function [Y] = lyngby_pois_forward(X, Ampl, Poisson, kernelWidth, ...
    convType)

% lyngby_pois_forward  - Possion kernel forward (prediction)
%
%      function [Y] = lyngby_pois_forward(X, Ampl, Poisson,
%          kernelWidth, convType)
%
%      Input:  X             Input to the linear system
%              Ampl          Amplitude of kernel
%              Poisson       Poisson parameter
%              kernelWidth   Kernel Width (optional, 
%                            default 2*max(Poisson))
%              convType      Convolution type: What should be done
%                            with the first samples:
%                            1: Skip the number of samples
%                            corresponding to the kernel width.
%                            2: Fit all and use zeropadding
%                            3: Fit all and use pad with the first
%                            sample
%                            4: Wrap the time-series 
%                            (optional, default 1)
%
%      Output: Y             Prediction, the input forwarded, that is
%                            convolved with the kernel.
%
%      See also LYNGBY; LYNGBY_POIS_ERROR, LYNGBY_POIS_FORWN,
%               LYNGBY_POIS_ERROR. 
%
% $Id: lyngby_pois_forward.m,v 1.3 2003/05/23 09:46:45 fnielsen Exp $



    [rX, cX]             = size(X);
    [rAmpl, cAmpl]       = size(Ampl);
    [rPoisson, cPoisson] = size(Poisson);

    % Default parameters
    if nargin < 5
      convType = 1;
      if nargin < 4
	kernelWidth = min([rX ceil(2*max(Poisson)+1)]);
      end
    end

    Y = lyngby_pois_forwn(X, Poisson, kernelWidth, convType);
    Y = Ampl(ones(1, size(Y,1)),:) .* Y;
      















