function [Ampl, Poisson] = lyngby_pois_main(x, T, arg1, arg2, arg3, ...
    arg4, arg5, arg6)

% lyngby_pois_main     - Main function for Possion filter
%
%      function [Ampl, Poisson] = lyngby_pois_main(x, T,
%          'PropertyName', 'PropertyValue')
%
%      Input:    s            Input to the linear system
%                T            Target output to the linear system
%
%      Property: KernelWidth  [ {20} | integer ] Width of
%                             kernel. Should be at least twice the
%                             poisson parameter 
%                ConvType     [ {Skip} | Zeropad | Extend | Wrap ]
%                             Convolution type, ie., what should
%                             be done with the first samples as
%                             they cannot be fully predicted due
%                             to the kernel width.
%                SpatialType  [ {Voxel} | Global ] If the
%                             spatialType is 'voxel' then the
%                             poisson parameter and the amplitude
%                             will be computed individually for
%                             each voxel. If it is 'Global' then
%                             the poisson parameter will be the
%                             same for all voxels.
%
%      Output:   Ampl         Amplitude of kernel
%                Poisson      Poisson parameter
%
%      Main function for linear system identification with a Poisson
%      kernel optimized in the time domain.
%
%      See also LYNGBY, LYNGBY_PDF_POISSON, LYNGBY_POIS_TOPTIM,
%               LYNGBY_UI_POIS_INIT.
%
% $Id: lyngby_pois_main.m,v 1.6 2003/05/23 09:43:20 fnielsen Exp $



    [rT, cT] = size(T);

    
    % Default properties
    kernelWidth = 20;
    convType = 1;
    spatialType = 1;
    
    
    % Read Properties
    n = 1;
    while n <= nargin-2
      eval(sprintf('arg = lower(arg%d);', n));
      if strcmp(arg, 'kernelwidth')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if ~isstr(arg)
	  if length(arg) == 1
	    if arg > 1
	      kernelWidth = arg;
	    else
	      error(sprintf(['''KernelWidth'' should be larger than 1. ' ...
		    'It was: %d'], arg))
	    end
	  else
	    error(['The argument with ''KernelWidth'' should be ' ...
		  'a scalar.']); 
	  end
	else
	  error('The argument with ''KernelWidth'' should be a integer.'); 
	end

      elseif strcmp(arg, 'convtype')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if isstr(arg)
	  if strcmp(arg, 'skip')
	    convType = 1;
	  elseif strcmp(arg, 'zeropad')
	    convType = 2;
	  elseif strcmp(arg, 'extend')
	    convType = 3;
	  elseif strcmp(arg, 'wrap')
	    convType = 4;
	  else
	    error(sprintf('Wrong arg to ''ConvType'': %s', arg))
	  end
	else
	  error('The argument with ''ConvType'' should be a string.'); 
	end
      elseif strcmp(arg, 'spatialtype')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if isstr(arg)
	  if strcmp(arg, 'voxel')
	    spatialType = 1;
	  elseif strcmp(arg, 'global')
	    spatialType = 2;
	  else
	    error(sprintf('Wrong arg to ''SpatialType'': %s', arg))
	  end
	else
	  error('The argument with ''ConvType'' should be a string.'); 
	end

      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    
    Amplitude = zeros(1, cT);
    Poisson = zeros(1,cT);

    lyngby_log('Beginning Poisson filter analysis ...')
    
    if spatialType == 1
      % Individual Poisson and amplitude parameter for each voxel

      for n = 1:cT
	
	t = T(:,n);
	[Ampl(1,n), Poisson(1,n)] = lyngby_pois_toptim(x, t, ...
	    kernelWidth, convType, spatialType);  
	
	if lyngby_mod(n,5)==0,
	  lyngby_log(sprintf('Computing poisson filter: %d / %d', n, cT));
	end;
	
      end
    else
      % Individual amplitude common poisson parameter for voxels

      [Ampl, Poisson] = lyngby_pois_toptim(x, T, ...
	  kernelWidth, convType, spatialType);  
    end














