
% lyngby_prep_global   - Global variables for preprocessing
%
%       script
%
%       Global:	PREP_CENTERING        Centering for a sequence
%               PREP_RUNCENTERING     Centering within runs
%               PREP_IMAGECENTERING   Centering for an image
%               PREP_NORMALIZATION    Normalization
%               PREP_SVDFILTER        SVD filtering
%               PREP_SVDCOMPONENTS    Number of SVD components
%                                     maintained
%
%       Script for making variables global and for initialization in
%       connection with preprocessing.
%
%       See also LYNGBY, LYNGBY_UI_PREPROC, LYNGBY_NORMALIZE.
%
% $Id: lyngby_prep_global.m,v 1.4 2003/06/25 15:33:42 fnielsen Exp $


% These are presently not supported
%		PREP_TEMPGAUSS		Temporal gaussian filtering
%		PREP_SPATGAUSS		Spatial gaussian filtering
%		PREP_SPATGAUSSWIDTH	
%		PREP_TEMPGAUSSWIDTH


    global PREP_CENTERING PREP_RUNCENTERING PREP_IMAGECENTERING ...
	PREP_NORMALIZATION PREP_TEMPGAUSS PREP_SVDFILTER ...
	PREP_SPATGAUSS PREP_SPATGAUSSWIDTH PREP_SVDCOMPONENTS ...
	PREP_TEMPGAUSSWIDTH 
    
    if (exist('PREP_CENTERING') ~= 1) | (isempty(PREP_CENTERING))
      PREP_CENTERING = 1;
      PREP_NORMALIZATION = 0;
      
      PREP_RUNCENTERING = 0;
      if exist('data_run')
	PREP_RUNCENTERING = 1;
      end
      PREP_IMAGECENTERING = 0;	
      
      PREP_TEMPGAUSS = 0;
      PREP_SVDFILTER = 0;
      PREP_SPATGAUSS = 0;
      
      PREP_SPATGAUSSWIDTH = 1;	% !!!
      PREP_SVDCOMPONENTS = 30;
      PREP_TEMPGAUSSWIDTH = 1;	% !!!
    end
    


