function [siz, vdim, datatype] = lyngby_read_header(file)

% lyngby_read_header   - Reads header information of a volume file
%
%	function [siz, vdim, datatype] = read_header(file)
%
%	Input:  file       Filename
%
%	Output: siz        Dimensions vector (number of voxels)
%               vdim       Physical size of a voxel in cm's (header
%                          entry * 0.10)
%               datatype   String compatible with fread to read data,
%                          e.g. 'uchar' 
%
%       Reads the header of an ANALYZE or a VAPET volume file
%	Can also handle '.Z' and '.gz' compression
%
%	See also: lyngby_read_volume, lyngby_readanahdr,
%	          lyngby_readvapethdr 

% cvs : $Id: lyngby_read_header.m,v 1.3 1998/09/03 12:38:39 fnielsen Exp $
%       $Revision: 1.3 $


    fid = fopen(file);
    if fid ~= -1
      fclose(fid);
    else
      fid = fopen([file '.hdr']);
      if fid ~= -1
	fclose(fid);
      else
	
	% Z Compression
	
	fid = fopen([file '.Z']);
	if fid ~= -1
	  fclose(fid);
	  s = sprintf('uncompress -c %s > temp.vapet', file);
	  status = unix(s);
	  if status
	    error(sprintf('Could not perform %s', s));
	  end
	  file = 'temp.vapet';
	else
	  fid = fopen([file '.hdr.Z']);
	  if fid~= -1
	    fclose(fid);
	    s = sprintf('uncompress -c %s.hdr.Z > temp.hdr', file);
	    status = unix(s);
	    if status
	      error(sprintf('Could not perform %s', s));
	    end
	    file = 'temp';
	  else
	    % gzip compression
	    
	    fid = fopen([file '.gz']);
	    if fid~= -1
	      fclose(fid);
	      s = sprintf('gunzip -c %s > temp.vapet', file);
	      status = unix(s);
	      if status
		error(sprintf('Could not perform %s', s));
	      end
	      file = 'temp.vapet';
	    else
	      fid = fopen([file '.hdr.gz']);
	      if fid~= -1
		fclose(fid);
		s = sprintf('gunzip -c %s.hdr.gz > temp.hdr', file);
		status = unix(s);
		if status
		  error(sprintf('Could not perform %s', s));
		end
		file = 'temp';
	      end
	    end
	  end
	end
      end
    end
    
    [siz, vdim, datatype] = lyngby_readanahdr(file);
    if isempty(siz), 
      [siz, vdim, datatype]= lyngby_readvapethdr(file);
    end


















