function [siz, vdim, datatype,matrix] = lyngby_readvahdr4(file);

% lyngby_readvahdr4	- Reads the header information in a 4 dimensional VAPET file 
%
%	function [siz, vdim, datatype,matrix] = lyngby_readvahdr4(file);
%
%	Input:	file      Filename
%
%	Output:	siz       Dimensions vector (number of voxels)
% 		vdim      Physical size of a voxel in cm's (header
% 		          entry * 0.10) 
%		datatype  String compatible with fread to read data,
%		          e.g. 'uchar' 
%		matrix    Returns the 'matrix' field in the VAPET file
%
%	See also LYNGBY, LYNGBY_READ_HEADER, LYNGBY_READVAPETVOL.
%
% $Id: lyngby_readvahdr4.m,v 1.2 2004/06/01 12:30:24 fnielsen Exp $


    f = fopen(file ,'rb');
    if f < 0, 
      vdim=[]; datatype=''; siz=[]; 	% File not found!
      return
    end

    l=fgetl(f);
    if ~strcmp(l,'vaphdr')
      if f > 0, 
	fclose(f);
      end
      vdim=[]; datatype=''; siz=[]; 	% File not vapet format
      return
    end

    fseek(f,0,-1) ; % Rewind
    hh = fread(f, 512,'char');
    rank = sscanf([hh((findstr(hh','rank=')+5):512)' ' '],'%d');

    if prod(size(rank)) ~= 1 ,
      if f > 0, 
	fclose(f);
      end
      vdim=[]; datatype=''; siz=[]; 	% File error
      return
    end
    if rank ~= 0 ,
      if f > 0, 
	fclose(f);
      end
      vdim=[]; datatype=''; siz=[]; 	% File error
      return
    end

    siz	= sscanf([hh((findstr(hh','size=')+5):512)' ' '],'%d', 4);
    vdim	= sscanf([hh((findstr(hh','cmpix=')+6):512)' ' '],'%f', 4);
    data	= sscanf([hh((findstr(hh','data=')+5):512)' ' '],'%c', 1);
    datatype = sscanf([hh((findstr(hh','datatype=')+9):512)' ' '],'%c', 1);
    matrix	= sscanf([hh((findstr(hh','matrix=')+7):512)' ' '],'%d', 2);
    type 	= [data datatype];
    if prod(size(siz)) ~= 3 | prod(size(vdim)) ~= 3 | ...
	  prod(size(type)) ~= 2 | prod(size(matrix)) ~= 2, 
      if f > 0, 
	fclose(f);
      end
      vdim=[]; datatype=''; siz=[]; 	% File error
      return
    end
    if strcmp(type,'1u'),
      datatype='uchar';
    elseif strcmp(type, '2u'),
      datatype='ushort';
    elseif strcmp(type, '1i'),
      datatype='char';
    elseif strcmp(type, '2i'),
      datatype='short';
    elseif strcmp(type, '4f'),
      datatype='float';
    elseif strcmp(type, '8f'),
      datatype='double';
    end

    if f > 0, 
      fclose(f);
    end









