function [siz, vdim, datatype] = lyngby_readvapethdr(file);

% lyngby_readvapethdr	- Reads the header information in a VAPET file 
%
%       function [siz, vdim, datatype] = lyngby_readvapethdr(file);
%
%       Input:  file      Filename
%
%       Output:	siz       Dimensions vector (number of voxels)
% 		vdim      Physical size of a voxel in cm's (header
% 		          entry * 0.10) 
%		datatype  String compatible with fread to read data,
%		          e.g. 'uchar' 
%
%	See also LYNGBY, LYNGBY_READ_HEADER, LYNGBY_READVAPETVOL.
%
% $Id: lyngby_readvapethdr.m,v 1.3 2004/06/01 12:32:55 fnielsen Exp $


    f = fopen(file ,'rb');
    if f < 0, 
      vdim=[]; datatype=''; siz=[]; 	% File not found!
      return
    end

    l=fgetl(f);
    if ~strcmp(l,'vaphdr')
      if f > 0, 
	fclose(f);
      end
      vdim=[]; datatype=''; siz=[]; 	% File not vapet format
      return
    end
    
    fseek(f,0,-1) ; % Rewind
    hh=fread(f, 512,'char');
    rank=sscanf([hh((findstr(hh','rank=')+5):512)' ' '],'%d');
    
    if prod(size(rank)) ~=1 | rank < 1 | rank > 4,
      if f > 0, 
	fclose(f);
      end
      
      vdim=[]; datatype=''; siz=[]; 	% File error
      return
    end
    
    siz = sscanf([hh((findstr(hh','size=')+5):512)' ' '],'%d', rank);
    vdim = sscanf([hh((findstr(hh','cmpix=')+6):512)' ' '],'%f', rank);
    data = sscanf([hh((findstr(hh','data=')+5):512)' ' '],'%c', 1);
    datatype = sscanf([hh((findstr(hh','datatype=')+9):512)' ' '],'%c', 1);
    type = [data datatype];
    if prod(size(siz)) ~= rank | prod(size(vdim)) ~= rank | prod(size(type)) ~= 2,
      if f > 0, 
	fclose(f);
      end
      
      vdim=[]; datatype=''; siz=[]; 	% File error
      return
    end
    if strcmp(type,'1u'),
      datatype = 'uint8';
    elseif strcmp(type, '2u'),
      datatype='uint16';
    elseif strcmp(type, '1i'),
      datatype='int8';
    elseif strcmp(type, '2i'),
      datatype='int16';
    elseif strcmp(type, '4f'),
      datatype='float32';
    elseif strcmp(type, '8f'),
      datatype='float64';
    end

    if f > 0, 
      fclose(f);
    end













