function V = lyngby_readvapetvol(file, siz, datatype)

% lyngby_readvapetvol	- Reads a VAPET volume from a file
%
%	function V = lyngby_readvapetvol(file, siz, datatype)
%
%	Input:	file		Filename
%		siz		Obtained from lyngby_readvapethdr
%		datatype		-
%
%	Output:	V	The volume in a row vector.
%
%	This functions tries to open a file with the name specified
%	with <file>. Then the file is read as a VA PET (Minneapolis)
%	volume file, that is, the volume is a brick of bits after a
%	512 byte large header. Some of the parameters to this function 
%	can be obtained from 'lyngby_readvapethdr'. Users should use
%	the lyngby_read_volume function as it encapsulates this 
%	(lyngby_readvapetvol) function. 
%
%	See also LYNGBY, LYNGBY_READVAPETHDR, LYNGBY_READANAVOL,
%	         LYNGBY_READ_VOLUME. 
%
% $Id: lyngby_readvapetvol.m,v 1.4 2004/06/01 12:33:49 fnielsen Exp $


    fid = fopen(file ,'rb','ieee-be');
    if fid < 0
      error(sprintf('Could not open file: %s', filename)); 
    end
    
    fseek(fid, 512, -1);
    V = fread(fid, prod(siz), datatype)';
    if prod(size(V)) ~= prod(siz)
      if fid > 0
	fclose(fid);
      end
      error(sprintf('Could not read all data: %d, read: %d', ...
	  prod(siz), prod(size(V)))); 
    end  
    if fid > 0
      fclose(fid);
    end








