function [V, Indices] = lyngby_readvavol4(file, matrix, datatype)

% lyngby_readvavol4	- Reads a 4 dimensional VAPET structure from a file
%
%	function [V, Indices] = lyngby_readvavol4(file, matrix, datatype);
%
%	Input:	file		Filename
%		datatype	Obtained from lyngby_readvahdr4
%		matrix			-
%
%	Output:	V	The volume in a row vector, Nothing is
%			returned if the volume size does not fit <siz>
%		Indices	0 relative indices
%
%	This functions tries to open a file with the name specified
%	with <file>. Then the file is read as a VA PET (Minneapolis)
%	4 dimensional file, Some of the parameters to this function 
%	can be obtained from 'lyngby_readvahdr4'. 
%
%	See also LYNGBY, LYNGBY_READVAHDR4, LYNGBY_READVAPETHDR,
%                LYNGBY_READANAVOL. 
%
% $Id: lyngby_readvavol4.m,v 1.2 2004/06/01 12:35:30 fnielsen Exp $

	if length(matrix) ~= 2
		return
	elseif size(matrix,1) == 2
		matrix = matrix';	% the fread function wants row vector
	end

	f = fopen(file ,'rb','ieee-be');
	if f < 0, 
		V=[]; 				% File not found!
  		if f > 0,
    			fclose(f);
  		end
  		return
	end

	fseek(f, 512, -1);

	Indices = fread(f, matrix(1,1), 'long');
	V = fread(f, matrix, datatype);
	if prod(size(V)) ~= prod(matrix),
		V=[];
	end  
	if f > 0,
		fclose(f);
	end









