function X = lyngby_readxpivol(filename, siz, datatype, arg1, arg2, ...
    arg3, arg4, arg5, arg6);

% lyngby_readxpivol    - Read data from EC flexible (Xprime) format
% 
%       function X = lyngby_readxpivol(filename, siz, datatype,
%           'PropertyName', PropertyValue);
%
%       Input:  filename  With or without extension (.xpi)
%               siz       4 element vector
%               datatype  The type read by lyngby_readxpihdr
%               PropertyNames
%                   'TimeMask'  { 1 } Within-file time mask 
%
%       Output: X         Datamatrix 
%
%       Complex numbers cannot be read. Reads the data as big-endian.
%       Assumes that the data stored as siz(4) frames with the size of
%       siz(1) by siz(2). 
%
%       See also: lyngby_readxpihdr

% cvs: $Id: lyngby_readxpivol.m,v 1.4 1997/07/23 13:11:23 fnielsen Exp $
%      $Revision: 1.4 $


    % Default values
    TimeMask = 1; 

    % Parse!
    n = 1;
    while n < nargin-3
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'timemask')
        n = n + 1;
        eval(sprintf('arg = arg%d;', n));
        if ~issparse(arg) 
          error(['Property value to ''TimeMask'' should be a ' ...
                'sparse matrix']);
        elseif size(arg,2) ~= siz(4) 
          error(sprintf(['Property value to ''TimeMask'' should have a ' ...
                'sparse with the same number of columns as the ' ...
		'siz(4). Timemask: %d, siz(4): '], size(arg,2), siz(4)));
	elseif size(arg,1) > size(arg,2)
	  error(sprintf(['Property value to ''TimeMask'' should have a ' ...
		'sparse matrix with rows <= columns. ' ...
		'size: %dx%d '], size(arg)));
	else
          TimeMask = arg;
        end
      else
        error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end


    % Check file
    filenamex = filename;
    fid = fopen(filenamex, 'rb');
    if fid < 0
      filenamex = [ filename '.xpi' ];
      fid = fopen(filenamex, 'rb');
      if fid < 0, 
        dim=[]; datatype=''; siz=[];    % File not found!
        error(sprintf('Neither %s or %s found', filename, filenamex))
        if fid > 0,
          fclose(fid);
        end
        return
      end
    end

    %  Find end of header
    searchstr = '#_End_of_Header.';
    endofh = lyngby_filefind(filenamex, searchstr) + max(size(searchstr))-1;
    if ~endofh
      error(sprintf([ 'Could not find ''%s'' in ' ...
	    'file %s ' ], searchstr, filenamex));
    end

    % Open file as big endian
    fid = fopen(filenamex, 'r', 'b');

    % Define image dimensions
    nPixels = siz(1) * siz(2);
    if issparse(TimeMask)
      X = zeros(size(TimeMask,1), nPixels);
    else
      X = zeros(siz(4), nPixels);
    end
    
    % Read file data
    fseek(fid, endofh, -1);
    if (1==0)
      % Complex data should also be handled!!! - disabled 
      idxR = 1:2:(2*nPixels);
      idxI = 2:2:(2*nPixels);
      linebuff = fread(fid, nPixels*2, datatype);
      X = linebuff(idxR) + j*linebuff(idxI);    
      X = reshape(X,nPixels, size(4))'; 
    else
      % non-complex 
      if issparse(TimeMask)
	if 1 == 1
	  [M,N] = find(TimeMask);
	  if strcmp(datatype, 'uchar')
	    bytePerDatatype = 1;
	  elseif strcmp(datatype, 'short')
	    bytePerDatatype = 2;
	  elseif strcmp(datatype, 'long')
	    bytePerDatatype = 4;
	  elseif strcmp(datatype, 'float64')
	    bytePerDatatype = 8;
	  elseif strcmp(datatype, 'float32')
	    bytePerDatatype = 4;
	  end
	  for n = 1:length(N)
            fseek(fid, endofh + nPixels*(N(n)-1)*bytePerDatatype, 'bof');
	    X(n,:) = fread(fid, nPixels, datatype)';
	  end
	else
	  % cputime = 5.8
	  X = TimeMask * reshape(fread(fid, nPixels*siz(4), ...
	      datatype), nPixels, siz(4))';
	end
      else
	X = reshape(fread(fid, nPixels*siz(4), datatype), nPixels, siz(4))';
      end
    end 
    fclose(fid);
    























