function M = lyngby_roi2vmask(arg1, arg2, arg3, arg4, arg5)

% lyngby_roi2vmask     - Transform ROI definition to masking matrix
%
%	function M = lyngby_roi2vmask('PropertyName', PropertyValue)
%
%	Input:	PropertyNames
%                   'ROI'        { ROI_VOXELS } ROI
%                   'NumVoxels'  { NUM_VOXELS } Number of voxels 
%
%	Output:	M   Sparse masking matrix
%
%       See also: lyngby_global

%	1997-07-22	fnielsen	Initial version

% cvs :  $Revision: 1.2 $
%        $Id: lyngby_roi2vmask.m,v 1.2 1997/09/30 14:18:05 fnielsen Exp $

    lyngby_global


    % Default values
    ROI = ROI_VOXELS;
    numVoxels = NUM_VOXELS; 

    % Parse
    n = 1;
    while n < nargin
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'numvoxels')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if isstr(arg) 
	  error(sprintf(['Property value to ''NumVoxels'' should be a ' ...
		'vector. Is a string: ''%s'''], arg));
	elseif length(arg) ~= 3 
	  error(sprintf(['Property value to ''NumVoxels'' should be a ' ...
		'3 element vector. Length: %d'], length(arg)));
	elseif any(arg <= 0)
	  error(sprintf(['Property value to ''NumVoxels'' should be ' ...
		'larger than zero. It is: %f %f %f'], arg));
	else
	  numVoxels = arg;
	end
      elseif strcmp(arg, 'roi')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if isstr(arg) 
	  error(sprintf(['Property value to ''ROI'' should be a ' ...
		'vector. Is a string: ''%s'''], arg));
	elseif size(arg) ~= [3 2] 
	  error(sprintf(['Property value to ''ROI'' should be a ' ...
		'3 element vector. size: %dx%d'], size(arg)));
	elseif any(arg <= 0)
	  error(sprintf(['Property value to ''ROI'' should be ' ...
		'larger than zero.']));
	else
	  ROI = arg;
	end
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    x = ROI(1,1):ROI(1,2);
    y = ROI(2,1):ROI(2,2);
    z = ROI(3,1):ROI(3,2);
    yy = numVoxels(1)*(y-1);
    zz = prod(numVoxels(1:2))*(z-1);
    xy = kron(ones(size(y)),x)+kron(yy,ones(size(x)));
    xyz = kron(ones(size(zz)),xy)+kron(zz,ones(size(xy)));
    M = lyngby_index2vmask(xyz, prod(numVoxels));
    



    
    
    







