function R = lyngby_run();

% lyngby_run	       - Returns the run specification
%
%       function R = lyngby_run();
%
%       Output: R   The run in a column vector 
%                   The indices correspond to the indices 
%                   in the lyngby_getvolume function
%
%       This function will first try to read a file 'data_run.mat' 
%       which should contain a 'RUN' variable. If it is not defined 
%       the it will try the function data_run.m. Still, if this not 
%       succeed it will finally try the file data_run.txt. 
%       The user should define one of the function/files. 
%       The length of the run specification should be of the same 
%       length as the one aquired from lyngby_paradigm. 
%  
%       Example:
%           The run specification for a small 4-run study with 3 scans
%           per run could be: 
%
%           RUN = [ 1 1 1 2 2 2 3 3 3 4 4 4 ]';
%
%       See also LYNGBY, LYNGBY_PARADIGM, LYNGBY_GETVOLUME
%
% $Id: lyngby_run.m,v 1.10 2004/03/22 17:03:02 fnielsen Exp $ 


    if exist('data_run.mat') == 2
      load data_run.mat
      if exist('RUN') == 1          % check for variable not the 'run.m' function 
	if ~length(RUN) 
	  error('data_run.mat file did not contain any values.');
	else
	  R = RUN;
	end
      else
	error('The data_run.mat file does not contain the run variable RUN');
      end
    
    elseif exist('data_run') == 2

      clear data_run
      eval('R = data_run;');
      if ~length(R)
	error('data_run function did not give any values.');
      end
      
    elseif exist('data_run.txt') == 2
      load data_run.txt
      if exist('data_run') == 1
	if length(data_run) > 0
	  R = data_run;
	else
	  error('The data_run.txt file did not contain any values.');
	end
      else
	error('Could not load from data_run.txt');
      end
    elseif exist('RUN') == 1
      if ~length(RUN) 
        error('RUN specified but length was zero');
      else
        R = RUN;
      end
    else      
      R = [];
      %error('The user should provide a ''data_run'' function');
    end

    % The user might have entered the values the wrong way
    if size(R,1) < size(R,2)
      R = R';
    end










