function [Runs, ScansPerRun] = lyngby_runinfo(Run)

% lyngby_runinfo       - Number of runs and scans within runs
%
%       function [Runs, ScansPerRun] = lyngby_runinfo(Run)
%
%       Input:  Run           (Optional) Run definition. If it is not
%                             defined 'R' from lyngby_ui_global will
%                             be used. 
%
%       Output: Runs          Number of runs
%               ScansPerRun   Number of scans per run. If there are
%                             different number of scans per run this
%                             will be a vector.
%
%       If there is no run defined then Runs = 1 will be returned, and
%       ScansPerRun will be sat to the size of P or X.
%
%       See also: lyngby_ui_global, lyngby_run

% cvs : $Id: lyngby_runinfo.m,v 1.3 1997/10/01 15:29:21 fnielsen Exp $
%       $Revision: 1.3 $


    if nargin < 1
      lyngby_ui_global
      
      if isempty(R)
	Runs = 1;
	if isempty(P)
	  if isempty(X)
	    error('R, P or X is not defined');
	  else
	    ScansPerRun = size(X,1);
	  end
	else
	  ScansPerRun = length(P);
	end
	return
      else
	Run = R;
      end
    end

    if isempty(Run)
      Runs = [];
      ScansPerRun = [];
    else
      Rcut = Run;
      Runs = 1;
      while length(Rcut) > 0
	run = Rcut(1);
	Rcut = Rcut(find(Rcut~=run));
	ScansPerRun(Runs) = sum(Run == run);
	Runs = Runs + 1;
      end
      Runs = Runs - 1;
      
      if all(ScansPerRun == ScansPerRun(1))
	ScansPerRun = ScansPerRun(1);
      end
    end

      




















