function Y = lyngby_sdesign(R);

% lyngby_sdesign       - Strother design matrix
%
%	function Y = lyngby_sdesign(R)
%
%       Input:  R   The run structure
%
%       Output: Y   The design matrix
%
%       The Strother design matrix is a matrix with the number of rows
%       as the number of scans and the number of columns as the number
%       of scans within a run minus one.
%
%       The first column in the datamatrix contains ones in all the
%       rows that correspond to the first scan in all runs.
%       The second column contains ones in all the rows that
%       correspond to the second scan in all runs, and so on.
%
%       See also LYNGBY, LYNGBY_SOP_MAIN.
% 
% $Id: lyngby_sdesign.m,v 1.5 2004/09/06 08:32:29 fnielsen Exp $


    
    [Runs, ScansPerRun] = lyngby_runinfo(R);
    if length(ScansPerRun) == 1
      Y = zeros(length(R), ScansPerRun);
      I = (1 == mod(lyngby_kronadd([(ScansPerRun):-1:1]', ...
	  kron(ones(1,Runs),[1:ScansPerRun])), ScansPerRun))';
      Y(I) = 1;
    elseif length(ScansPerRun) > 1
      error('Sorry, cannot handle runs with a varying number of scans');
      Y = zeros(length(R), Runs);
      Rcut = R;
      n = 1;
      while length(Rcut) > 0
	run = Rcut(1);
	Rcut = Rcut(find(Rcut~=run));
	indices = find(R == run);
	Y(indices, n) = 1;
	n = n + 1;
      end
    end
    


