function Sout = lyngby_set_and(S1, S2);
                             
% lyngby_set_and       - set intersection: S1 /\ S2
%
%       function Sout = lyngby_set_and(S1, S2);
%
%       Input:  S1   First set
%               S2   Second set
%
%       Output: S    Set intersect, element will be sorted
%
%       See also: intersect (in Matlab5)

% cvs : $Id: lyngby_set_and.m,v 1.1 1997/09/09 08:45:03 fnielsen Exp $
%       $Revision: 1.1 $

    S1 = sort(S1);
    S2 = sort(S2);
    
    Ns1 = prod(size(S1));
    Ns2 = prod(size(S2));
    
    c1 = 1;
    c2 = 1;
    co = 1;
    Sout = [];
    while (c1 <= Ns1) & (c2 <= Ns2);
      if (S1(c1) == S2(c2))  		
	Sout(co) = S1(c1);
	co = co + 1;
	c1 = c1 + 1;
	c2 = c2 + 1;
      elseif (S1(c1) < S2(c2))
	c1 = c1 + 1;
      else
	c2 = c2 + 1;
      end
    end 


