function Sout = lyngby_set_diff(S1, S2);

% lyngby_set_diff      - set difference: S1 \ S2
%
%       function Sout = lyngby_set_diff(S1, S2);
%
%       Input:  S1     First set
%               S2     Second set
%
%       Output: Sout   Set difference
%
%       See also: lyngby_set_and, setdiff (in Matlab5)

% cvs : $Id: lyngby_set_diff.m,v 1.4 1997/09/24 08:31:26 fnielsen Exp $
%       $Revision: 1.4 $


    Ns1 = prod(size(S1));
    Ns2 = prod(size(S2));

    if size(S1, 1) == Ns1
      S1 = S1';
    elseif size(S1, 2) ~= Ns1
      error('S1 must be a vector');
    end
    if length(S2) ~= Ns2
      error('S2 must be a vector');
    end
    
    S1 = sort(S1);
    S2 = sort(S2);

    Sout = [];
    
    c1 = 1;
    c2 = 1;
    co = 1;
    while (c1 <= Ns1) & (c2 <= Ns2);
      if (S1(c1) == S2(c2))  	
	c1 = c1 + 1;
	c2 = c2 + 1;	
      elseif (S1(c1) < S2(c2))
	Sout(1,co) = S1(c1);
	co = co + 1;
	c1 = c1 + 1;
      else
	c2 = c2 + 1;
      end
    end 
    if (c1 <= Ns1) & (c2 > Ns2)
      Sout = [Sout S1(c1:Ns1)];
    end
    
    





