function Sout = lyngby_set_unique(S);

% lyngby_set_unique    - Set thining: all elements different
%
%       function Sout = lyngby_set_unique(S);
%
%       Input:  S      Set to be thinned (vector)
%
%       Output: Sout   Thinned set, sorted
%
%       Removal of all redundant elements, and the returned elements
%       will sorted, eg, lyngby_set_unique([7 3 5 2 3 2 ]) will return
%       [ 2 3 5 7 ]
%
%       See also: lyngby_set_and, lyngby_set_diff, unique (matlab5)

% cvs : $Id: lyngby_set_unique.m,v 1.2 1999/03/23 10:42:22 fnielsen Exp $
%       $Revision: 1.2 $

    S = sort(S);
	
    Ns = prod(size(S));
    
    if Ns == 0
      Sout = [];
      return;
    end
    
    Sout(1) = S(1);
    
    c = 2;
    co = 1;
    while (c <= Ns);
      if (S(c) == Sout(co))  		
	c = c + 1;
      else	
	co = co + 1;
	Sout(co) = S(c);
	c = c + 1;
      end
    end 

