function [indexones,indexzeros] = lyngby_splitonnoff(Pa,edgedrop)

% lyngby_splitonnoff   - Function to find the indices of the on/off scans.
%
%       function [indexones,indexzeros] = lyngby_splitonnoff(Pa,edgedrop)
%
%       Input:  Pa         The paradigm
%               edgedrop   Scans to discard at the shifts of activation
%
%       Output: indexones   Indices to 'on' scans 
%               indexzeros  Indices 'off' Scans
%       
%       This function will return the indices of the scans that are
%       on/off - here assumed to threshold at 0 (normally binary
%       activation so no problem). The paradigm Pa will have its mean
%       subtracted by the function. The parameter EDGEDROP will drop
%       EDGEDROP scans at any change from on to off and likewise from
%       an off to an on condition.
%
%       Assumes base scans is first.

% cvs : $Id: lyngby_splitonoff.m,v 1.6 1997/09/09 14:37:02 fnielsen Exp $
%       $Revision: 1.6 $    


if exist('edgedrop')~=1,
  edgedrop = 0;
end

Pa=Pa-mean(Pa);

indexones = find(Pa>0);
indexzeros = find(Pa<0);
toon_edge = find(diff(Pa) > 0);
tooff_edge = [1;1+find(diff(Pa) < 0)];   % Assuming zeros first
if (edgedrop>0)
  ed = ones(edgedrop,1);
  edl = (0:edgedrop-1)';
  dropon_index = kron(toon_edge,ed)+kron(ones(size(toon_edge)),edl);
  dropoff_index = kron(tooff_edge,ed)+kron(ones(size(tooff_edge)),edl);
  indexones = lyngby_set_diff(indexones,dropon_index);
  indexzeros = lyngby_set_diff(1+indexzeros,dropoff_index)-1;
end;  










