function [Xnew, V] = lyngby_svdfilter(X, arg1, arg2, arg3, arg4, ...
    arg5, arg6, arg7, arg8) 

% lyngby_svdfilter     - Filtering by SVD
%
%       function [Xnew, V] = lyngby_svdfilter(X, ...
%           'PropertyName', 'PropertyValue')
%
%	Input:	X      Matrix to be filtered
%		Property:
%                  'FilterComp'   { all } Number of filtering
%                                 components
%
%       Output: Xnew   Filtered matrix  
%               V      The rotation (eigenmatrix) used for the SVD
%
%       Filtering by singular value decomposition. The filtering is
%       done by "bottlenecking" the matrix X through 'FilterComp'
%       number of principal components.
%
%       See also: lyngby_svd

% cvs : $Id: lyngby_svdfilter.m,v 1.4 1998/12/22 15:38:22 fnielsen Exp $ 
%       $Revision: 1.4 $

    [nt, nv] = size(X);

    filterComponents = -1;

    n = 1;
    while n < nargin-1
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'filtercomp')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	filterComponents = arg;
	if filterComponents < 1
	  error(['The number of filter components ' ...
		'should a value larger or equal to 1.'])
	end
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end


    [rows, columns] = size(X);

    if rows < columns
      if filterComponents == -1
	filterComponents = nt;
      end

      [V,D] = eig(X*X');
      [D,I] = sort(-diag(D));
      
      V = [ V(:,I(1:filterComponents)) ];
      Xnew = V * V' * X;

    else 
      if filterComponents == -1
	filterComponents = nv;
      end

      [V,D] = eig(X'*X);
      [D,I] = sort(-diag(D));

      V = [ V(I(1:filterComponents),:) ];
      Xnew = X * V' * V;

    end











