function Vnew = lyngby_swaporder(Vold, order) 

% lyngby_swaporder	- Swap the xyz order in a volume 
%
%	function V = lyngby_swaporder(V, order) 
%
%	Input:	Vold	The originale volume in a vector
%		order	The new ordering: 'yxz', 'zyx', or 'xzy'
%
%	Output:	Vnew	The swaped volume in a vector
%
%	Is not able to handle masked volumes

%	Date		Author		Version
%	1996-11-20	fnielsen	Initial version
%	1996-11-25	fnielsen	Renamed: lyngby_swapdirect lyngby_swaporder

% cvs :  $Revision: 1.1.1.1 $
	lyngby_global;


	if length(Vold) == prod(NUM_VOXELS)
		% disp('Full volume');		

		x = 1:NUM_VOXELS(1);
		y = 0 : NUM_VOXELS(1) : NUM_VOXELS(1)*(NUM_VOXELS(2)-1);
		z = 0 : NUM_VOXELS(1)*NUM_VOXELS(2) : NUM_VOXELS(1)*NUM_VOXELS(2)*(NUM_VOXELS(3)-1);
		if strcmp(order,'yxz'),
			Vnew = Vold(lyngby_kronadd(z, lyngby_kronadd(x,y)));
		elseif strcmp(order,'yzx'),
			Vnew = Vold(lyngby_kronadd(x, lyngby_kronadd(z,y)));
                      elseif strcmp(order,'xzy'),
			Vnew = Vold(lyngby_kronadd(y, lyngby_kronadd(z,x)));
		else
			error('Cannot recognize the specification for order'); 
		end		
	elseif ~isempty(ROI_VOXELS)
		numVoxels = ROI_VOXELS(:,2) - ROI_VOXELS(:,1) + 1;
		if length(Vold) == prod(numVoxels)
			% disp('ROIed volume')

			x = 1 : numVoxels(1);
			y = 0 : numVoxels(1) : numVoxels(1)*(numVoxels(2)-1);
			z = 0 : numVoxels(1)*numVoxels(2) : numVoxels(1)*numVoxels(2)*(numVoxels(3)-1);

			if strcmp(order,'yxz'),
				Vnew = Vold(lyngby_kronadd(z, lyngby_kronadd(x,y)));
			elseif strcmp(order,'yzx'),
				Vnew = Vold(lyngby_kronadd(x, lyngby_kronadd(y,z)));
                              elseif strcmp(order,'xzy'),

				Vnew = Vold(lyngby_kronadd(y, lyngby_kronadd(z,x)));
			else
				error('Cannot recognize the specification for order'); 
			end	

		elseif length(Vold) == size(VOXEL_MASK, 2)
			% disp('ROIed and irregularmasked volume')
		end
	elseif length(Vold) == size(VOXEL_MASK, 2)
		% disp('irregularmasked volume')
	else
		% disp('Not full, ROIed or masked Volume')
	end









