function P = lyngby_test_fishersg(X, varargin)

% lyngby_test_fishersg - Test with Fisher's g
%
%       P = lyngby_test_fishersg(X)
%
%       Input:  X   Data matrix X(N x P) in time domain with N samples 
%                   for each of the P variables
%
%       Output: P   Lower tail area for each column
%
%       This function Fourier transforms each column, finds the
%       periodogram and computes a lower tail probability according to
%       the Fisher's G.
%
%       See also LYNGBY, LYNGBY_CDF_FISHERSG, LYNGBY_TEST_WILRANK.
%
% $Id: lyngby_test_fishersg.m,v 1.4 2003/09/12 14:59:59 fnielsen Exp $


    % Check input arguments
    if nargin < 1
      error('Too few input arguments')
    end

    
    % Fourier transformation 
    F = fft(X', [], 2);
    
    % Periodogram
    PG = abs(F(:,2:ceil(size(X,1)/2))).^2;

    % Fisher's g
    G = max(PG, [], 2) ./ (sum(PG,2) + realmin);
    
    % Compute P-value
    for p = 1:size(G,1)
      if G(p) 
	P(1,p) = lyngby_cdf_fishersg(G(p), size(PG,2));
      else
	% If the entire sequence is zero the G is zero and so should P
	% be. 
	P(1,p) = 0;
      end
	
      if ~mod(p,100)
	lyngby_log(sprintf('Fisher''s G %d/%d', p, size(G,1)));
      end
    end




