function Indices = lyngby_tmask2index(Tmask, itype)

% lyngby_tmask2index	- Return time mask from indices
%
%	function Indices = lyngby_tmask2index(Tmask, itype)
%
%	Input:	Tmask	a time mask (a sparse matrix)
%		itype	(Optional) [ {1} | 0 ]  Indicator for one- or
%		        zero-indexed 
%
%	Output:	Indices	Indices for all timesamples that will be in
%	        the masked sequence 
%
%	See also LYNGBY, LYNGBY_INDEX2TMASK, LYNGBY_VMASK2INDEX.
%
% $Id: lyngby_tmask2index.m,v 1.2 2004/06/01 12:28:00 fnielsen Exp $

if nargin < 2
  itype = 1;
end

[dummy, Indices] = find(Tmask);
if itype ~= 1
  Indices = Indices - (1-itype);
end






