function lyngby_ui_baf_init(command,parameter1) 

% lyngby_ui_baf_init   - Ardekani's F-test, GUI for init. of param.
%
%	function lyngby_ui_baf_init(command,parameter1)
%	function lyngby_ui_baf_init
%
%       This function controls the graphical user interface for the
%       initialization/setup of parameters to the Ardekani F-test.
%
%       See also: lyngby_baf_test, lyngby_baf_global
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_baf_init.m,v 1.15 1999/06/04 15:59:24 mgl Exp $
%       $Revision: 1.15 $


    lyngby_ui_option;
    lyngby_baf_global;

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editComponents')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editErrorlevel')) 
	command = 5; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_baf_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_baf_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonApply = handle_list(4); 
	buttonHelp = handle_list(5); 
	buttonClose = handle_list(6); 
	editComponents = handle_list(7); 
	textComponents = handle_list(8); 
	editErrorlevel = handle_list(9); 
	textErrorlevel = handle_list(10); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 200 ],... 
	  'resize','On','tag','lyngby_ui_baf_init',... 
	  'menubar','Figure','name','lyngby - Ardekani F-test analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.12;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.32; % Lower buttons
      Row3 = 0.48; % Middle buttons
      Row4 = 0.54; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.82; % Upper title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width

      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_baf_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the Ardekani F-test algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.9 0.25 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
       
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_baf_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_baf_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_baf_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      
      textComponents = uicontrol(... 
	  'CallBack','lyngby_ui_baf_init(''textComponents'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','center',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row3 LabelWidth ButtonHeight ],... 
	  'String','No. of Components:',... 
	  'Style','text',... 
	  'Tag','textComponents',... 
	  'UserData',''); 
      editComponents = uicontrol(... 
	  'CallBack','lyngby_ui_baf_init(''editComponents'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editComponents',... 
	  'UserData',''); 
      textErrorlevel = uicontrol(... 
	  'CallBack','lyngby_ui_baf_init(''textErrorlevel'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','center',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row2 LabelWidth ButtonHeight ],... 
	  'String','Test errorlevel:',... 
	  'Style','text',... 
	  'Tag','textErrorlevel',... 
	  'UserData',''); 
      editErrorlevel = uicontrol(... 
	  'CallBack','lyngby_ui_baf_init(''editErrorlevel'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row2 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editErrorlevel',... 
	  'UserData',''); 

      set(editComponents, 'String', num2str(BAF_COMPONENTS));
      set(editErrorlevel, 'String', num2str(BAF_ERRORLEVEL));


      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonHelp buttonClose ... 
	  editComponents textComponents ... 
	  editErrorlevel textErrorlevel ... 
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [baf_components, count1] = sscanf(get(editComponents, 'String'), '%d'); 
      [baf_errorlevel, count2] = sscanf(get(editErrorlevel, 'String'), '%f'); 
      if (count1==1 & baf_components >= 0) 
	BAF_COMPONENTS = baf_components; 
      else 
	error('Components must be integer and non-negative.'); 
      end 
      if (count2==1 & baf_errorlevel > 0) 
	BAF_ERRORLEVEL = baf_errorlevel;
      else 
	error('The errorlevel must be positive.'); 
      end 
      
    elseif command == 2 
      %disp('buttonHelp selected.') 

      s1 = [ ...
	    'This window allows you to setup the ' ...
	    'parameters of Barbak Ardekani''s F-test analysis. ' ...
	    ];
      s2 = [ ...
	    '* ''Components''  is the number of '...
	    'Fourier-components included in the analysis. ', ...
	    ];
      s3 = [ ...
	    '* ''Test error-level''  is the p-value cut-off value. ' ...   
	    ];
      s10 = [ ...
	    'Function: lyngby_ui_baf_init' ...   
	    ];
      s11 = [ ...
	    'See also: lyngby_baf_main' ...   
	    ];

      helpdlg(sprintf('%s\n\n%s\n\n%s\n\n%s\n%s', s1, s2, s3, s10, s11), ...
	  'Barbak Ardekani''s F-test Initialization help');
      
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command == 4 
      %disp('editComponents selected.') 

    elseif command == 5 
      %disp('editErrorlevel selected.') 

    else 
      error('Error: lyngby_ui_baf_init.m called with incorrect command.') 
    end 





