function lyngby_ui_cc_init(command,parameter1) 

% lyngby_ui_cc_init    - User interface for init. of cross-correlation
%
%	function lyngby_ui_cc_init(command,parameter1)
%       function lyngby_ui_cc_init
%       
%       The 'number of components' are the number of cross-correlation
%       parameters that is to be returned from the computing function.
%
%       See also: lyngby_xcorr, lyngby_ui_main
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Created: 5-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_cc_init.m,v 1.15 1999/06/04 15:57:27 mgl Exp $ 
%       $Revision: 1.15 $

    lyngby_cc_global;
    lyngby_ui_option;
    
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editComponents')) 
	command = 4; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 5; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_cc_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_cc_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonApply = handle_list(4); 
	buttonClose = handle_list(5); 
	editComponents = handle_list(6); 
	textComponents = handle_list(7); 
	buttonHelp = handle_list(8); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 200 ],... 
	  'resize','On','tag','lyngby_ui_cc_init',... 
	  'menubar','Figure','name','lyngby - Cross-correlation analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.12;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.26; % Lower buttons
      Row3 = 0.40; % Middle buttons
      Row4 = 0.54; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.82; % Upper title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the cross-correlation algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.9 0.25 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
            
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''buttonApply'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''buttonClose'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textComponents = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''textComponents'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_BACK,... 
	  'HorizontalAlignment','left',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row3 LabelWidth ButtonHeight ],... 
	  'String','No of Components:',... 
	  'Style','text',... 
	  'Tag','textComponents',... 
	  'UserData',''); 
      editComponents = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''editComponents'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editComponents',... 
	  'UserData',''); 
      
      set(editComponents, 'String', num2str(CC_COMPONENTS));


      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonClose ... 
	  editComponents textComponents buttonHelp ... 
	    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [cc_components, count1] = sscanf(get(editComponents, 'String'), '%d'); 
      if (count1==1 & cc_components > 0) 
	CC_COMPONENTS = cc_components; 
      else 
	error('Components must be integer and larger than 0.'); 
      end 
      
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command == 4 
      %disp('editComponents selected.') 

    elseif command == 5
      %disp('buttonHelp selected.') 
      s1 = [...
            'This window allows you to choose the parameters used in ' ...
            'the Cross correlation method:'...
            ];
%      s2 = [...
%            ' * Number of components in the cross correlation function.' ...
%            ' Choosing a value of one means one lag 0 is determined.'...
%            ' More will be positioned centered around lag 0.'...
%            ];

        s2 = [...
	    '* Number of components in the cross-correlation function. '...
	    'Choosing a value of one means one lag, of value 0, is '...
	    'determined. Choosing a value of 10 will mean that 10 '...
	    'lags will be used, centred around the zero lag point.'...
	    ];
        s3 = [...
            'Function: lyngby_ui_cc_init' ...
            ];

      helpdlg(sprintf('%s\n\n%s\n\n%s', s1, s2, s3),...
      'Initialization of Cross correlation parameters')   
      

    else 
      error('Error: lyngby_ui_cc_init.m called with incorrect command.') 
    end 





