function lyngby_ui_cc_view(command,parameter1) 

% lyngby_ui_cc_view	- User interface for viewing Cross-correlation results
%
%	function lyngby_ui_cc_view(command,parameter1)
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%	Date		Author		Version
%	1996-11-13	fnielsen	Initial version, based on lyngby_ui_fir_view
%	1996-11-22	fnielsen	Now assumes RESULT_CC is in timedomain

%  Created: 8-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Author :  
%  Mods.  :  
%   

%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs :  $Revision: 1.4 $

	lyngby_global
	lyngby_ui_global
	lyngby_ui_option

	
	% Supposed to be storage efficient!?: max([max(max(RESULT_CC)) -min(min(RESULT_CC))])

	UpdateRight = [...
		'voxel3 = get(textVoxel, ''UserData'');',...
		'voxel = lyngby_full2mask(voxel3);',...
		'if ~isempty(voxel)',...
			'axes(axesRight);',...
			'lag = size(RESULT_CC,1)/2 - 0.5;',...
			'plot(ceil(-lag):ceil(lag),RESULT_CC(:,voxel));',...
			'title(sprintf(''[%d, %d, %d], Voxel %d'', voxel3,voxel));',...
			'maxabs = max([max(max(RESULT_CC)) -min(min(RESULT_CC))]);',...
			'axis([ceil(-lag) ceil(lag) -maxabs maxabs]);',...
		'end,',...
	];

	VoxelClick = [ ...
		'gca = axesLeft;',...
		'Point = round(get(gca, ''currentPoint''));',...
		'if get(popupPlane, ''Value'') == 3,',...
			'set(textVoxel, ''UserData'', [Point(1,1) Point(1,2) str2num(get(textLeft, ''String''))]);',...
		'elseif get(popupPlane, ''Value'') == 2,',...
			'set(textVoxel, ''UserData'', [Point(1,1) str2num(get(textLeft, ''String'')) Point(1,2)]);',...
		'else,',...
			'set(textVoxel, ''UserData'', [str2num(get(textLeft, ''String'')) Point(1,1) Point(1,2)]);',...
		'end,',...
		'eval(UpdateRight);'...
	];

	% The Volume to be viewed is in the 'popupTime' UserData
	
	UpdateLeftImage = [ ...
		'dim = lyngby_roi;',...
		'planeType = get(popupPlane, ''Value'');',...
		'RayType = get(popupRay, ''Value'');',...
		'TimeType = get(popupTime, ''Value'');',...
		'if RayType == 1,',...
			'sliceType = str2num(get(textLeft, ''String''));',...
		'elseif RayType == 2,',...
			'sliceType = ''mean'';',...
		'else,',...
			'sliceType = ''max'';',...
		'end,',...
		'if planeType == 1,',...
			'I = lyngby_getslice(get(popupTime,''UserData''), ''s'', sliceType);',...
			'firstCoords = dim(2,1):dim(2,2);',...
			'secondCoords = dim(3,1):dim(3,2);',...
			'planeString = ''Sagittal'';',...
		'elseif planeType == 2,',...
			'I = lyngby_getslice(get(popupTime,''UserData''), ''c'', sliceType);',...
			'firstCoords = dim(1,1):dim(1,2);',...
			'secondCoords = dim(3,1):dim(3,2);',...
			'planeString = ''Coronal'';',...
		'elseif planeType == 3,',...
			'I = lyngby_getslice(get(popupTime,''UserData''), ''t'', sliceType);',...
			'firstCoords = dim(1,1):dim(1,2);',...
			'secondCoords = dim(2,1):dim(2,2);',...
			'planeString = ''Transversal'';',...
		'end,',...
		'axes(axesLeft);',...
		'lyngby_image(firstCoords, secondCoords, I);',...
		'set(findobj(axesLeft, ''Type'', ''image''), ''ButtonDownFcn'', ''lyngby_ui_cc_view(1000)'');',...
		'if ~isstr(sliceType),',...
			'sliceType = [''slice '' num2str(sliceType)];',...
		'end,',...
		'if TimeType == 1,',...
			'timeString = ''Mean'';',...
		'elseif TimeType == 2,',...
			'timeString = ''Std Dev.'';',...
		'elseif TimeType == 3,',...
			'timeString = ''Energy'';',...
		'elseif TimeType == 4,',...
			'timeString = ''Max correlation'';',...
		'end,',...
		'title([timeString '', '' planeString '', '' sliceType]);',...				
	];

	UpdateLeft = [ ...
		'PlaneType = get(popupPlane, ''Value'');',...
		'RayType = get(popupRay, ''Value'');',...
		'TimeType = get(popupTime, ''Value'');',...
		'if TimeType == 1,',...
			'set(popupTime, ''UserData'', X_MEAN);',...
		'elseif TimeType == 2,',...
			'set(popupTime, ''UserData'', X_STD);',...
		'elseif TimeType == 3,',...
			'set(popupTime, ''UserData'', sum(RESULT_CC.^2));',...
		'elseif TimeType == 4,',...
			'set(popupTime, ''UserData'', max(RESULT_CC));',...
		'else,',...
			'error(''Oh no, time plottype unknown.'');',...
		'end,',...
		'eval(UpdateLeftImage);',...
	];

	UpdateSlider = [ ...
		'plane = get(popupPlane, ''Value'');',...
		'S = get(sliderLeft, ''UserData'');',...
		'set(sliderLeft, ''Min'', S(plane, 1));',...
		'set(sliderLeft, ''Max'', S(plane, 2));',...                
		'set(sliderLeft, ''Value'', S(plane, 3));',...
		'set(textLeft, ''String'', num2str(round(get(sliderLeft, ''Value''))));',...
                'if S(plane, 1) == S(plane, 2),',...
                  'set(textLeft, ''Visible'', ''off'');',...
                  'set(sliderLeft, ''Visible'', ''off'');',...
                'end,',...
	];


if nargin == 0 
	command = 'new'; 
end 

if isstr(command) 
	if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
		command = 0; 
	elseif strcmp(lower(command),lower('buttonClose')) 
		command = 1; 
	elseif strcmp(lower(command),lower('sliderLeft')) 
		command = 2; 
	elseif strcmp(lower(command),lower('popupRay')) 
		command = 3; 
	elseif strcmp(lower(command),lower('popupTime')) 
		command = 4; 
	elseif strcmp(lower(command),lower('popupPlane')) 
		command = 5; 
	end 
end 

if command ~= 0 
	h_fig_list = findobj(get(0,'children'),'flat',... 
		'tag','lyngby_ui_cc_view'); 
		if length(h_fig_list) > 1 
			h_fig_list = gcf; 
		elseif length(h_fig_list) == 0 
			error('There are no figures with Tag = lyngby_ui_cc_view.'); 
		end 
	handle_list = get(h_fig_list,'userdata'); 
	if length(handle_list) > 0 
		frameDivid = handle_list(1); 
		buttonClose = handle_list(2); 
		sliderLeft = handle_list(3); 
		textLeft = handle_list(4); 
		popupRay = handle_list(5); 
		popupTime = handle_list(6); 
		popupPlane = handle_list(7); 
		axesLeft = handle_list(8); 
		axesRight = handle_list(9); 
		textVoxel = handle_list(10);
	end 
end 


if command == 0 

	fig = figure('position',[ 10 10 783 540 ],... 
		'resize','On','tag','lyngby_ui_cc_view',... 
		'menubar','Figure','name','lyngby - Cross-correlation analysis view',... 
		'numbertitle','Off','visible','off',...
		'Color', [0.7 0.7 0.7]); 

	%  Uicontrol Object Creation 

	frameDivid = uicontrol(... 
		'CallBack','lyngby_ui_cc_view(''frameDivid'');',... 
		'ForegroundColor',UI_COLOR_FRONT,... 
		'BackgroundColor',UI_COLOR_CONTROL,...
		'Units','normalized',... 
		'Position',[ 0 0.17 1 0.03 ],... 
		'Enable','off',... 
		'Style','frame',... 
		'Tag','frameDivid',... 
		'UserData',''); 
	buttonClose = uicontrol(... 
		'CallBack','lyngby_ui_cc_view(''buttonClose'');',... 
		'ForegroundColor',UI_COLOR_FRONT,... 
		'BackgroundColor',UI_COLOR_CONTROL,...
		'Units','normalized',... 
		'Position',[ 0.8 0.05 0.15 0.07 ],... 
		'String','Close',... 
		'Style','pushbutton',... 
		'Tag','buttonClose',... 
		'UserData',''); 
	sliderLeft = uicontrol(... 
		'CallBack','lyngby_ui_cc_view(''sliderLeft'');',... 
		'Units','normalized',... 
		'Position',[ 0.03 0.39 0.04 0.35 ],... 
		'ForegroundColor',UI_COLOR_FRONT,... 
		'BackgroundColor',UI_COLOR_CONTROL,...
		'Style','slider',... 
		'Value',[ 0.1 ],... 
		'Tag','sliderLeft',... 
		'UserData',''); 
	textLeft = uicontrol(... 
		'CallBack','lyngby_ui_cc_view(''textLeft'');',... 
		'Position',[ 0.02 0.78 0.07 0.06 ],... 
		'Units','normalized',... 
		'ForegroundColor',UI_COLOR_FRONT,... 
		'BackgroundColor',UI_COLOR_CONTROL,...
		'Style','text',... 
		'Tag','textLeft',... 
		'UserData',''); 
	popupRay = uicontrol(... 
		'CallBack','lyngby_ui_cc_view(''popupRay'');',... 
		'ForegroundColor',UI_COLOR_FRONT,... 
		'BackgroundColor',UI_COLOR_CONTROL,...
		'Max',[ 3 ],... 
		'Min',[ 1 ],... 
		'Units','normalized',... 
		'Position',[ 0.21 0.05 0.15 0.07 ],... 
		'String','Slice|Mean in ray|Max in ray',... 
		'Style','popupmenu',... 
		'Value',[ 1 ],... 
		'Tag','popupRay',... 
		'UserData',''); 
	popupTime = uicontrol(... 
		'CallBack','lyngby_ui_cc_view(''popupTime'');',... 
		'ForegroundColor',UI_COLOR_FRONT,... 
		'BackgroundColor',UI_COLOR_CONTROL,...
		'Max',[ 2 ],... 
		'Min',[ 1 ],... 
		'Units','normalized',... 
		'Position',[ 0.37 0.05 0.3 0.07 ],... 
		'String','Mean through time|Data variance through time|Energy|Max correlation',... 
		'Style','popupmenu',... 
		'Value',[ 1 ],... 
		'Tag','popupTime',... 
		'UserData',''); 
	popupPlane = uicontrol(... 
		'CallBack','lyngby_ui_cc_view(''popupPlane'');',... 
		'ForegroundColor',UI_COLOR_FRONT,... 
		'BackgroundColor',UI_COLOR_CONTROL,...
		'Max',[ 3 ],... 
		'Min',[ 1 ],... 
		'Units','normalized',... 
		'Position',[ 0.05 0.05 0.15 0.07 ],... 
		'String','Sagittal|Coronal|Transversal',... 
		'Style','popupmenu',... 
		'Value',[ 1 ],... 
		'Tag','popupPlane',... 
		'UserData',''); 

	%  Menu Object Creation 


	%  Axes and Text Object Creation 

	axesLeft = axes(... 
		'Units','normalized', ... 
		'Position',[ 0.13 0.34 0.34 0.52 ],... 
		'Xgrid','off', ... 
		'Ygrid','off', ... 
		'Xlim',[ 0 1 ],... 
		'Ylim',[ 0 1 ],... 
		'Clipping','on', ... 
		'Tag','axesLeft', ... 
		'UserData','');

	axesRight = axes(... 
		'Units','normalized', ... 
		'Position',[ 0.55 0.34 0.39 0.52 ],... 
		'Xgrid','off', ... 
		'Ygrid','off', ... 
		'Xlim',[ 0 1 ],... 
		'Ylim',[ 0 1 ],... 
		'Clipping','on', ... 
		'Tag','axesRight', ... 
		'UserData',''); 


	textVoxel =  uicontrol(... 
		'Units','normalized',... 
		'Position',[ 0.65 0.88 0.15 0.05 ],... 
		'ForegroundColor',[ 1 1 1 ],... 
		'Visible', 'off',...		
		'Style','text',... 
		'Tag','textLeft',... 
		'UserData',''); 



	roi = lyngby_roi;
	if roi(3,1) - roi(3,2) == 0
		set(popupPlane, 'Value', 3);
	elseif roi(2,1) - roi(2,2) == 0
		set(popupPlane, 'Value', 2);
	elseif roi(1,1) - roi(1,2) == 0
		set(popupPlane, 'Value', 1);
	else
		set(popupPlane, 'Value', 3);
	end

	set(sliderLeft, 'UserData', [roi round(mean(roi')')])
	eval(UpdateSlider);

	% Initialize to the first voxel. Should be initialized to something else
	set(textVoxel, 'UserData', lyngby_mask2full(1));



	handle_list = [ ...  
		frameDivid buttonClose sliderLeft ... 
		textLeft popupRay popupTime popupPlane ... 
		axesLeft axesRight ...
		textVoxel ... 
	]; 

	set(gcf,'userdata',handle_list); 
	drawnow;pause(.1); 
	set(gcf,'visible','on'); 

	eval(UpdateLeft);
	eval(UpdateRight);


elseif command == 1 
	%disp('buttonClose selected.') 

	close(gcf);

elseif command == 2 
	%disp('sliderLeft selected.') 

	set(textLeft, 'String', round(get(sliderLeft, 'Value')));
	eval(UpdateLeftImage);

elseif command == 3 
	%disp('popupRay selected.') 

	eval(UpdateLeftImage);

elseif command == 4 
	%disp('popupTime selected.') 

	eval(UpdateLeft);

elseif command == 5 
	%disp('popupPlane selected.') 

	eval(UpdateSlider);
	eval(UpdateLeftImage);

elseif command == 1000
	
	eval(VoxelClick);
else 
	error('Error: lyngby_ui_cc_view.m called with incorrect command.') 
end 









