function lyngby_ui_cons_init(command,parameter1) 

% lyngby_ui_cons_init   - Initialization for Consensus modeling
%
%       function lyngby_ui_cons_init(command,parameter1)
%       function lyngby_ui_cons_init
%
%       This function controls the consensus initialization
%       window. The configuration is written to the global variable
%       defined in lyngby_cons_global and used as input argument to
%       the lyngby_cons_main function. 
% 
%       'Scaling' selects which kind of scaling is performed on the
%       individual summary images. Will 'HistEq' histogram
%       equalization with respect to the first volume in the
%       'Included' list.
% 
%       The 'Included' list display the variables (summary images)
%       that are included in the consensus modeling. 
%
%       The 'Available' list display the variables that can be added
%       to the consensus analysis.
%
%       See also LYNGBY, LYNGBY_CONS_MAIN, LYNGBY_UI_MAIN,
%                LYNGBY_CONS_GLOBAL, LYNGBY_CONS_INIT.
%
% $Id: lyngby_ui_cons_init.m,v 1.2 2002/05/08 15:16:03 fnielsen Exp $ 


    lyngby_cons_global;
    lyngby_ui_global; 
    lyngby_ui_option;

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmpi(command, 'initialize') | strcmpi(command, 'new') 
	command = 'new'; 
      elseif strcmpi(command,'buttonApply') | ...
	    strcmpi(command, 'buttonHelp') | ...
	    strcmpi(command, 'buttonClose') | ...
	    strcmpi(command, 'popupScaling') | ...
	    strcmpi(command, 'listIncluded') | ...
	    strcmpi(command, 'listAvailable') 
	command = lower(command);
      end
    end 

    if ~strcmp(command, 'new')
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_cons_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_cons_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	fig = handle_list(4);
	buttonApply = handle_list(5); 
	buttonHelp = handle_list(6); 
	buttonClose = handle_list(7); 
	textScaling = handle_list(8); 
	popupScaling = handle_list(9); 
	textSVDComponents = handle_list(10); 
	editSVDComponents = handle_list(11); 
	textIncluded = handle_list(12); 
	textAvailable = handle_list(13); 
	listIncluded = handle_list(14); 
	listAvailable = handle_list(15); 
	buttonDelete = handle_list(16); 
	buttonAdd = handle_list(17); 
	textRegularization = handle_list(18); 
	editRegularization = handle_list(19); 
	textHiddenUnits = handle_list(20); 
	editHiddenUnits = handle_list(21); 
	textInformation = handle_list(22);
	popupInformation = handle_list(23);
      end 
    end 


    if strcmp(command, 'new')

      fig = figure(...
	  'position',[ 300 250 350 350 ],... 
	  'resize', 'On', ...
	  'tag','lyngby_ui_cons_init',... 
	  'menubar','Figure', ...
	  'name', 'Lyngby - Consensus',... 
	  'numbertitle', 'Off', ...
	  'visible', 'off', ...
	  'Color', UI_COLOUR_WINBACK); 

      w2 = 0.43;     % width of text
      w3 = 0.2;      % Width of edit
      w4 = 0.45;     % Width of popups

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.06;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.02; % Window controls
      Row2 = 0.14; %  Running Information
      Row3 = 0.23; %  Hidden Units
      Row4 = 0.32; %  Regularization Parameter
      Row5 = 0.41; %  Validation
      Row6 = 0.50; %  Generalization Optimization
      Row7 = 0.59; %  Neural network input
      Row8 = 0.68; %  SVD Components
      Row9 = 0.77; %  Scaling
      Row10= 0.88; % Title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.105 FrameWidth 0.88 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.01 FrameWidth 0.085 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String', [...
	    'The parameters of the consensus model '...
	    'can be specified in this window.'], ... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row10 0.9 0.08 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textScaling = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''textScaling'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row9 w2 ButtonHeight ],... 
	  'String','Scaling:',... 
	  'Style','text',... 
	  'Tag','textScaling',... 
	  'UserData',''); 
      popupScaling = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''popupScaling'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.5 Row9 w4 ButtonHeight ],... 
	  'String', ...
	  ['HistEq|None'],... 
	  'Style','popupmenu',... 
	  'Tag','popupScaling',... 
	  'UserData',''); 
      
      textSVDComponents = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''textSVDComponents'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row8 w2 ButtonHeight ],... 
	  'String','SVD Components:',... 
	  'Style','text',... 
	  'Tag','textSVDComponents',... 
	  'Visible', 'off', ...
	  'UserData',''); 
      editSVDComponents = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''editSVDComponents'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row8 w3 ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editSVDComponents',... 
	  'UserData','',...
	  'Visible', 'off', ...
	  'String', '50'); 

      textIncluded = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''textIncluded'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','center',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row7 w2 ButtonHeight ],... 
	  'String','Included',... 
	  'Style','text',... 
	  'Tag','textIncluded',... 
	  'UserData',''); 
      textAvailable = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''textAvailable'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment', 'center',... 
	  'Units','normalized',... 
	  'Position',[ 0.50 Row7 w4 ButtonHeight ],... 
	  'String', 'Available', ...
	  'Style','text',... 
	  'Tag','textAvailable',... 
	  'UserData','');          

      buttonDelete = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''buttonDelete'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,... 
	  'BackgroundColor', UI_COLOR_CONTROL,...
	  'HorizontalAlignment','center',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row6 w2 ButtonHeight ],... 
	  'String','Delete',... 
	  'Style','pushButton',... 
	  'Tag','buttonDelete',... 
	  'UserData',''); 
      buttonAdd = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''buttonAdd'');',... 
	  'ForegroundColor', UI_COLOR_FRONT,... 
	  'BackgroundColor', UI_COLOR_CONTROL,...
	  'HorizontalAlignment', 'center',... 
	  'Units', 'normalized',... 
	  'Position',[ 0.50 Row6 w4 ButtonHeight ],... 
	  'String', 'Add', ...
	  'Style','pushbutton',... 
	  'Tag','buttonAdd',... 
	  'UserData','');          

      listIncluded = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''listIncluded'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row2 w2 0.35 ],... 
	  'String','',... 
	  'Style','listbox',... 
	  'Tag','listIncluded',... 
	  'UserData',''); 
      listAvailable = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''listAvailable'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row2 w4 0.35 ],... 
	  'String','',... 
	  'Style','listbox',... 
	  'Value', 1,... 
	  'Tag','listAvailable',... 
	  'UserData','');          

      textRegularization = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''textRegularization'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row4 w2 ButtonHeight ],... 
	  'String','Regularization parameter:',... 
	  'Style','text',... 
	  'Tag','textRegularization',... 
	  'Visible', 'off', ...
	  'UserData',''); 
      editRegularization = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''editRegularization'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row4 w4 ButtonHeight ],... 
	  'String','11',... 
	  'Style','edit',... 
	  'Tag','editRegularization',... 
	  'UserData','',...
	  'Visible', 'off', ...
	  'String', 0); 
      
      textHiddenUnits = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''textHiddenUnits'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row3 w2 ButtonHeight ],... 
	  'String','Hidden units:',... 
	  'Style','text',... 
	  'Tag','textHiddenUnits',... 
	  'Visible', 'off', ...
	  'UserData',''); 
      editHiddenUnits = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''editHiddenUnits'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row3 w3 ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editHiddenUnits',... 
	  'UserData','',...
	  'Visible', 'off', ...
	  'String', 3); 

      textInformation = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''textInformation'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row2 w2 ButtonHeight ],... 
	  'String','Running information:',... 
	  'Style','text',... 
	  'Tag','textInformation',... 
	  'Visible', 'off', ...
	  'UserData',''); 
      popupInformation = uicontrol(... 
	  'CallBack','lyngby_ui_cons_init(''popupInformation'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row2 w3 ButtonHeight ],... 
	  'Style','popupmenu',... 
	  'Tag','popupInformation',... 
	  'UserData', '', ...
	  'String', 'On|Off', ...
	  'Visible', 'off', ...
	  'Value', 1); 

      
      if strcmpi(INIT_CONS.scaling, 'histeq')
	set(popupScaling, 'value', 1);
      elseif strcmpi(INIT_CONS.scaling, 'none')
	set(popupScaling, 'value', 2);
      else
	error(sprintf('Wrong value for INIT_CONS.scaling: %s', ...
	    INIT_CONS.scaling)); 
      end

      % Build up the 'available' volumes
      INIT_CONS.available = {}; 
      for n = 1:length(INIT_CONS.possible)
	if strcmp(INIT_CONS.possible{n}(max(1,end-5):end), '(:,:)''')
	  % Multiple volumes that needs to be transposed
	  vols = INIT_CONS.possible{n}(1:end-6);
	  if ~isempty(vols)
	    for m = 1:size(eval(vols),2);
	      INIT_CONS.available = { INIT_CONS.available{:} ...
		  sprintf('%s(:,%d)''', vols, m) };
	    end
	  end
        elseif strcmp(INIT_CONS.possible{n}(max(1,end-4):end), '(:,:)')
	  % Multiple volumes
	  vols = INIT_CONS.possible{n}(1:end-5);
	  if ~isempty(eval(vols))
	    for m = 1:size(eval(vols),1)
	      INIT_CONS.available = { INIT_CONS.available{:} ...
		  sprintf('%s(%d,:)', vols, m) };
	    end
	  end
	else
	  % Single volumes
	  if ~isempty(eval(INIT_CONS.possible{n}))
	    INIT_CONS.available = { INIT_CONS.available{:} ...
		INIT_CONS.possible{n} };  
	  end
	end

      end
      
      set(listAvailable, 'string', INIT_CONS.available);      
      set(listIncluded, 'string', INIT_CONS.volumes);
      
      handle_list = [ ...
	    frameEdit frameControl textTitle ...
	    fig ... 
	    buttonHelp buttonApply buttonClose ...
	    textScaling popupScaling ...
	    textSVDComponents editSVDComponents ...
	    textIncluded textAvailable ...
	    listIncluded listAvailable ...
	    buttonDelete buttonAdd ...
	    textRegularization editRegularization ...
	    textHiddenUnits editHiddenUnits ...
	    textInformation popupInformation
	];

      set(fig, 'userdata', handle_list); 
      drawnow;pause(.1); 
      set(fig,'visible','on'); 
      
    elseif strcmpi(command, 'buttonApply')

      cons_scaling = get(popupScaling, 'value');
      if cons_scaling == 1
	INIT_CONS.scaling = 'HistEq';
      elseif cons_scaling == 2
	INIT_CONS.scaling = 'None';
      else
	error('Internal error');
      end

      INIT_CONS.volumes = cellstr(get(listIncluded, 'String'));
      
      lyngby_log('New parameters updated');
      
    elseif strcmpi(command, 'buttonHelp')
      helpwin('lyngby_ui_cons_init')
      
    elseif strcmpi(command, 'buttonClose')
      close(gcf);
      
    elseif strcmpi(command, 'popupScaling')

      lyngby_log('Parameters edited');

    elseif strcmpi(command, 'buttonDelete')

      iDelete = get(listIncluded, 'value');
      if ~isempty(iDelete) & iDelete > 0
	sIncluded = get(listIncluded, 'String');
	iIncluded = 1:size(sIncluded,1);
	iIncluded = setdiff(iIncluded, iDelete);
	sIncluded = sIncluded(iIncluded,:);
	set(listIncluded, 'value', 1);
	set(listIncluded, 'string', sIncluded);
      end
      
      lyngby_log('Parameters edited');

    elseif strcmpi(command, 'buttonAdd')

      iAdd = get(listAvailable, 'value');
      if ~isempty(iAdd) & iAdd > 0
	s = get(listAvailable, 'String');
	sAdd = s(iAdd,:);
	sIncluded = get(listIncluded, 'string');
	sIncluded = cellstr(sIncluded);
	sIncluded = char({ sIncluded{:} sAdd{:} });
	set(listIncluded, 'string', sIncluded);
      end
      
      lyngby_log('Parameters edited');
      
    elseif strcmpi(command, 'listIncluded')
      
    elseif strcmpi(command, 'listAvailable')  
    
    else 
      error('Error: lyngby_ui_con_init.m called with incorrect command.') 
    end 

