function lyngby_ui_credit

% lyngby_ui_credit	- Display a credit
%
%	function lyngby_ui_credit(String)
%
%	Input:	String		Error Credit to be shown
%
%	Made with GUI Maker Ver 2.1 by Patrick Marchand

%	Date		Author		Version
%	1996-11-12	fnielsen	Initial version, based on error
%	1996-11-15	fnielsen	lyngby_ui_option called

% cvs :  $Revision: 1.3 $    

lyngby_ui_option

creditlyngby = sprintf('%s\n%s\n%s\n%s\n%s\n', ...
    'Made at Department of Matematical Modelling at DTU in Denmark by : ',...
    'Peter Toft, Finn Aarup Nielsen, Lars Kai Hansen, Cyril Goutte. ',...
    'This package has been supported by grant P20 MH57180 :',...
    '''Spatial and Temporal Patterns in Functional Neuroimaging''',...
    'and the The Danish Research Councils. ',...
    'The package may not be changed without written approval. ',...
    'Copyright 1997 - contact lkhansen@imm.dtu.dk');

fig = figure('position',[ 78 201 395 250 ],... 
    'resize','On','tag','lyngby_ui_credit',... 
    'menubar','Figure','name','lyngby - credit',... 
    'numbertitle','Off','visible','off',...
    'Color', UI_COLOR_BACK); 

buttonOk = uicontrol(... 
    'CallBack','close(gcf)',...
    'BackgroundColor', UI_COLOR_CONTROL,...
    'ForegroundColor', UI_COLOR_FRONT,... 
    'Units','normalized',... 
    'Position',[ 0.4 0.08 0.18 0.16 ],... 
    'String','Close',... 
    'Style','pushbutton',... 
    'Tag','buttonOk',... 
    'UserData',''); 

textCredit = uicontrol(... 
    'BackgroundColor', UI_COLOR_BACK,... 
    'ForegroundColor', UI_COLOR_FRONT,... 
    'Units','normalized',... 
    'Position',[ 0.02 0.25 0.75 0.45 ],... 
    'Style','text',... 
    'HorizontalAlignment','left',...
    'Tag','textCredit',... 
    'UserData','',...
    'String', creditlyngby);

textheadline = uicontrol(... 
    'BackgroundColor', UI_COLOR_BACK,... 
    'ForegroundColor', [1 0.2 0.2],... 
    'Units','normalized',... 
    'Position',[ 0.02 0.7 0.7 0.2 ],... 
    'Style','text',... 
    'HorizontalAlignment','left',...
    'Tag','textCredit',... 
    'UserData','',...
    'String', sprintf('The Lyngby package\nThe fMRI modellers toolbox. '));



drawnow;pause(.1); 
vers=version;
set(gcf,'visible','on'); 
if (exist('imread')~=0) & (vers(1)==5)
  [im,map]=imread('dtucol','tif');
  imax = axes('position',[ 0.8 0.05 0.15 0.9 ]);
  image(im);
  colormap(map);
  set(imax,'xcolor',UI_COLOR_BACK);
  set(imax,'ycolor',UI_COLOR_BACK);
  set(imax,'xtick',[]);
  set(imax,'ytick',[]);
  set(imax,'box','off');
end
