function lyngby_ui_efir_init(command,parameter1) 

% lyngby_ui_efir_init  - UI for initialization of EFIR model
%
%	function lyngby_ui_efir_init.m(command,parameter1)
%
%       See also: lyngby_efir_main, lyngby_ui_main
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_efir_init.m,v 1.10 1999/06/04 15:58:07 mgl Exp $
%       $Revision: 1.10 $

    lyngby_ui_option;
    lyngby_efir_global;

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editMaxorder')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editMaxshuffle')) 
	command = 5; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_efir_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_efir_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonApply = handle_list(4); 
	buttonHelp = handle_list(5); 
	buttonClose = handle_list(6); 
	editMaxorder = handle_list(7); 
	textMaxorder = handle_list(8); 
	editMaxshuffle = handle_list(9); 
	textMaxshuffle = handle_list(10); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 200 ],... 
	  'resize','On','tag','lyngby_ui_efir_init',... 
	  'menubar','Figure','name','lyngby - Exhaustive FIR analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      ButtonWidth = 0.25;
      ButtonHeight = 0.12;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.32; % Lower buttons
      Row3 = 0.48; % Middle buttons
      Row4 = 0.54; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.82; % Upper title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_efir_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the Exhaustive FIR Filter algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.9 0.25 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 

      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_efir_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_efir_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_efir_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textMaxorder = uicontrol(... 
	  'CallBack','lyngby_ui_efir_init(''textMaxorder'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','center',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row3 LabelWidth ButtonHeight ],... 
	  'String','Maxorder:',... 
	  'Style','text',... 
	  'Tag','textMaxorder',... 
	  'UserData',''); 
      editMaxorder = uicontrol(... 
	  'CallBack','lyngby_ui_efir_init(''editMaxorder'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editMaxorder',... 
	  'UserData',''); 
      textMaxshuffle = uicontrol(... 
	  'CallBack','lyngby_ui_efir_init(''textMaxshuffle'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','center',... 
	  'Units','normalized',... 
	  'Position',[ Column4 Row2 LabelWidth ButtonHeight ],... 
	  'String','Reshuffles:',... 
	  'Style','text',... 
	  'Tag','textMaxshuffle',... 
	  'UserData',''); 
      editMaxshuffle = uicontrol(... 
	  'CallBack','lyngby_ui_efir_init(''editMaxshuffle'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row2 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editMaxshuffle',... 
	  'UserData',''); 

      set(editMaxorder, 'String', num2str(EFIR_MAXORDER));
      set(editMaxshuffle, 'String', num2str(EFIR_MAXSHUFFLE));


      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonHelp buttonClose ... 
	  editMaxorder textMaxorder ... 
	  editMaxshuffle textMaxshuffle ... 
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [efir_maxorder, count1] = sscanf(get(editMaxorder, 'String'), '%d'); 
      [efir_maxshuffle, count2] = sscanf(get(editMaxshuffle, 'String'), '%d'); 
      if (count1==1 & efir_maxorder > 0) 
	EFIR_MAXORDER = efir_maxorder; 
      else 
	error('Maxorder should be a positive integer.'); 
      end 
      if (count2==1 & efir_maxshuffle > 0) 
	EFIR_MAXSHUFFLE = efir_maxshuffle; 
      else 
	error('The Maxshuffle should be a positive integer.'); 
      end 
      
    elseif command == 2 
      %disp('buttonHelp selected.') 

      s1 = [...
	    'This window allows you to choose the parameters used for ' ...
	    'the Exhaustive FIR filter:'...
	    ];
      s2 = [...
	    '   * Max Order: The maximal order of the FIR filters estimated. ' ...
	    ];
      s3 = [...
	    '   * Reshuffles: The number of reshuffles. ' ...
	    ];
      s10 = [...
	    'Function: lyngby_ui_efir_init' ...
	    ];
      s11 = [...
	    'See also: lyngby_efir_main' ...
	    ];

      
      helpdlg(sprintf('%s\n\n%s\n\n%s\n\n%s\n%s', s1, s2, s3, s10, s11),...
	  'Initialization of Exhaustive FIR parameters')   
      
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command == 4 
      %disp('editMaxorder selected.') 
      
    elseif command == 5         
      %disp('editMaxshuffle selected.') 
      
    else 
      error('Error: lyngby_ui_efir_init.m called with incorrect command.') 
    end 

















