function lyngby_ui_externals(varargin) 

% lyngby_ui_externals  - Window for editing/creating external
%
%       function lyngby_ui_externals(command,parameter1)
%       function lyngby_ui_externals
%
%       This function controls the graphical user interface for the
%       initialization/setup of external influences on the data.
%       It is called from the main window by pressing the button
%       in the 'External Influences' panel. It then allows
%       creation and editing of the run and paradigm functions.
%
%       Press '... Edit Paradigm ...'' to define the PARADIGM global
%       variable. This is used to define the time-based correlation
%       with the experimental stimulus
%
%       Press '... Edit Run ...' to define the RUN global
%       variable. This is used to specify, in time, the seperate
%       experiment trials.
%
%       "Setup design!" will apply the time mask defined in the global
%       variable TIME_MASK to the data. This will define the "P" and
%       the "R" global variables. 
%
%       "Process design!" will extract the mean of the paradigm
%       function. After this the "PN" global variable is defined. 
%
%       See also LYNGBY, LYNGBY_UI_RUN, LYNGBY_UI_PARADIGM,
%                LYNGBY_UI_GLOBAL, LYNGBY_GLOBAL
%
% $Id: lyngby_ui_externals.m,v 1.2 2000/05/08 14:12:58 fnielsen


    % Globalize variables
    lyngby_global;
    lyngby_ui_option;
    lyngby_ui_global;
    lyngby_prep_global;
    
    % Problem with small case run.m function in Windows
    global RUN;
    
    % Check input argument
    if nargin == 0 
      cmd = 'init';
    
    elseif nargin == 3 & ischar(varargin{1}) & ishandle(varargin{2}) ...
	  & isstruct(varargin{3})
      cmd = 'callback';
      
    end


    if strcmp(cmd, 'callback')
      % Invoke uicontrol callback
      try
        [varargout{1:nargout}] = feval(varargin{:}); 
      catch
        disp(lasterr);
      end
    
    elseif strcmp(cmd, 'init')
 
      fig = figure('position',[ 300 400 350 300 ],... 
	  'resize','On','tag','lyngby_ui_externals',... 
	  'menubar','Figure','name','lyngby - External Data Influences',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 
      buttonHeight = 0.08;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row4 = 0.54; % Upper buttons
      Row6 = 0.82; % Upper title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = 0.4;
      Column5 = 0.50; % Edit boxes

      uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.18 FrameWidth 0.8 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ 0.02 0.02 FrameWidth 0.14 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      uicontrol(... 
	  'CallBack','lyngby_ui_externals(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String', [ ...
	    'This window allows the creation, editing ' ...
	    'and setup of the external influences on the data.' ],... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 0.8 0.9 0.15 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
      
      uicontrol(... 
	  'CallBack', ...
	  'lyngby_ui_externals(''buttonClose'', gcbo, guidata(gcbo));', ... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ 0.2 0.05 0.28 buttonHeight],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      uicontrol(... 
	  'CallBack', ...
	  'lyngby_ui_externals(''buttonHelp'', gcbo, guidata(gcbo));',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ 0.52 0.05 0.28 buttonHeight],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'Visible', 'on',...
	  'UserData',''); 

      
      uicontrol(... 
	  'CallBack', ...
	  'lyngby_ui_externals(''buttonEditRun'', gcbo, guidata(gcbo));',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ 0.25 0.6 0.5 buttonHeight ],... 
	  'String','Create or edit the RUN ...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonEditRun',... 
	  'UserData',''); 
      
      uicontrol(... 
	  'CallBack', ...
	  'lyngby_ui_externals(''buttonEditParadigm'', gcbo, guidata(gcbo));',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ 0.25 0.5 0.5 buttonHeight ],... 
	  'String','Create or edit PARADIGM ...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonEditParadigm',... 
	  'UserData',''); 
      
      uicontrol(... 
	  'CallBack', ...
	  'lyngby_ui_externals(''buttonSetupDesign'', gcbo, guidata(gcbo));',...
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ 0.25 0.35 0.5 buttonHeight ],... 
	  'String','Setup design!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSetupDesign'); 
      uicontrol(... 
	  'CallBack', ...
	  'lyngby_ui_externals(''buttonProcessDesign'', gcbo, guidata(gcbo));',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,...
	  'Units','normalized',... 
	  'Position',[ 0.25 0.25 0.5 buttonHeight ],... 
	  'String','Process design!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonProcessDesign'); 

      
      hg = guihandles(fig);
      guidata(fig, hg);
      set(fig, 'visible', 'on');
    
    else
      error('Internal error (cmd)')
    
    end
      

%%%%%%%%%%%%%%%%%%%%%      
% Uicontrol functions      
%%%%%%%%%%%%%%%%%%%%%      
      

function varargout = buttonHelp(h, hg)      
    helpwin('lyngby_ui_externals')
      
  
function varargout = buttonClose(h, hg)
    close(get(h, 'parent'));

      
function varargout = buttonEditParadigm(h, hg)
    lyngby_log('Calling paradigm ...');
    lyngby_ui_paradigm;
    lyngby_log('Paradigm called!');


function varargout = buttonEditRun(h, hg)
    lyngby_log('Calling run ...');
    lyngby_ui_run;
    lyngby_log('Run called!');


function varargout = buttonSetupDesign(h, hg)
    % lyngby_log('Setting up design ...');
    lyngby_ui_global
    lyngby_global

    % Problem with small case run.m function in Windows
    global RUN

    if exist('PARADIGM')
      lyngby_log('Setting up design ...3');
      if ~isempty(PARADIGM)
	P = TIME_MASK * PARADIGM;
      else
	lyngby_ui_message([' ''PARADIGM'' varible is not loaded. ' ...
	      'Press create/edit the PARADIGM.' ]);
      end
    else
      lyngby_ui_message([ ' ''PARADIGM'' does not exist. ' ...
	    'Press create/edit']);
    end
    if exist('RUN')==1 & ~isempty(RUN)
      R = TIME_MASK * RUN;
    else
      lyngby_ui_message([ '''RUN'' variable does not exist ' ...
	    'or is empty. Press create/edit' ]);
    end
    lyngby_log('Setting up design completed!');


function varargout = buttonProcessDesign(h, hg)
    lyngby_log('Processing design ...');
    lyngby_ui_global
    if exist('P') & ~isempty(P)
      PN = P - mean(P);  
      lyngby_log('Processing design completed!');
    else
      lyngby_ui_message(['''P'' is not loaded. Please, ' ...
	    'press ''Setup design!''']);
    end



