function lyngby_ui_fir_init(command,parameter1) 

% lyngby_ui_fir_init   - User interface for FIR filter analysis
%
%       function lyngby_ui_fir_init(command,parameter1)
%       function lyngby_ui_fir_init
%
%       This function controls the FIR initialization window.
%      
%       The window allows you to choose the parameters used for the
%       estimation of the FIR filter: 
%       - Filter order: This is the the number of parameters or lags
%         in the linear convolution filter.
%       - Regularization method: Whether to use a principal component
%         regression (PCR) or ridge regularization (Ridge). 
%       - Regularization parameter: This is the weight used in the
%         estimation of parameters (Only determined from the
%         paradigm). Use the 'Show singular values' button to get an
%         idea of the proper setting. 
%       - Principal components: The number of principal components to
%         use in PCR. 
%       - Convolution type: The 'Skip' option means that the first
%         Filter-Length of data points will be disregarded. 'ZeroPad'
%         will pad with zeros at the beginning of the paradigm. 'Wrap'
%         will make the paradigm circular, where the last time points of
%         the paradigm will be move to the front.
%
%       See also LYNGBY, LYNGBY_FIR_MAIN, LYNGBY_UI_MAIN,
%                LYNGBY_FIR_CONVOLVE, LYNGBY_FIR_GLOBAL,
%                LYNGBY_FIR_INIT.  
%
%       Made with: Gui Maker Ver 2.1 by Patrick Marchand 
%
% $Id: lyngby_ui_fir_init.m,v 1.27 2001/06/06 18:38:54 fnielsen Exp $ 

%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 



    lyngby_fir_global;
    lyngby_global;
    lyngby_ui_global;
    lyngby_ui_option;

    UpdateReg = [ ...
	  'if any(get(popupRegMethod, ''Value'') == [ 1 3 ]),', ...
	  '  set(editRegularization, ''Enable'', ''On'');',...
	  '  set(editPCRComp, ''Enable'', ''Off'');',...
	  'else,',...
	  '  set(editRegularization, ''Enable'', ''Off'');',...
	  '  set(editPCRComp, ''Enable'', ''On'');',...
	  'end,'];
    
    
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editOrder')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editRegularization')) 
	command = 5; 
      elseif strcmp(lower(command),lower('popupConvType')) 
	command = 6; 
      elseif strcmp(lower(command),lower('popupRegMethod')) 
	command = 7; 
      elseif strcmp(lower(command),lower('editPCRComp')) 
	command = 8; 
      elseif strcmp(lower(command),lower('buttonSVD')) 
	command = 9; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_fir_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_fir_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	fig = handle_list(4);
	figSVD = handle_list(5);
	buttonApply = handle_list(6); 
	buttonHelp = handle_list(7); 
	buttonClose = handle_list(8); 
	editOrder = handle_list(9); 
	editRegularization = handle_list(10); 
	textOrder = handle_list(11); 
	textRegularization = handle_list(12); 
	popupRegMethod = handle_list(13); 
	popupConvType = handle_list(14); 
	textConvType = handle_list(15); 
	buttonSVD = handle_list(16);
      	editPCRComp = handle_list(17); 
	textPCRComp = handle_list(18); 
      end 
    end 

    if command == 0 

      figSVD = -1;

      fig = figure('position',[ 300 470 400 250 ],... 
	  'resize','On','tag','lyngby_ui_fir_init',... 
	  'menubar','Figure','name','lyngby - FIR filter analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      
      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.09;
      FrameWidth = 0.98;
      FrameColumn = 0.01;
      Row1 = 0.04; % Window controls
      Row2 = 0.22; % Convolution type
      Row3 = 0.33; % Principal Components
      Row4 = 0.44; % Regularization parameter
      Row5 = 0.55; % Regularization method
      Row6 = 0.66; % Filter order
      Row7 = 0.77; % Title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.17 FrameWidth 0.83 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.14 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the FIR Filter can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row7 0.9 0.18 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.35 Row1 0.20 ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.56 Row1 0.20 ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.77 Row1 0.20 ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      
      textOrder = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''textOrder'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row6 0.43 ButtonHeight ],... 
	  'String','Filter order:',... 
	  'Style','text',... 
	  'Tag','textOrder',... 
	  'UserData',''); 
      editOrder = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''editOrder'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row6 0.14 ButtonHeight ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editOrder',... 
	  'UserData','',...
	  'String', FIR_ORDER); 
      textRegMethod = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''textRegMethod'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.43 ButtonHeight ],... 
	  'String','Regularization method:',... 
	  'Style','text',... 
	  'Tag','textRegMethod',... 
	  'UserData',''); 
      popupRegMethod = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''popupRegMethod'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row5 0.30 ButtonHeight ],... 
	  'String','Ridge|PCR|Smooth',... 
	  'Style','popupmenu',... 
	  'Value', 1,... 
	  'Tag','popupRegMethod',... 
	  'UserData','');          
      textRegularization = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''textRegularization'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row4 0.43 ButtonHeight ],... 
	  'String','Regularization parameter:',... 
	  'Style','text',... 
	  'Tag','textRegularization',... 
	  'UserData',''); 
      editRegularization = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''editRegularization'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row4 0.20 ButtonHeight ],... 
	  'String','0',... 
	  'Style','edit',... 
	  'Tag','editRegularization',... 
	  'UserData','',...
	  'String', FIR_REGULARIZATION); 
      textPCRComp = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''textPCRComp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row3 0.43 ButtonHeight ],... 
	  'String','Principal components:',... 
	  'Style','text',... 
	  'Tag','textPCRComp',... 
	  'UserData',''); 
      editPCRComp = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''editPCRComp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row3 0.20 ButtonHeight ],... 
	  'String','11',... 
	  'Style','edit',... 
	  'Tag','editPCRComp',... 
	  'UserData','',...
	  'String', FIR_PCRCOMP); 
      textConvType = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''textConvType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row2 0.43 ButtonHeight ],... 
	  'String','Convolution type:',... 
	  'Style','text',... 
	  'Tag','textConvType',... 
	  'UserData',''); 
      popupConvType = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''popupConvType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.50 Row2 0.20 ButtonHeight ],... 
	  'String','Skip|Zeropad|Extend|Wrap',... 
	  'Style','popupmenu',... 
	  'Value', 1,... 
	  'Tag','popupConvType',... 
	  'UserData','');          
      buttonSVD = uicontrol(... 
	  'CallBack','lyngby_ui_fir_init(''buttonSVD'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.02 Row1 0.32 ButtonHeight ],... 
	  'String','Show singular values',... 
	  'Style','pushbutton',... 
	  'Tag','buttonSVD',... 
	  'UserData',''); 
      
      set(editOrder, 'String', num2str(FIR_ORDER));
      set(editRegularization, 'String', num2str(FIR_REGULARIZATION));
      if strcmp(lower(FIR_REGMETHOD), 'reginverse')
	set(popupRegMethod, 'value', 1);
      elseif strcmp(lower(FIR_REGMETHOD), 'ridge')
	set(popupRegMethod, 'value', 1);      
      elseif strcmp(lower(FIR_REGMETHOD), 'pcr')
	set(popupRegMethod, 'value', 2);
      elseif strcmp(lower(FIR_REGMETHOD), 'svd')
	set(popupRegMethod, 'value', 2);
      elseif strcmp(lower(FIR_REGMETHOD), 'smooth')
	set(popupRegMethod, 'value', 3);
      else
	set(popupRegMethod, 'value', 1);
	lyngby_log(sprintf('FIR_REGMETHOD was wrong: %s', FIR_REGMETHOD));
      	FIR_REGMETHOD = 'Ridge';
      end
      
      if strcmp(lower(FIR_CONVTYPE), 'skip')
	set(popupConvType, 'value', 1);
      elseif strcmp(lower(FIR_CONVTYPE), 'zeropad')
	set(popupConvType, 'value', 2);
      elseif strcmp(lower(FIR_CONVTYPE), 'extend')
	set(popupConvType, 'value', 3);
      elseif strcmp(lower(FIR_CONVTYPE), 'wrap')
	set(popupConvType, 'value', 4);
      else
	set(popupRegMethod, 'value', 1);
	FIR_CONVTYPE = 'Skip';
      	lyngby_log('FIR_CONVTYPE was wrong');
      end
      
      eval(UpdateReg)
      
      handle_list = [ ...
	  frameEdit frameControl textTitle ...
	  fig figSVD ... 
	  buttonHelp buttonApply  buttonClose ... 
	  editOrder editRegularization textOrder textRegularization ...
	  popupRegMethod ...
	  popupConvType textConvType ...
	  buttonSVD ...
	  editPCRComp textPCRComp]; 

      set(fig, 'userdata', handle_list); 
      drawnow;pause(.1); 
      set(fig,'visible','on'); 

    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [fir_order, count1] = sscanf(get(editOrder, 'String'), '%d'); 
      [fir_regularization, count2] = sscanf(get(editRegularization, ...
	  'String'), '%f'); 
      [fir_pcrcomp, count3] = sscanf(get(editPCRComp, 'String'), ...
	  '%f');  
      
      if count1 == 1 & count2 == 1 & count3 == 1 & fir_order > 0 & ...
	    fir_regularization >= 0 & fir_pcrcomp > 0 & ...
	    fir_pcrcomp == round(fir_pcrcomp)
	FIR_ORDER = fir_order; 
	FIR_REGULARIZATION = fir_regularization; 
	FIR_PCRCOMP = fir_pcrcomp;
	im = get(popupRegMethod, 'Value');
	if im == 1
	  FIR_REGMETHOD = 'Ridge';
	elseif im == 2 
	  FIR_REGMETHOD = 'SVD';
	elseif im == 3
	  FIR_REGMETHOD = 'Smooth';
	end
	ct = get(popupConvType, 'Value');
	if ct == 1
	  FIR_CONVTYPE = 'Skip';
	elseif ct == 2
	  FIR_CONVTYPE = 'Zeropad';
	elseif ct == 3
	  FIR_CONVTYPE = 'Extend';
	elseif ct == 4
	  FIR_CONVTYPE = 'Wrap';
	end
	lyngby_log('New parameters updated')
      else 
	error('Order must be integer (>0), regularization a float (>=0).'); 
      end 

      if figSVD ~= -1
	figure(figSVD);
	lyngby_ui_fir_init(100);
      end
      
      
    elseif command == 2 
      %disp('buttonHelp selected.') 
      
      
      helpwin('lyngby_ui_fir_init')   

      
    elseif command == 3 
      %disp('buttonClose selected.') 

      if (figSVD ~= -1)
	figure(figSVD);
	close(figSVD)
      end
      close(fig); 
      
    elseif command == 4 
      %disp('editOrder selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 5 
      %disp('editRegularization selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 6
      %disp('editEditAll selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 7
      %disp('popupRegMethod selected.') 

      eval(UpdateReg);
      lyngby_log('Parameters edited')
     
    elseif command == 8
      %disp('editPCRComp selected.') 

      lyngby_log('Parameters edited')
    
    elseif command == 9 

      if (figSVD == -1)
%       if (get(buttonSVD, 'String') == 'Show singular values')
	handle_list = get(h_fig_list,'userdata'); 
	figSVD = figure('position',[ 300 60 400 300 ],... 
	    'resize','On','tag','lyngby_ui_fir_init_svd',... 
	    'menubar','Figure','name', ... 
	    'lyngby - FIR filter analysis, Singular values',... 
	    'numbertitle','Off','visible','on','Color', UI_COLOUR_FRAME);
	handle_list(5) = figSVD;
	set(h_fig_list, 'userdata', handle_list); 
	lyngby_ui_fir_init(100);
	set(buttonSVD, 'String', 'Hide singular values');
      else
	handle_list = get(h_fig_list,'userdata'); 
	handle_list(5) = -1;
	set(h_fig_list, 'userdata', handle_list);
	figure(figSVD);
	close(figSVD);
	set(buttonSVD, 'String', 'Show singular values');
      end
      
      
    elseif command == 100
      
      p = PN;

      % Number of equations to determine the filter coefficients:
      Rows = size(X,1) - FIR_ORDER + 1;	
      
      unitM = eye(FIR_ORDER);         % A unit matrix for the regularization
      
      Xm = zeros(Rows,FIR_ORDER);     % The Input as a matrix
      for row = 1:Rows,
	Xm(row,:) = p(FIR_ORDER+row-1:-1:row)';
      end
      Xmm = Xm'*Xm;
      [u,s,v] = svd(Xmm);
      dia = diag(s);

      Xmm = (Xm'*Xm + FIR_REGULARIZATION * eye(size(Xm, 2)));
      sReg = svd(Xmm);
      
      semilogy(sReg, 'k:');
      ax1 = axis;
      semilogy(dia,'b');          
      ax2 = axis;

      semilogy(sReg, 'k:');
      axis([ax1(1) ax1(2) min([ax1(3) ax2(3)]) max([ax1(4) ax2(4)]) ...
	    ]); 
      hold on      
      semilogy(dia,'b');          

      xlabel('Singular value');
      ylabel('Level of singular value');
      title('Singular values and truncation threshold');

      %plot(get(gca,'XLim'), [ FIR_REGULARIZATION FIR_REGULARIZATION ],'r');
      
      plot([FIR_PCRCOMP FIR_PCRCOMP],get(gca,'YLim'),'g--');
      legend('Reg. sing. values', 'Singular values', ...
	  'PCR Component');
      hold off;

      ss = (1./(s+eps)).*(s > FIR_REGULARIZATION);
      preX = v*ss*u'*Xm';

    else 
      error('Error: lyngby_ui_fir_init.m called with incorrect command.') 
    end 

