% lyngby_ui_global     - Defines global for the user interface
%
%       script
%
%       Global: X		  Datamatrix
%               P		  Paradigm
%               XN		  Normalized datamatrix
%               PN		  Normalized Paradigm
%               X_MEAN		  Mean of datamatrix (an image)
%               X_STD		  Standard deviation of datamatrix
%               X_SEQMEAN         Sequence mean of data matrix (a
%                                 sequence)
%               X_SEQSTD          Sequence stadard deviation of data
%                                 matrix (a sequence)
%               RESULT_BAT        Result from Barbak's t-test
%               RESULT_BAF        Result from Barbak's f-test
%               RESULT_BAF2       Result from Barbak's f-test with nuisance 
%                                 signal estimation
%               RESULT_CC	  Result from the cross-correlation analysis
%               RESULT_FIR	  Result from the FIR filter analysis
%               RESULT_FIR_CONV   Convolution of the FIR result
%               RESULT_EFIR       Filter coefficients of Exhaustive
%                                 FIR
%               RESULT_EFIR_ORDER Filter order for each voxel in Exhaustive FIR
%               RESULT_EFIR_CONV  Convolution of the Exhautive FIR
%               RESULT_KM	  Result from the K-means analysis
%               RESULT_KS         Result from Kolmogorov Smirnov test
%               PROB_KS           Probability map from Kolmogorov Smirnov test
%               RESULT_LZ	  Result from the Lange-Zeger analysis
%               RESULT_LZGS	  Result from the Lange-Zeger analysis (direct
%                 		  search)
%               RESULT_LZIT	  Result from the Lange-Zeger analysis
%		                  (iterative parameter estimation)
%               RESULT_NNR_E      Neural network regression, error
%               RESULT_NNR_Y      Neural network regression,
%                                 prediction
%               RESULT_NNS        Neural network saliency map
%               RESULT_NNS_S1     neural network saliency first order map
%               RESULT_NNS_PRED   Neural network prediction
%               RESULT_NNS_V      Neural network saliency - Input weights
%               RESULT_NNS_W      Neural network saliency - Output weights
%               RESULT_NNS_E      Neural network saliency - Error
%               RESULT_POIS_AMPL  Poisson filter - Amplitude of kernel
%               RESULT_POIS_POISSON   Poisson filter - Poisson parameter
%               RESULT_TS         Result from ordinary t-test
%               RESULT_SCVA_U     Strother CVA canonicsequences
%               RESULT_SCVA_S     Strother CVA canonicvalues
%               RESULT_SCVA_V     Strother CVA canonicimages
%               RESULT_SOP_U      Strother OPLS canonicsequences
%               RESULT_SOP_S      Strother OPLS canonicvalues
%               RESULT_SOP_V      Strother OPLS canonicimages
%               PROB_TS           Probability map ordinary t-test
%               PROB_BAT          Probability map Ardekani t-test
%               PROB_BAF          Probability map Ardekani F-test
%               PROB_BAF2         Probability map Ardekani F-test with
%                                 nuisance signal estimation
%
%               PP_LDT_TREND_N    Preprocessing variable - 
%                                 Linear Detrending - the removed trends
%               PP_LDT_RUN        Preprocessing variable - 
%                                 Linear Detrending - run variable 
%                                 (may have been altered for plotting)
%               PP_LDT_XN_pre_LDT Preprocessing variable - Linear
%                                 Detrending - XN before the data was
%                                 detrended, then centered for
%                                 plotting 
%
%       See also: LYNGBY, LYNGBY_UI_MAIN.
%
% $Id: lyngby_ui_global.m,v 1.46 2002/04/22 16:22:59 fnielsen Exp $


    global X P R XN PN X_MEAN X_STD X_SEQMEAN X_SEQSTD
    global PARADIGM RUN

    % Analysis results
    global RESULT_BAF PROB_BAF TRUNK_STRENGTH_BAF STRENGTH_BAF
    global RESULT_BAF2 PROB_BAF2 RESULT_BAF2_AIC RESULT_BAF2_UB ...
	STRENGTH_BAF2 TRUNK_STRENGTH_BAF2  
    global RESULT_BAT PROB_BAT TRUNK_STRENGTH_BAT STRENGTH_BAT
    global RESULT_CC STRENGTH_CC DELAY_CC
    global RESULT_EFIR RESULT_EFIR_ORDER RESULT_EFIR_CONV ...
	STRENGTH_EFIR DELAY_EFIR
    global RESULT_FIR RESULT_FIR_CONV STRENGTH_FIR DELAY_FIR ...
	SUMCOEF_FIR 
    global RESULT_ICA_TIME RESULT_ICA_IMAGE
    global RESULT_IKM_CENTER RESULT_IKM_ASSIGN RESULT_IKM_WITHIN ...
	RESULT_IKM_PROPERTY
    global RESULT_KM_CENTER RESULT_KM_ASSIGN RESULT_KM_CENTERSIM ...
	RESULT_KM_INFO  
    global RESULT_KS PROB_KS  STRENGTH_KS
    global RESULT_LZGS STRENGTH_LZGS DELAY_LZGS
    global RESULT_LZIT STRENGTH_LZIT DELAY_LZIT
    global RESULT_NNR_E RESULT_NNR_Y RESULT_NNR_U STRENGTH_NNR
    global RESULT_NNS RESULT_NNS_S1 RESULT_NNS_PRED RESULT_NNS_V ...
	RESULT_NNS_W RESULT_NNS_E RESULT_NNS_INFO 
    global RESULT_POIS_AMPL RESULT_POIS_POISSON
    global RESULT_SVD_U RESULT_SVD_S RESULT_SVD_V
    global RESULT_SCVA_U RESULT_SCVA_S RESULT_SCVA_V
    global RESULT_SOP_U RESULT_SOP_S RESULT_SOP_V
    global RESULT_TS STRENGTH_TS PROB_TS
    
    % Meta-analyses
    global RESULT_CONS
    global RESULT_MKM_CENTER RESULT_MKM_ASSIGN RESULT_MKM_INFO

    % Preprocessing
    global PP_LDT_TREND_N PP_LDT_RUN PP_LDT_XN_pre_LDT

















