function lyngby_ui_ica_init(command,parameter1) 

% lyngby_ui_ica_init   - GUI for initialization of ICA model
%
%       function lyngby_ui_ica_init(command,parameter1)
%       function lyngby_ui_ica_init
%
%       This function controls the window that sets up the variables
%       for Independent Component Analysis (ICA).
%
%       'No. of Components' is the number of sources.
%
%       'Time delay (tau)' is the delay parameter in the Molgedey
%       Schuster Time delay decorrelation algorithm.
%       
%       See also LYNGBY, LYNGBY_ICA_MS_EST, LYNGBY_ICA_GLOBAL,
%                LYNGBY_ICA_INIT. 
%
% $Id: lyngby_ui_ica_init.m,v 1.3 2002/12/18 00:14:53 fnielsen Exp $ 


    lyngby_ica_global;
    lyngby_ui_option;
    
    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editComponents')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editMsTau')) 
	command = 5; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 6; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_ica_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_ica_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit      = handle_list(1);
	frameControl   = handle_list(2);
	textTitle      = handle_list(3);
	buttonApply    = handle_list(4); 
	buttonClose    = handle_list(5); 
	editComponents = handle_list(6); 
	textComponents = handle_list(7); 
	editMsTau      = handle_list(8); 
	textMsTau      = handle_list(9); 
	buttonHelp     = handle_list(10); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 300 ],... 
	  'resize','On','tag','lyngby_ui_ica_init',... 
	  'menubar','Figure','name','lyngby - ICA analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.08;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.26; % Lower buttons
      Row25 = 0.35; % Middle buttons
      Row3 = 0.45; % Middle buttons

      Row4 = 0.54; % Upper buttons
      Row5 = 0.75; % Lower title
      Row6 = 0.82; % Upper title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_ica_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String', [ ...
	    'The parameters of the Independent Component ' ...
	    'Analysis (ICA) can be specified in this window.'],... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.9 0.15 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_ica_init(''buttonApply'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_ica_init(''buttonClose'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_ica_init(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textComponents = uicontrol(... 
	  'CallBack','lyngby_ui_ica_init(''textComponents'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_FRAME,... 
	  'HorizontalAlignment', 'right',... 
	  'Units','normalized',... 
	  'Position',[ 0.1 Row3 0.38 ButtonHeight ],... 
	  'String','No. of Components:',... 
	  'Style','text',... 
	  'Tag','textComponents',... 
	  'UserData',''); 
      
      editComponents = uicontrol(... 
	  'CallBack','lyngby_ui_ica_init(''editComponents'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editComponents',... 
	  'UserData',''); 
      
      textMsTau = uicontrol(... 
	  'CallBack','lyngby_ui_ica_init(''textMsTau'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_FRAME,... 
	  'HorizontalAlignment', 'right',... 
	  'Units','normalized',... 
	  'Position',[ 0.1 Row25 0.38 ButtonHeight ],... 
	  'String','Time delay (tau):',... 
	  'Style','text',... 
	  'Tag','textMsTau',... 
	  'UserData',''); 
      
      editMsTau = uicontrol(... 
	  'CallBack','lyngby_ui_ica_init(''editMsTau'');',... 
          'ForegroundColor', UI_COLOR_FRONT,...
          'BackgroundColor', UI_COLOUR_BUTTON,... 
	  'Units','normalized',... 
	  'Position',[ Column5 Row25 EditWidth ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editMsTau',... 
	  'UserData',''); 

      
      set(editComponents, 'String', num2str(ICA_COMPONENTS));
      set(editMsTau, 'String', num2str(ICA_MS_TAU));


      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonClose ... 
	  editComponents textComponents ...
	  editMsTau textMsTau ...
	  buttonHelp ... 
	  ]; 

      set(gcf, 'userdata', handle_list); 
      drawnow;
      pause(.1); 
      set(gcf, 'visible', 'on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [ica_components, count1] = sscanf(get(editComponents, 'String'), '%d'); 
      if (count1==1 & ica_components > 0) 
	ICA_COMPONENTS = ica_components; 
      else 
	error('Components must be integer and larger than 0.'); 
      end 

      [ica_mstau, count1] = sscanf(get(editMsTau, 'String'), '%d'); 
      if (count1==1 & ica_mstau > 0) 
	ICA_MS_TAU = ica_mstau; 
      else 
	error('Time delay (tau) must be integer and larger than 0.'); 
      end 

      
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command == 4 
      %disp('editComponents selected.') 

    elseif command == 5 
      %disp('editMsTau selected.') 

    elseif command == 6
      %disp('buttonHelp selected.') 

      helpwin('lyngby_ui_ica_init');
      
    else 
      error('Error: lyngby_ui_ica_init.m called with incorrect command.') 
    end 





