function lyngby_ui_km_init(command,parameter1) 

% lyngby_ui_km_init    - GUI for K-means parameter initialization
%
%       function lyngby_ui_km_init(command,parameter1) 
%       function lyngby_ui_km_init
%
%       Global: (from lyngby_km_global)
% 
%       This function controls the window for choosing the parameters
%       used in the K-means clustering. In the window the following
%       parameters can be set:
%
%       - Type:  Whether the median or the mean of the cluster members
%                is used to determine the next iterative cluster
%                center. 
%       - Standardization: How to standardize (normalize) the
%                individual objects (voxels). The objects can be
%                standardize with their standard deviation (sigma) or
%                with their range (the difference between the maximum
%                and the minimum).
%       - Clusters: Number of clusters. If the number of clusters are
%                not known in advance you can use the iterative
%                K-means clustering. See lyngby_ikm_main
%       - Initial cluster centers: Determines how the cluster centers
%                should be initialized.
%       - Decay rate: (between 0 and 1) The weight between the cluster
%                center in the previous iteration and the new estimate
%                of the cluster center. (This will regularize the
%                performance). A value of zero will only use new
%                estimate. 
%       - Iterations (>0): Maximum number of iterations. If this is
%                too small the optimization of the cluster centers
%                might not be complete. 
%       - Variable: Whether to cluster on the raw data vectors or the
%                cross correlation between the paradigm and data
%                vectors. 
%       - Components: Number of cross-correlation components to
%                cluster from. This only applies when the variable
%                (the metric) is cross-correlation. 
%
%       When you have changed the parameters the 'Apply' button must
%       be pressed before it will have an effect. 
%
%       See also LYNGBY, LYNGBY_KM_MAIN, LYNGBY_KM_GLOBAL,
%                LYNGBY_UI_MAIN, LYNGBY_IKM_MAIN, LYNGBY_UI_IKM_INIT. 
%
% $Id: lyngby_ui_km_init.m,v 1.17 2002/09/27 12:51:28 fnielsen Exp $ 

%	Made with GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Created: 26-Nov-96 
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_km_global
    lyngby_global
    lyngby_ui_option


    UpdateCompButtonEnabling = [ ...
          'variable = get(popupVariable, ''Value'');',...
	  'if variable == 1,',...
	  '  set(editComponents, ''Enable'', ''off'');',...
	  'else,',...
	  '  set(editComponents, ''Enable'', ''on'');',...
	  'end',...
	  ];


    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editComponents')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editIterations')) 
	command = 5; 
      elseif strcmp(lower(command),lower('editClusters')) 
	command = 6; 
      elseif strcmp(lower(command),lower('popupInit')) 
	command = 7; 
      elseif strcmp(lower(command),lower('editDecayRate')) 
	command = 8; 
      elseif strcmp(lower(command),lower('popupVariable')) 
	command = 9; 
      elseif strcmp(lower(command),lower('popupType')) 
	command = 10; 
      elseif strcmp(lower(command),lower('editPositionWeight')) 
	command = 11; 
      elseif strcmp(lower(command),lower('popupStandardization')) 
	command = 12; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_km_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_km_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonClose = handle_list(4); 
	buttonApply = handle_list(5); 
	buttonHelp = handle_list(6); 
	textType = handle_list(7); 
	popupType = handle_list(8); 
	textStandardization = handle_list(9); 
	popupStandardization = handle_list(10); 
	textClusters = handle_list(11); 
	editClusters = handle_list(12); 
	textInit = handle_list(13);
	popupInit = handle_list(14);
	textDecayRate = handle_list(15); 
	editDecayRate = handle_list(16); 
	textIterations = handle_list(17); 
	editIterations = handle_list(18); 
	textVariable = handle_list(19); 
	popupVariable = handle_list(20); 
	textComponents = handle_list(21); 	
	editComponents = handle_list(22); 
	textPositionWeight = handle_list(23); 
	editPositionWeight = handle_list(24);
      end 
    end 
    
    if command == 0 

      fig = figure('position',[ 300 300 350 350 ],... 
	  'resize','On','tag','lyngby_ui_km_init',... 
	  'menubar','Figure','name','lyngby - K-means initialization',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      x1 = 0.15;
      x2 = 0.5;
      y1 = 0.86;
      y2 = 0.75;
      y25 = 0.64;
      y3 = 0.53;
      y4 = 0.42;
      y5 = 0.31;
      y6 = 0.20;
      y7 = 0.09;
      
      h1 = 0.0686;   % height of buttons
      h2 = h1;     % height of field
      w1 = 0.2;    % width of buttons
      w2 = 0.33;   % width of text
      w3 = 0.2;    % width of edit

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.06;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.02; % Window controls
      Row2 = 0.13; % Components
      Row3 = 0.24; % Variable
      Row4 = 0.35; % Iterations
      Row5 = 0.46; % Decay Rate
      Row6 = 0.57; % Initial cluster centres
      Row7 = 0.68; % Clusters
      Row9 = 0.88; % Title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      EditWidth = Column3 - 0.50; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width
      
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.105 FrameWidth 0.88 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.01 FrameWidth 0.085 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_cc_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the K-Means algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row9 0.9 0.08 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
            
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''buttonApply'');',... 
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''buttonClose'');',... 
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''buttonHelp'');',... 
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      textType = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''textType'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.79 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Type:',... 
	  'Style','text',... 
	  'Tag','textType',... 
	  'UserData',''); 
      popupType = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''popupType'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x2 0.79 0.3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Mean|Median',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupType',... 
	  'UserData',''); 
      
      textStandardization = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''textStandardization'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.7 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Standardization:',... 
	  'Style','text',... 
	  'Tag','textStandardization',... 
	  'UserData',''); 
      popupStandardization = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''popupStandardization'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x2 0.7 0.3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','None|Std|Range',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupStandardization',... 
	  'UserData',''); 
      
      textClusters = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''textClusters'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.61 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Clusters:',... 
	  'Style','text',... 
	  'Tag','textClusters',... 
	  'UserData',''); 
      editClusters = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''editClusters'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 0.61 w3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','edit',... 
	  'Tag','editClusters',... 
	  'UserData',''); 

      textInit = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''textInit'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.52 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Initial cluster centers:',... 
	  'Style','text',... 
	  'Tag','textInit',... 
	  'UserData',''); 
      popupInit = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''popupInit'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 0.52 0.35 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String', 'ReverseLog|Linear|UpperLinear|Random',...
	  'Style','popup',... 
	  'Tag','popupInit',... 
	  'UserData',''); 
      
      textDecayRate = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''textDecayRate'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1  0.43 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Decay Rate:',... 
	  'Style','text',... 
	  'Tag','textDecayRate',... 
	  'UserData',''); 
      editDecayRate = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''editDecayRate'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 0.43 w3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','edit',... 
	  'Tag','editDecayRate',... 
	  'UserData',''); 

      textIterations = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''textIterations'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.34 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Iterations:',... 
	  'Style','text',... 
	  'Tag','textIterations',... 
	  'UserData',''); 
      editIterations = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''editIterations'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 0.34 w3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','edit',... 
	  'Tag','editIterations',... 
	  'UserData',''); 

      textVariable = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''textVariable'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.25 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Variable:',... 
	  'Style','text',... 
	  'Tag','textVariable',... 
	  'UserData',''); 
      popupVariable = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''popupVariable'');',... 
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x2 0.25 0.3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String','Time|xcorrelation',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupVariable',... 
	  'UserData',''); 

      textComponents = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''textComponents'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 0.16 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Components:',... 
	  'Style','text',... 
	  'Tag','textComponents',... 
	  'UserData',''); 
      editComponents = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''editComponents'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 0.16 w3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'Style','edit',... 
	  'Tag','editComponents',... 
	  'UserData',''); 
      
      textPositionWeight = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''textPositionWeight'');',... 
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 Row1 w2 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_FRAME,... 
	  'String','Position weight:',... 
	  'Style','text',... 
          'visible','off',...
	  'Tag','textPositionWeight',... 
	  'UserData',''); 
      editPositionWeight = uicontrol(... 
	  'CallBack','lyngby_ui_km_init(''editPositionWeight'');',... 
	  'Units','normalized',... 
	  'Position',[ x2 Row1 w3 ButtonHeight ],... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOR_CONTROL,... 
	  'String', 0, ...
	  'Style','edit',... 
          'visible','off',...
	  'Tag','editPositionWeight',... 
	  'UserData',''); 

      if strcmpi(KM_TYPE, 'mean')
	Type = 1;
      else	
	Type = 2;
      end
      if strcmpi(KM_STANDARDIZATION, 'none')
	Standardization = 1;
      elseif strcmpi(KM_STANDARDIZATION, 'std')	
	Standardization = 2;
      else
	Standardization = 3;
      end

      if strcmpi(KM_INIT, 'reverselog')
	Init = 1;
      elseif strcmpi(KM_INIT, 'linear')	
	Init = 2;
      elseif strcmpi(KM_INIT, 'upperlinear')	
	Init = 3;
      elseif strcmpi(KM_INIT, 'random')	
	Init = 4;
      end
      if strcmpi(KM_VARIABLE, 'time')
	Variable = 1;
      else
	Variable = 2;
      end
      
      set(popupType, 'Value', Type);
      set(popupStandardization, 'Value', Standardization);
      set(popupInit, 'Value', Init);
      set(editClusters, 'String', num2str(KM_CLUSTERS));
      set(editDecayRate, 'String', num2str(KM_DECAYRATE));
      set(editIterations, 'String', num2str(KM_ITERATIONS));
      set(popupVariable, 'Value', Variable);
      set(editComponents, 'String', num2str(KM_COMPONENTS));
      set(editPositionWeight, 'String', num2str(KM_POSITIONWEIGHT));

      handle_list = [ ...  
	    frameEdit frameControl textTitle ...
	    buttonClose buttonApply buttonHelp ... 
	    textType popupType ...
	    textStandardization popupStandardization ...
	    textClusters editClusters ...
	    textInit popupInit ...
	    textDecayRate editDecayRate ... 
	    textIterations editIterations ... 
	    textVariable popupVariable ... 
	    textComponents editComponents ...
	    textPositionWeight editPositionWeight ...
	    ]; 
      
      eval(UpdateCompButtonEnabling);
	      
      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      % disp('buttonClose selected.') 

      close(gcf);

    elseif command == 2 
      % disp('buttonApply selected.') 

      % !!! Needs upper bound for Clusters and Components 

      
      [Clusters, countClusters] = sscanf(get(editClusters, 'String'), '%d');
      [DecayRate, countDecayRate] = sscanf(get(editDecayRate, 'String'), '%f');
      [PositionWeight, countPositionWeight] = sscanf(get(editPositionWeight, 'String'), '%f');
      [Iterations, countIterations] = sscanf(get(editIterations, 'String'), '%d');
      [Components, countComponents] = sscanf(get(editComponents, 'String'), '%d');
      if countClusters ~= 1,
        error('Clusters must be a single integer');
      elseif countDecayRate ~= 1,
        error('Decay rate must be a single float');
      elseif countPositionWeight ~= 1,
	error('PositionWeight must be a single float');
      elseif countIterations ~= 1,
        error('Iterations must be a single integer');
      elseif countComponents ~= 1,
        error('Components must be a single integer');
      elseif Clusters < 1,
        error('Clusters cannot be <1');
      elseif DecayRate >= 1 | DecayRate < 0 ,
        error('Decay rate must be in ]0;1]');
      elseif PositionWeight <0
	error('Position weight must be non-negative');
      elseif Iterations < 1,
	error('Iterations cannot be <1');
      elseif Components < 1,
	error('Components cannot be <1');
      else,
	Type = get(popupType, 'Value');
	Init = get(popupInit, 'Value');
	Variable = get(popupVariable, 'Value');
	if Type == 1,
	  KM_TYPE = 'mean';
	else,
	  KM_TYPE = 'median';
	end
	Standardization = get(popupStandardization, 'Value');
	if Standardization == 1
	  KM_STANDARDIZATION = 'none';
	elseif Standardization == 2
	  KM_STANDARDIZATION = 'std';
	elseif Standardization == 3
	  KM_STANDARDIZATION = 'range';
	else
	  error('Internal error');
	end
	if Init == 1,
	  KM_INIT = 'ReverseLog';
	elseif Init == 2
	  KM_INIT = 'Linear';
	elseif Init == 3
	  KM_INIT = 'UpperLinear';
	elseif Init == 4
	  KM_INIT = 'Random';
	end
	if Variable == 1,
	  KM_VARIABLE = 'time';
	else,
	  KM_VARIABLE = 'xcorr';
	end,
	KM_CLUSTERS = Clusters;
	KM_DECAYRATE = DecayRate;
	KM_POSITIONWEIGHT = PositionWeight;
	KM_ITERATIONS = Iterations;
	KM_COMPONENTS = Components;
      end
	  
      lyngby_log('New parameters updated')
    
    elseif command == 3 
      % disp('buttonHelp selected.') 

      helpwin('lyngby_ui_km_init');

    elseif command == 4 
      % disp('editComponents selected.') 

          lyngby_log('Parameters edited')

    
    elseif command == 5 
      % disp('editIterations selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 6 
      % disp('editClusters selected.') 

      lyngby_log('Parameters edited')

    elseif command == 7
      % disp('popupInit selected.') 

      lyngby_log('Parameters edited')
    
    elseif command == 8 
      % disp('editDecayRate selected.') 

      lyngby_log('Parameters edited')

    elseif command == 9 
      % disp('popupVariable selected.') 

      eval(UpdateCompButtonEnabling);
      lyngby_log('Parameters edited')

    elseif command == 10 
      % disp('popupType selected.') 

      lyngby_log('Parameters edited')
      
    elseif command == 11
      % disp('editPositionWeight selected.') 

      lyngby_log('Parameters edited')

    elseif command == 12
      % disp('popupStandardization selected.') 

      lyngby_log('Parameters edited')


    else 
      error('Error: lyngby_ui_km_init.m called with incorrect command.') 
    end 
