function lyngby_ui_ks_init(command,parameter1) 

% lyngby_ui_ks_init    - KS, GUI for initialization of parameters
%
%       function lyngby_ui_ks_init(command,parameter1)
%       function lyngby_ui_ks_init
%
%       This function is normally called through lyngby_ui_main and is
%       used to setup the parameters of the Kolmogorov-Smirnov
%       algorithm. 
%
%       * 'Edgedrop' is the number of scans discarded at the activation shifts. 
%
%       * 'Tolerance' is an iteration-convergence parameter. 
%
%       See also LYNGBY, LYNGBY_KS_GLOBAL, LYNGBY_KS_INIT,
%                LYNGBY_KS_MAIN, LYNGBY_UI_MAIN. 
%
% $Id: lyngby_ui_ks_init.m,v 1.12 2004/09/06 09:04:17 fnielsen Exp $

%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 
%
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 



    lyngby_ks_global;
    lyngby_ui_option;
    
    if nargin == 0 
      command = 'new'; 
    end 
    
    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editEdgedrop')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editTolerance')) 
	command = 5; 
      end 
    end 
    
    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_ks_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_ks_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonApply = handle_list(4); 
	buttonHelp = handle_list(5); 
	buttonClose = handle_list(6); 
	editEdgedrop = handle_list(7); 
	textEdgedrop = handle_list(8); 
	editTolerance = handle_list(9); 
	textTolerance = handle_list(10); 
      end 
    end 


    if command == 0 

      fig = figure('position',[ 300 400 350 200 ],... 
	  'resize','On','tag','lyngby_ui_ks_init',... 
	  'menubar','Figure','name','lyngby - Kolmogorov-Smirnov analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 
      ButtonWidth = 0.25;
      ButtonHeight = 0.12;
      FrameWidth = 0.96;
      FrameColumn = 0.02;
      Row1 = 0.06; % Window controls
      Row2 = 0.32; % Lower buttons
      Row3 = 0.48; % Middle buttons
      Row4 = 0.54; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.82; % Upper title
      Column1 = 0.07;
      Column2 = 0.38;
      Column3 = 0.69;
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
            
      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.24 FrameWidth 0.74 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.2 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_ks_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String', [ 'The parameters of the Kolmogorov-Smirnov ' ...
	    'algorithm can be specified in this window.'],... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row5 0.9 0.25 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 

      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_ks_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_ks_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_ks_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      
      editEdgedrop = uicontrol(... 
	  'CallBack','lyngby_ui_ks_init(''editEdgedrop'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row3 0.3 ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editEdgedrop',... 
	  'UserData',''); 
      textEdgedrop = uicontrol(... 
	  'CallBack','lyngby_ui_ks_init(''textEdgedrop'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.1 Row3 0.38 ButtonHeight ],... 
	  'String','Edgedrop:',... 
	  'Style','text',... 
	  'Tag','textEdgedrop',... 
	  'UserData',''); 
      editTolerance = uicontrol(... 
	  'CallBack','lyngby_ui_ks_init(''editTolerance'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column5 Row2 0.3 ButtonHeight ],... 
	  'Style','edit',... 
	  'Tag','editTolerance',... 
	  'UserData',''); 
      textTolerance = uicontrol(... 
	  'CallBack','lyngby_ui_ks_init(''textTolerance'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ 0.1 Row2 0.38 ButtonHeight ],... 
	  'String','Tolerance:',... 
	  'Style','text',... 
	  'Tag','textTolerance',... 
	  'UserData',''); 

      set(editEdgedrop, 'String', num2str(KS_EDGEDROP));
      set(editTolerance, 'String', num2str(KS_TOLERANCE));


      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonHelp buttonClose ... 
	  editEdgedrop textEdgedrop ... 
	  editTolerance textTolerance ... 
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 
      %disp('buttonApply selected.') 
      
      [edgedrop, count1] = sscanf(get(editEdgedrop, 'String'), '%d'); 
      [tolerance, count2] = sscanf(get(editTolerance, 'String'), '%f'); 
      if (count1==1 & edgedrop >= 0) 
	KS_EDGEDROP = edgedrop; 
      else 
	error([ 'The number of scans to drop around transitions ' ...
	      'must be integer and non-negative.']); 
      end 
      if (count2==1 & tolerance >= 0) 
	KS_TOLERANCE = tolerance; 
      else 
	error('The Tolerance must be non-negative.'); 
      end 
      
    elseif command == 2 
      %disp('buttonHelp selected.') 

      helpwin('lyngby_ui_ks_init')
      
      
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command == 4 
      %disp('editEdgedrop selected.') 
    elseif command == 5 
      %disp('editTolerance selected.') 

    else 
      error('Error: lyngby_ui_ks_init.m called with incorrect command.') 
    end 





