function lyngby_ui_loadfile(command,parameter1) 

% lyngby_ui_loadfile - Opens a window for specifying file parameters
%
%       function lyngby_ui_loadfile(command,parameter1)
%
%       This function controls the user interface for the setup of 
%       the file loading parameters. The function is automatically
%       called when the user presses the 'Load new data ...' button in
%       the main window. The actual load is handle by lyngby_getdata
%       and the functions that lyngby_getdata uses.
%
%       The window is used to specify which data files to load and how
%       they are to be read. It also defines how the data is
%       associated with masks to remove transient scans, non-brain
%       voxels and specification of a region of interest. 
%
%       The initial settings of this window are as defined in the
%       'data_init.m' file that you may have written to be kept
%       alongside your dataset. This could then be used to
%       pre-configure your load options, so that you only need to
%       press the 'Load' button to start loading your data. Entries in
%       this window (and hence also in the data_init.m file) will take
%       precedence over the header files. If you want to re-read
%       the data_init.m file at any point, select 'Re-read Defaults'
%       from the pull-down Options menu.
%
%       Use the top-left pane to select the data files and the correct
%       loading format. Then you can use the 'Try to setup' button
%       to attempt a probe of the header files for the chosen
%       format. Make any alterations to the required fields, and then
%       press the 'Apply' button to fix the changes. The entries in
%       the fields in this window will take precedence over the header
%       fields, allowing you to correct for corrupted headers. Then
%       use the lower right-hand pane to define the external masks on
%       the data. Once this has been done, press the 'Load Data'
%       button at the bottom, and the window will close and the data
%       will start to be loaded, with the progress displayed in the
%       status line of the main window.
%
%       See also LYNGBY, LYNGBY_GETDATA, LYNGBY_UI_MAIN,
%                LYNGBY_UI_VOXELMASK, LYNGBY_READ_ANALYZE. 
%
% $Id: lyngby_ui_loadfile.m,v 1.50 2004/03/08 11:59:36 fnielsen Exp $

%  Made with:	GUI Maker Ver 2.1 by Patrick Marchand
%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 


    lyngby_global;
    lyngby_ui_option;
    lyngby_ui_global;
    lyngby_prep_global;

    
    sDatatype = [ 'uchar|schar|int8|int16|int32|int64|'...
	  'uint8|uint16|uint32|uint64|'...
	  'Single|Float32|Double|Float64|'...
	  'Float|Double|Short|Byte|Long' ];

    
% Code to reset values in fields to the defaults.
% ===============================================
    PopupListString = [ 
	'PopupList = [popupDatatype popupOrderingxyz popupEndian,'...
	'popupOrientationX popupOrientationY popupOrientationZ popupCompression,' ...
	'];' ];
    PopupStatusString = [ 
	'PopupStatus = [textStatus10 textStatus11 textStatus12,'...
	'textStatus13 textStatus14 textStatus15 textRightStatus12,' ...
	'];' ];
    EditListString = [ 
	'EditList = [editStartIndex editScale editScaleoffset,'...
	'editVoxelX editVoxelY editVoxelZ editDataOffset,'...
	'];' ];
    EditStatusString = [ 
	'EditStatus = [textStatus05 textRightStatus01 textRightStatus02,'...
	'textRightStatus03 textRightStatus04 textRightStatus05 textRightStatus11,'...
	'];' ];
    NumberOfPopups = 7;
    NumberOfEdits = 7;
    % Matrix entries represent the 'Value' of the popup control
    % which indicates the menu entry.
    PopupDefaultMatrix = [ ...
	10 1 1 1 1 1 1; %  FILETYPE = 1
	10 1 1 1 1 1 1; %  FILETYPE = 2
	10 1 1 1 1 1 1; %  FILETYPE = 3
	10 1 1 2 1 1 1; %  FILETYPE = 4
	10 1 1 2 1 1 1; %  FILETYPE = 5
	10 1 1 1 1 1 1; %  FILETYPE = 6
	10 1 1 1 2 1 1; %  FILETYPE = 7
		   ];
    % Matrix entries represent the numbers to be used in the edit
    % field of each ui object.
    EditDefaultMatrix = [ ...
	1, 1, 0, 0.001, 0.001, 0.001, 0; %  FILETYPE = 1
	1, 1, 0, 0.001, 0.001, 0.001, 0; %  FILETYPE = 2
	1, 1, 0, 0.001, 0.001, 0.001, 0; %  FILETYPE = 3
	1, 1, 0, 0.001, 0.001, 0.001, 0; %  FILETYPE = 4
	1, 1, 0, 0.001, 0.001, 0.001, 0; %  FILETYPE = 5
	1, 1, 0, 0.001, 0.001, 0.001, 0; %  FILETYPE = 6
	1, 1, 0, 0.001, 0.001, 0.001, 0; %  FILETYPE = 7
			];
    UpdateDefaults = [ ...
	'FileType = get(popupFileFormat, ''Value'');'...
	'eval(PopupListString);',...
	'eval(PopupStatusString);',...
	'for buttonindex = 1:NumberOfPopups;',...
	' if strcmp(get(PopupStatus(buttonindex),''String''),''Default''),',...
	'  set(PopupList(buttonindex), ''Value'', PopupDefaultMatrix(FileType,buttonindex));',...
	' end;',...
	'end;',...
	'eval(EditListString);',...
	'eval(EditStatusString);',...
	'for buttonindex = 1:NumberOfEdits;',...
	' if strcmp(get(EditStatus(buttonindex),''String''),''Default''),',...
	'  set(EditList(buttonindex), ''String'', EditDefaultMatrix(FileType,buttonindex));',...
	' end;',...
	'end;',...
		     ];

% Code to check for validity of each of the fields depending upon format.
% Specifies whether field should be used when loading. Allows data
% to remain in fields when switching between formats. 1=valid, 0=invalid.
% =======================================================================
    ValidityListString = [
	'ValidityList = [ editPath editFilePattern,'...
	'editStartIndex editStopIndex ,'...
	'editRawX editRawY editRawZ,'...
	'popupDatatype popupOrderingxyz popupEndian,'...
	'popupOrientationX popupOrientationY popupOrientationZ,'...
	'editScale editScaleoffset,'...
	'editVoxelX editVoxelY editVoxelZ,'...
	'editOriginX editOriginY editOriginZ,'...
	'editPlaneAngle editTimeRepeat,'...
	'editDataOffset popupCompression editExtractDir,'...
	'];' ];
    ValidityMatrixString = [
	'ValidityMatrix = ['...
	'1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 1 1;'... %  FILETYPE = 1
	'1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0;'... %  FILETYPE = 2
	'1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1;'... %  FILETYPE = 3
	'1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0;'... %  FILETYPE = 4
	'1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0;'... %  FILETYPE = 5
	'1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0;'... %  FILETYPE = 6
	'1 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0;'... %  FILETYPE = 7
	'];' ];
    NumberOfControls = 26;
    UpdateValidity = [ ...
	'FileType = get(popupFileFormat, ''Value'');'...
	'eval(ValidityListString);',...
	'eval(ValidityMatrixString);',...	
	'for buttonindex = 1:NumberOfControls,',...
	' set(ValidityList(buttonindex), ''UserData'', ValidityMatrix(FileType,buttonindex));',...
	' M(buttonindex)=ValidityMatrix(FileType,buttonindex);',...
	'end;',...
		     ];
    
    
% Code to dis/enable (greyout) relevant buttons depending on file format
% ======================================================================
    ButtonListString = [ 
	'ButtonList = [textPathMessage editPath textStatus02,'...
	'buttonBrowse, textStatus03,' ...
	'editFilePattern textFilePattern textStatus04,'...
	'textStartIndex editStartIndex textStatus05,'...
	'textStopIndex editStopIndex textStatus06,'...
	'textImageSize textX editRawX textStatus07,'...
	'textY editRawY textStatus08,'...
	'textZ editRawZ textStatus09,'...
	'textDataType popupDatatype textStatus10,' ...
	'textOrdering popupOrderingxyz textStatus11,'...
	'textEndian popupEndian textStatus12,'...
	'textOrientation textOrderingX popupOrientationX textStatus13,' ...
	'textOrderingY popupOrientationY textStatus14,'...
	'textOrderingZ popupOrientationZ textStatus15,'...
	'textGreyscale textScale editScale textRightStatus01,' ...
	'textScaleoffset editScaleoffset textRightStatus02,'...
	'textVoxelDimensions textVoxelX editVoxelX textRightStatus03,' ...
	'textVoxelY editVoxelY textRightStatus04,' ...
	'textVoxelZ editVoxelZ textRightStatus05,' ...
	'textOriginVoxel textOriginX editOriginX textRightStatus06,' ...
	'textOriginY editOriginY textRightStatus07,'...
	'textOriginZ editOriginZ textRightStatus08,'...
	'textPlaneAngle editPlaneAngle textRightStatus09,'...
	'textTimeRepeat editTimeRepeat textRightStatus10,'...
	'textDataOffset editDataOffset textRightStatus11,' ...
	'textCompression popupCompression textRightStatus12,' ...
	'textExtractDir editExtractDir textRightStatus13,' ...
	'buttonTrySetup buttonLoad,' ...
	'];' ];
    NumberOfButtons = 87;
    % Defines which buttons are on (1) or off (0) when a particular
    % filetype is chosen. Matrix is 7 rows (filetypes) by 81
    % columns (button objects). Individual rows are split into
    % shorter ones for clarity, each one corresponding to an 
    % actual row in the loadfile window.
    EnableMatrix = [ 0 1 1 ...   % textPathMessage (FILETYPE = 1 Simple)
		     1 1 ...     % buttonBrowse
		     1 1 1 ...   % editFilePattern
		     1 1 1 ...   % textStartIndex
		     1 1 1 ...   % textStopIndex
		     1 1 1 1 ... % textImageSize
		     1 1 1 ...   % textY
		     1 1 1 ...   % textZ
		     0 0 0 ...   % textDataType
		     1 1 1 ...   % textOrdering
		     1 1 1 ...   % textEndian
		     1 1 1 1 ... % textOrientation
		     1 1 1 ...   % textOrderingY
		     1 1 1 ...   % textOrderingZ
		     1 0 0 0 ... % textGreyscale
		     0 0 0 ...   % textScaleoffset
		     1 0 0 0 ... % textVoxelDimensions
		     0 0 0 ...   % textVoxelY
		     0 0 0 ...   % textVoxelZ
		     1 0 0 0 ... % textOriginVoxel
		     0 0 0 ...   % textOriginY
		     0 0 0 ...   % textOriginZ
		     1 0 0 ...   % textPlaneAngle
		     1 0 0 ...   % textTimeRepeat
		     0 0 0 ...   % textDataOffset
		     1 1 1 ...   % textCompression
		     1 1 1 ...   % textExtractDir
		     1 0; ...    % Try to setup
		     
		     1 1 1 ...   % textPathMessage (FILETYPE = 2 Lyngby)
		     0 0 ...     % buttonBrowse
		     0 0 0 ...   % editFilePattern
		     1 1 1 ...   % textStartIndex
		     1 1 1 ...   % textStopIndex
		     1 1 1 1 ... % textImageSize
		     1 1 1 ...   % textY
		     1 1 1 ...   % textZ
		     1 1 1 ...   % textDataType
		     1 1 1 ...   % textOrdering
		     1 1 1 ...   % textEndian
		     1 1 1 1 ... % textOrientation
		     1 1 1 ...   % textOrderingY
		     1 1 1 ...   % textOrderingZ
		     1 0 0 0 ... % textGreyscale
		     0 0 0 ...   % textScaleoffset
		     1 0 0 0 ... % textVoxelDimensions
		     0 0 0 ...   % textVoxelY
		     0 0 0 ...   % textVoxelZ
		     1 0 0 0 ... % textOriginVoxel
		     0 0 0 ...   % textOriginY
		     0 0 0 ...   % textOriginZ
		     1 0 0 ...   % textPlaneAngle
		     1 0 0 ...   % textTimeRepeat
		     0 0 0 ...   % textDataOffset
		     0 0 0 ...   % textCompression
		     0 0 0 ...   % textExtractDir
		     1 0; ...    % Try to setup

		     0 1 1 ...   % textPathMessage (FILETYPE = 3 Raw)
		     1 1 ...     % buttonBrowse
		     1 1 1 ...   % editFilePattern
		     1 1 1 ...   % textStartIndex
		     1 1 1 ...   % textStopIndex
		     1 1 1 1 ... % textImageSize
		     1 1 1 ...   % textY
		     1 1 1 ...   % textZ
		     1 1 1 ...   % textDataType
		     1 1 1 ...   % textOrdering
		     1 1 1 ...   % textEndian
		     1 1 1 1 ... % textOrientation
		     1 1 1 ...   % textOrderingY
		     1 1 1 ...   % textOrderingZ
		     1 0 0 0 ... % textGreyscale
		     0 0 0 ...   % textScaleoffset
		     1 1 1 1 ... % textVoxelDimensions
		     1 1 1 ...   % textVoxelY
		     1 1 1 ...   % textVoxelZ
		     1 0 0 0 ... % textOriginVoxel
		     0 0 0 ...   % textOriginY
		     0 0 0 ...   % textOriginZ
		     1 0 0 ...   % textPlaneAngle
		     1 0 0 ...   % textTimeRepeat
		     1 1 1 ...   % textDataOffset
		     1 1 1 ...   % textCompression
		     1 1 1 ...   % textExtractDir
		     0 0; ...    % Try to setup

		     0 1 1 ...   % textPathMessage (FILETYPE = 4 Analyze)
		     1 1 ...     % buttonBrowse
		     1 1 1 ...   % editFilePattern
		     1 1 1 ...   % textStartIndex
		     1 1 1 ...   % textStopIndex
		     1 1 1 1 ... % textImageSize
		     1 1 1 ...   % textY
		     1 1 1 ...   % textZ
		     1 1 1 ...   % textDataType
		     1 1 1 ...   % textOrdering
		     1 1 1 ...   % textEndian
		     1 1 1 1 ... % textOrientation
		     1 1 1 ...   % textOrderingY
		     1 1 1 ...   % textOrderingZ
		     1 1 1 1 ... % textGreyscale
		     1 1 1 ...   % textScaleoffset
		     1 1 1 1 ... % textVoxelDimensions
		     1 1 1 ...   % textVoxelY
		     1 1 1 ...   % textVoxelZ
		     1 1 1 1 ... % textOriginVoxel
		     1 1 1 ...   % textOriginY
		     1 1 1 ...   % textOriginZ
		     1 0 0 ...   % textPlaneAngle
		     1 0 0 ...   % textTimeRepeat
		     0 0 0 ...   % textDataOffset
		     0 0 0 ...   % textCompression
		     0 0 0 ...   % textExtractDir
		     1 0; ...    % Try to setup

		     0 1 1 ...   % textPathMessage (FILETYPE = 5 Analyze4d)
		     1 1 ...     % buttonBrowse
		     1 1 1 ...   % editFilePattern
		     0 0 0 ...   % textStartIndex
		     1 1 1 ...   % textStopIndex
		     1 1 1 1 ... % textImageSize
		     1 1 1 ...   % textY
		     1 1 1 ...   % textZ
		     1 1 1 ...   % textDataType
		     1 1 1 ...   % textOrdering
		     1 1 1 ...   % textEndian
		     1 1 1 1 ... % textOrientation
		     1 1 1 ...   % textOrderingY
		     1 1 1 ...   % textOrderingZ
		     1 0 0 0 ... % textGreyscale
		     0 0 0 ...   % textScaleoffset
		     1 0 0 0 ... % textVoxelDimensions
		     0 0 0 ...   % textVoxelY
		     0 0 0 ...   % textVoxelZ
		     1 0 0 0 ... % textOriginVoxel
		     0 0 0 ...   % textOriginY
		     0 0 0 ...   % textOriginZ
		     1 0 0 ...   % textPlaneAngle
		     1 0 0 ...   % textTimeRepeat
		     0 0 0 ...   % textDataOffset
		     0 0 0 ...   % textCompression
		     0 0 0 ...   % textExtractDir
		     1 0; ...    % Try to setup

		     0 1 1 ...   % textPathMessage (FILETYPE = 6 STD)
		     1 1 ...     % buttonBrowse
		     1 1 1 ...   % editFilePattern
		     0 0 0 ...   % textStartIndex
		     1 1 1 ...   % textStopIndex
		     1 1 1 1 ... % textImageSize
		     1 1 1 ...   % textY
		     1 1 1 ...   % textZ
		     1 1 1 ...   % textDataType
		     1 1 1 ...   % textOrdering
		     1 1 1 ...   % textEndian
		     1 1 1 1 ... % textOrientation
		     1 1 1 ...   % textOrderingY
		     1 1 1 ...   % textOrderingZ
		     1 0 0 0 ... % textGreyscale
		     0 0 0 ...   % textScaleoffset
		     1 0 0 0 ... % textVoxelDimensions
		     0 0 0 ...   % textVoxelY
		     0 0 0 ...   % textVoxelZ
		     1 0 0 0 ... % textOriginVoxel
		     0 0 0 ...   % textOriginY
		     0 0 0 ...   % textOriginZ
		     1 0 0 ...   % textPlaneAngle
		     1 0 0 ...   % textTimeRepeat
		     0 0 0 ...   % textDataOffset
		     0 0 0 ...   % textCompression
		     0 0 0 ...   % textExtractDir
		     1 0; ...    % Try to setup

		     0 1 1 ...   % textPathMessage (FILETYPE = 7 VAPET4d)
		     1 1 ...     % buttonBrowse
		     1 1 1 ...   % editFilePattern
		     0 0 0 ...   % textStartIndex
		     1 1 1 ...   % textStopIndex
		     1 1 1 1 ... % textImageSize
		     1 1 1 ...   % textY
		     1 1 1 ...   % textZ
		     1 1 1 ...   % textDataType
		     1 1 1 ...   % textOrdering
		     1 1 1 ...   % textEndian
		     1 1 1 1 ... % textOrientation
		     1 1 1 ...   % textOrderingY
		     1 1 1 ...   % textOrderingZ
		     1 0 0 0 ... % textGreyscale
		     0 0 0 ...   % textScaleoffset
		     1 0 0 0 ... % textVoxelDimensions
		     0 0 0 ...   % textVoxelY
		     0 0 0 ...   % textVoxelZ
		     1 0 0 0 ... % textOriginVoxel
		     0 0 0 ...   % textOriginY
		     0 0 0 ...   % textOriginZ
		     1 0 0 ...   % textPlaneAngle
		     1 0 0 ...   % textTimeRepeat
		     0 0 0 ...   % textDataOffset
		     0 0 0 ...   % textCompression
		     0 0 0 ...   % textExtractDir
		     1 0; ...    % Try to setup
		   ];
    % This function toggles the buttons related to the lyngby format
    % between 'active' and 'greyed-out'
    UpdateButtonEnabling = [ ...
	'FileType = get(popupFileFormat, ''Value'');',...
	'eval(ButtonListString);',...
	'for buttonindex = 1:NumberOfButtons;',...
	  ' if EnableMatrix(FileType,buttonindex),',...
	  '  sEnable = ''on'';',...
	  ' else,',...
	  '  sEnable = ''off'';',...
	  ' end;',...
	  'set(ButtonList(buttonindex), ''Enable'', sEnable);',...
	  'end;',...
	  ];


% Code to set the value of the status boxes to the relevant value
% ===============================================================
    StatusListString = [ 
	'StatusList = [textStatus02,'... % 1 editPath
	'textStatus03,' ...  % 2 buttonBrowse
	'textStatus04,'...   % 3 editFilePattern
	'textStatus05,'...   % 4 editStartIndex
	'textStatus06,'...   % 5 editStopIndex
	'textStatus07,'...   % 6 editX
	'textStatus08,'...   % 7 editY
	'textStatus09,'...   % 8 editZ
	'textStatus10,' ...  % 9 popupDatatype
	'textStatus11,'...   % 10 popupOrderingxyz
	'textStatus12,'...   % 11 popupEndian
	'textStatus13,' ...  % 12 popupOrientationX
	'textStatus14,'...   % 13 popupOrientationY
	'textStatus15,'...   % 14 popupOrientationZ
	'textRightStatus01,' ... % 15 editScale
	'textRightStatus02,'...  % 16 editScaleoffset
	'textRightStatus03,' ... % 17 editVoxelX
	'textRightStatus04,' ... % 18 editVoxelY
	'textRightStatus05,' ... % 19 editVoxelZ
	'textRightStatus06,' ... % 20 editOriginX
	'textRightStatus07,'...  % 21 editOriginY
	'textRightStatus08,'...  % 22 editOriginZ
	'textRightStatus09,' ... % 23 NEW
	'textRightStatus10,' ... % 24 NEW
	'textRightStatus11,' ... % 25 editDataOffset
	'textRightStatus12,' ... % 26 popupCompression
	'textRightStatus13,' ... % 27 editExtractDir
	'];' ];    
    % Enable matrix for the initial status of the status text boxes
    % Row = Filetype (1-7)
    % Column = status text box, in the order given in the
    %   'StatusList' vector.
    % Number = status, where 1=invalid (greyed out); 2=default;
    %   3=header; 4=user i/p; 5=best guess by the code;
    %   6=unknown - probably kept from other file format entry.
    InitialStatusMatrix = [ ...
	2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2; %  FILETYPE = 1
	2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2; %  FILETYPE = 2
	2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2; %  FILETYPE = 3
	2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2; %  FILETYPE = 4
	2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2; %  FILETYPE = 5
	2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2; %  FILETYPE = 6
	2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2; %  FILETYPE = 7
		   ];
    NumberOfStatusButtons = 27;
    % This function sets the status buttons to their initial values
    % as defined in the 'InitialStatusMatrix' matrix.
    UpdateInitialStatus = [ ...
	'FileType = get(popupFileFormat, ''Value'');',...
	'eval(StatusListString);',...
	'for statusbuttonindex = 1:NumberOfStatusButtons;',...
	' if InitialStatusMatrix(FileType,statusbuttonindex) == 1,',...
	'   status = ''< n/a >'';',...
	'   sEnable = ''off'';',...
	'  elseif InitialStatusMatrix(FileType,statusbuttonindex) == 2,',...
	'   status = ''<Default>'';',...
	'   sEnable = ''on'';',...
	'  elseif InitialStatusMatrix(FileType,statusbuttonindex) == 3,',...
	'   status = ''Header'';',...
	'   sEnable = ''on'';',...
	'  elseif InitialStatusMatrix(FileType,statusbuttonindex) == 4,',...
	'   status = ''User i/p'';',...
	'   sEnable = ''on'';',...
	'  elseif InitialStatusMatrix(FileType,statusbuttonindex) == 5,',...
	'   status = ''Guess'';',...
	'   sEnable = ''on'';',...
	'  elseif InitialStatusMatrix(FileType,statusbuttonindex) == 6,',...
	'   status = ''< ? >'';',...
	'   sEnable = ''on'';',...
	'  else,',...
	'   status = ''< ?!?!? >'';',...
	'   sEnable = ''on'';',...
	' end;',...
	' set(StatusList(statusbuttonindex), ''Enable'', sEnable);',...
	' if (strcmp(get(StatusList(statusbuttonindex), ''String''),''<Default>''))',...
	'   set(StatusList(statusbuttonindex), ''String'', status);',...
	'  elseif (strcmp(get(StatusList(statusbuttonindex), ''String''),''User i/p''))',...
	'   set(StatusList(statusbuttonindex), ''String'', ''User i/p'');',...
	'  else,',...
	'   set(StatusList(statusbuttonindex), ''String'', ''< ? >'');',...
	' end;',...
	'end;',...
		   ];    
    
% This function toggles the state of the tooltips help.
% =====================================================
    ToggleTooltips = [ ...
	  'ver = (version);', ...
	  'ver = str2num(ver(1:3));', ...
	  'if ver >= 5.2 & strcmp(get(menuTooltips, ''Checked''), ''on''),',...
	  '  UI_TOOLTIPS = 0;',...
	  '  set(menuTooltips, ''Checked'',''off'');',...
	  '  set(buttonClose, ''TooltipString'','''');',...
	  '  set(buttonLoad , ''TooltipString'','''');',...
	  '  set(buttonBrowse, ''TooltipString'','''');',...
	  '  set(textPathMessage, ''TooltipString'','''');',...
	  '  set(popupFileFormat, ''TooltipString'','''');',...
	  '  set(editStopIndex, ''TooltipString'','''');',...
	  '  set(editStartIndex, ''TooltipString'','''');',...
	  '  set(editFilePattern, ''TooltipString'','''');',...
	  '  set(editRawZ, ''TooltipString'','''');',...
	  '  set(editRawY, ''TooltipString'','''');',...
	  '  set(editRawX, ''TooltipString'','''');',...
	  '  set(popupEndian, ''TooltipString'','''');',...
	  '  set(popupOrientationZ, ''TooltipString'','''');',...
	  '  set(popupOrientationY, ''TooltipString'','''');',...
	  '  set(popupOrientationX, ''TooltipString'','''');',...
	  '  set(popupOrderingxyz, ''TooltipString'','''');',...
	  '  set(popupDatatype, ''TooltipString'','''');',...
	  '  set(editPath, ''TooltipString'','''');',...
	  '  set(buttonApply, ''TooltipString'','''');',...
	  '  set(buttonTimeMaskEdit, ''TooltipString'','''');',...
	  '  set(buttonTimeMaskHelp, ''TooltipString'','''');',...
	  '  set(buttonVolumeEdit, ''TooltipString'','''');',...
	  '  set(buttonVolumeHelp , ''TooltipString'','''');',...
	  '  set(buttonVoxelMaskEdit, ''TooltipString'','''');',...
	  '  set(buttonVoxelMaskHelp, ''TooltipString'','''');',...
	  '  set(buttonHelp, ''TooltipString'','''');',...
	  '  set(textGreyscale, ''TooltipString'','''');',...
	  '  set(textScale, ''TooltipString'','''');',...
	  '  set(textScaleoffset, ''TooltipString'','''');',...
	  '  set(editScale, ''TooltipString'','''');',...
	  '  set(editScaleoffset, ''TooltipString'','''');',...
	  '  set(textVoxelDimensions, ''TooltipString'','''');',...
	  '  set(textVoxelX, ''TooltipString'','''');',...
	  '  set(editVoxelX, ''TooltipString'','''');',...
	  '  set(textVoxelY, ''TooltipString'','''');',...
	  '  set(editVoxelY, ''TooltipString'','''');',...
	  '  set(textVoxelZ, ''TooltipString'','''');',...
	  '  set(editVoxelZ, ''TooltipString'','''');',...
	  '  set(textOriginVoxel, ''TooltipString'','''');',...
	  '  set(textOriginX, ''TooltipString'','''');',...
	  '  set(editOriginX, ''TooltipString'','''');',...
	  '  set(textOriginY, ''TooltipString'','''');',...
	  '  set(editOriginY, ''TooltipString'','''');',...
	  '  set(textOriginZ, ''TooltipString'','''');',...
	  '  set(editOriginZ, ''TooltipString'','''');',...
	  '  set(textDataOffset, ''TooltipString'','''');',...
	  '  set(editDataOffset, ''TooltipString'','''');',...
	  '  set(textCompression, ''TooltipString'','''');',...
	  '  set(popupCompression, ''TooltipString'','''');',...
	  '  set(textExtractDir, ''TooltipString'','''');',...
	  '  set(editExtractDir, ''TooltipString'','''');',...
	  '  set(textPlaneAngle, ''TooltipString'','''');',...
	  '  set(editPlaneAngle, ''TooltipString'','''');',...
	  '  set(textTimeRepeat, ''TooltipString'','''');',...
	  '  set(editTimeRepeat, ''TooltipString'','''');',...
	  '  set(buttonTrySetup, ''TooltipString'','''');',...	
	  'elseif ver >= 5.2,',...
	  '  UI_TOOLTIPS = 1;',...
	  '  set(menuTooltips, ''Checked'',''on'');',...
	  '  set(buttonClose, ''TooltipString'',''Cancel loading and close this window'');',...
	  '  set(buttonLoad , ''TooltipString'',''Close window and load data as specified'');',...
	  '  set(buttonBrowse , ''TooltipString'',''Locate data for non-lyngby formats'');',...
	  '  set(textPathMessage, ''TooltipString'',''Lyngby data is only loaded in from the starting directory'');',...
	  '  set(popupFileFormat, ''TooltipString'',''Choose data file format'');',...
	  '  set(editStopIndex, ''TooltipString'',''The number of scans in the dataset'');',...
	  '  set(editStartIndex, ''TooltipString'',''The index number of the first scan'');',...
	  '  set(editFilePattern, ''TooltipString'',''Naming convention of the data files'');',...
	  '  set(editRawZ, ''TooltipString'',''Z dimension of the raw image'');',...
	  '  set(editRawY, ''TooltipString'',''Y dimension of the raw image'');',...
	  '  set(editRawX, ''TooltipString'',''X dimension of the raw image'');',...
	  '  set(popupEndian, ''TooltipString'',''The format in which the local machine reads and writes data onto the disk'');',...
	  '  set(popupOrientationZ, ''TooltipString'',''Orientation of transversal data'');',...
	  '  set(popupOrientationY, ''TooltipString'',''Orientation of sagittal data'');',...
	  '  set(popupOrientationX, ''TooltipString'',''Orientation of coronal data'');',...
	  '  set(popupOrderingxyz, ''TooltipString'',''Byte ordering of the data within the file'');',...
	  '  set(popupDatatype, ''TooltipString'',''The size of the individual data variable units'');',...
	  '  set(editPath, ''TooltipString'',''Type in the path of the non-lyngby data'');',...
	  '  set(buttonApply, ''TooltipString'',''Apply any recent changes - you must press here before loading in data'');',...
	  '  set(buttonTrySetup, ''TooltipString'',''Attempt to read the header of the files as specified above and fill-in the respective fields'');',...
	  '  set(buttonTimeMaskEdit, ''TooltipString'',''Press to edit the TIME MASK variable'');',...
	  '  set(buttonTimeMaskHelp, ''TooltipString'',''Help about the TIME MASK variable'');',...
	  '  set(buttonVoxelMaskEdit, ''TooltipString'',''Press to edit the VOXEL MASK variable - not implemented yet'');',...
	  '  set(buttonVoxelMaskHelp, ''TooltipString'',''Help about the VOXEL MASK variable'');',...
	  '  set(buttonVolumeEdit, ''TooltipString'',''Press to edit the ROI or view the volume data'');',...
	  '  set(buttonVolumeHelp , ''TooltipString'',''Help about the Volume/ROI options'');',...
	  '  set(buttonHelp, ''TooltipString'',''Main help for this window'');',...
	  '  set(textGreyscale, ''TooltipString'',''How the data maps to the colourmap - not implemented yet'');',...
	  '  set(textScale, ''TooltipString'',''The scaling of the data colourmap'');',...
	  '  set(textScaleoffset, ''TooltipString'',''The offset of the data colourmap'');',...
	  '  set(editScale, ''TooltipString'',''The scaling of the data colourmap'');',...
	  '  set(editScaleoffset, ''TooltipString'',''The offset of the data colourmap'');',...
	  '  set(textVoxelDimensions, ''TooltipString'',''The real-world dimensions of the data - not implemented yet'');',...
	  '  set(textVoxelX, ''TooltipString'',''Size in X direction'');',...
	  '  set(editVoxelX, ''TooltipString'',''Size in X direction'');',...
	  '  set(textVoxelY, ''TooltipString'',''Size in Y direction'');',...
	  '  set(editVoxelY, ''TooltipString'',''Size in Y direction'');',...
	  '  set(textVoxelZ, ''TooltipString'',''Size in Z direction'');',...
	  '  set(editVoxelZ, ''TooltipString'',''Size in Z direction'');',...
	  '  set(textOriginVoxel, ''TooltipString'',''Location of the data Origin voxel - not implemented yet'');',...
	  '  set(textOriginX, ''TooltipString'',''Location of Origin along X direction'');',...
	  '  set(editOriginX, ''TooltipString'',''Location of Origin along X direction'');',...
	  '  set(textOriginY, ''TooltipString'',''Location of Origin along Y direction'');',...
	  '  set(editOriginY, ''TooltipString'',''Location of Origin along Y direction'');',...
	  '  set(textOriginZ, ''TooltipString'',''Location of Origin along Z direction'');',...
	  '  set(editOriginZ, ''TooltipString'',''Location of Origin along Z direction'');',...
	  '  set(textDataOffset, ''TooltipString'',''Offset to first data point'');',...
	  '  set(editDataOffset, ''TooltipString'',''Offset to first data point'');',...
	  '  set(textCompression, ''TooltipString'',''Compression method used'');',...
	  '  set(popupCompression, ''TooltipString'',''Compression method used'');',...
	  '  set(textExtractDir, ''TooltipString'',''Directory to use for decompressing data'');',...
	  '  set(editExtractDir, ''TooltipString'',''Directory to use for decompressing data'');',...
	  '  set(textPlaneAngle, ''TooltipString'',''The angle of the data to the horizontal - not implemented yet'');',...
	  '  set(editPlaneAngle, ''TooltipString'',''The angle of the data to the horizontal - not implemented yet'');',...
	  '  set(textTimeRepeat, ''TooltipString'',''The Tr repeat time in seconds - not implemented yet'');',...
	  '  set(editTimeRepeat, ''TooltipString'',''The Tr repeat time in seconds - not implemented yet'');',...
	  'end,',...
	  ];


    if nargin == 0 
      command = 'new'; 

    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonLoad')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonBrowse')) 
	command = 3; 
      elseif strcmp(lower(command),lower('popupFileFormat')) 
	command = 5; 
      elseif strcmp(lower(command),lower('editStopIndex')) 
	command = 7; 
      elseif strcmp(lower(command),lower('editStartIndex')) 
	command = 8; 
      elseif strcmp(lower(command),lower('editFilePattern')) 
	command = 9; 
      elseif strcmp(lower(command),lower('editRawY')) 
	command = 10; 
      elseif strcmp(lower(command),lower('editRawX')) 
	command = 11; 
      elseif strcmp(lower(command),lower('editRawZ')) 
	command = 11.5; 
      elseif strcmp(lower(command),lower('popupOrientationZ')) 
	command = 12; 
      elseif strcmp(lower(command),lower('popupOrientationY')) 
	command = 13; 
      elseif strcmp(lower(command),lower('popupOrientationX')) 
	command = 14; 
      elseif strcmp(lower(command),lower('popupOrderingxyz')) 
	command = 15; 
      elseif strcmp(lower(command),lower('popupDatatype')) 
	command = 16; 
      elseif strcmp(lower(command),lower('buttonTrySetup')) 
	command = 17;
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 18;
      elseif strcmp(lower(command),lower('buttonRunEdit')) 
	command = 19;
      elseif strcmp(lower(command),lower('buttonRunHelp')) 
	command = 20;
      elseif strcmp(lower(command),lower('buttonParadigmEdit')) 
	command = 21;
      elseif strcmp(lower(command),lower('buttonParadigmHelp')) 
	command = 22;
      elseif strcmp(lower(command),lower('buttonTimeMaskEdit')) 
	command = 23;
      elseif strcmp(lower(command),lower('buttonTimeMaskHelp')) 
	command = 24;
      elseif strcmp(lower(command),lower('buttonVolumeEdit')) 
	command = 25;
      elseif strcmp(lower(command),lower('buttonVolumeHelp')) 
	command = 26;
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 27;

      elseif strcmp(lower(command),lower('textPathMessage')) 
	command = 28;

      elseif strcmp(lower(command),lower('editPath')) 
	command = 30;
      elseif strcmp(lower(command),lower('popupEndian')) 
	command = 31;
      elseif strcmp(lower(command),lower('editScale')) 
	command = 32;
      elseif strcmp(lower(command),lower('editScaleoffset')) 
	command = 33;
      elseif strcmp(lower(command),lower('editVoxelX')) 
	command = 34;
      elseif strcmp(lower(command),lower('editVoxelY')) 
	command = 35;
      elseif strcmp(lower(command),lower('editVoxelZ')) 
	command = 36;
      elseif strcmp(lower(command),lower('editOriginX')) 
	command = 37;
      elseif strcmp(lower(command),lower('editOriginY')) 
	command = 38;
      elseif strcmp(lower(command),lower('editOriginZ')) 
	command = 39;      
      elseif strcmp(lower(command),lower('editPlaneAngle')) 
	command = 40;
      elseif strcmp(lower(command),lower('editTimeRepeat')) 
	command = 41;
      elseif strcmp(lower(command),lower('editDataOffset')) 
	command = 42;
      elseif strcmp(lower(command),lower('popupCompression')) 
	command = 43;
      elseif strcmp(lower(command),lower('editExtractDir')) 
	command = 44;
      elseif strcmp(lower(command),lower('buttonVoxelMaskEdit')) 
	command = 45;
      elseif strcmp(lower(command),lower('buttonVoxelMaskHelp')) 
	command = 46;
      
      
      elseif strcmp(lower(command),lower('ToggleTooltips'))
	command = 100;
      elseif strcmp(lower(command),lower('ResetDefaults'))
	command = 120;

      end 
    end 

    
    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_loadfile'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_loadfile.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameLeft1 = handle_list (1);
	frameLeft2 = handle_list (2);
	frameLeft3 = handle_list (3);
	frameLeft4 = handle_list (4);
	frameRight1 = handle_list (5);
	frameRight2 = handle_list (6);
	frameRight3 = handle_list (7);
	frameRight4 = handle_list (8);
	frameRight5 = handle_list (9);
	frameBottom = handle_list (10);
	
	buttonClose = handle_list(11); 
	buttonLoad = handle_list(12); 
	buttonBrowse = handle_list(13); 
	popupFileFormat = handle_list(14); 
	editStopIndex = handle_list(15); 
	editStartIndex = handle_list(16); 
	editFilePattern = handle_list(17); 
	editRawX = handle_list(18); 
	editRawY = handle_list(19); 
	editRawZ = handle_list(20); 
	textStartIndex = handle_list(21); 
	textStopIndex = handle_list(22); 
	textFilePattern = handle_list(23); 
	textOrdering = handle_list(24); 
	textY = handle_list(25); 
	textX = handle_list(26); 
	textFormat = handle_list(27); 
	popupOrientationZ = handle_list(28); 
	popupOrientationY = handle_list(29); 
	popupOrientationX = handle_list(30); 
	popupOrderingxyz = handle_list(31); 
	popupDatatype = handle_list(32); 
	editPath = handle_list(33);
	buttonApply = handle_list(34);

	textOrientation = handle_list(35);
	textOrderingX = handle_list(36);
	textOrderingY = handle_list(37);
	textOrderingZ = handle_list(38);
	textRightTitle = handle_list(39);
	textRun = handle_list(40);
	buttonRunEdit = handle_list(41);
	buttonRunHelp = handle_list(42);
	textParadigm = handle_list(43);
	buttonParadigmEdit = handle_list(44);
	buttonParadigmHelp = handle_list(45);
	textTimeMask = handle_list(46);
	buttonTimeMaskEdit = handle_list(47);
	buttonTimeMaskHelp = handle_list(48);
	textVolume = handle_list(49);
	buttonVolumeEdit = handle_list(50);
	buttonVolumeHelp = handle_list(51);
	buttonHelp = handle_list(52);
	textDataType = handle_list(53);
	textImageSize = handle_list(54);
	textPathMessage = handle_list(55);

	textEndian = handle_list(56);
	popupEndian = handle_list(57);
        textStatusTitle = handle_list(58);
	textStatus01 = handle_list(59);
	textStatus02 = handle_list(60);
	textStatus03 = handle_list(61);
	textStatus04 = handle_list(62);
	textStatus05 = handle_list(63);
	textStatus06 = handle_list(64);
	textStatus07 = handle_list(65);
	textStatus08 = handle_list(66);
	textStatus09 = handle_list(67);
	textStatus10 = handle_list(68);
	textStatus11 = handle_list(69);
	textStatus12 = handle_list(70);
	textStatus13 = handle_list(71);
	textStatus14 = handle_list(72);
	textStatus15 = handle_list(73);

        textRightStatusTitle = handle_list(74);
	textRightStatus01 = handle_list(75);
	textRightStatus02 = handle_list(76);
	textRightStatus03 = handle_list(77);
	textRightStatus04 = handle_list(78);
	textRightStatus05 = handle_list(79);
	textRightStatus06 = handle_list(80);
	textRightStatus07 = handle_list(81);
	textRightStatus08 = handle_list(82);
	textRightStatus09 = handle_list(83);
	textRightStatus10 = handle_list(84);
	textRightStatus11 = handle_list(85);

	textGreyscale = handle_list(86);
	textScale = handle_list(87);
	textScaleoffset = handle_list(88);
	editScale = handle_list(89);
	editScaleoffset = handle_list(90);
	textVoxelDimensions = handle_list(91);
	textVoxelX = handle_list(92);
	editVoxelX = handle_list(93);
	textVoxelY = handle_list(94);
	editVoxelY = handle_list(95);
	textVoxelZ = handle_list(96);
	editVoxelZ = handle_list(97);
	textOriginVoxel = handle_list(98);
	textOriginX = handle_list(99);
	editOriginX = handle_list(100);
	textOriginY = handle_list(101);
	editOriginY = handle_list(102);
	textOriginZ = handle_list(103);
	editOriginZ = handle_list(104);
	textDataOffset = handle_list(105);
	editDataOffset = handle_list(106);
	textCompression = handle_list(107);
	popupCompression = handle_list(108);
        textExtractDir = handle_list(109);
	editExtractDir = handle_list(110);
	textZ = handle_list(111);
	textVoxelMask = handle_list(112);
	buttonVoxelMaskEdit = handle_list(113);
	buttonVoxelMaskHelp= handle_list(114);
	buttonTrySetup = handle_list(115);
	textRightStatus12 = handle_list(116);
	textRightStatus13 = handle_list(117);
	textPlaneAngle = handle_list(118);
	editPlaneAngle = handle_list(119);
	textTimeRepeat = handle_list(120);
	editTimeRepeat = handle_list(121);
	menuOptions = handle_list(122);
	menuTooltips = handle_list(123);	
	menuResetDefaults = handle_list(124);	
      end 
    end 
    
    
    if command == 0 

      fig = findobj(get(0,'children'),'flat','tag','lyngby_ui_loadfile'); 
      if length(fig) > 0 
	set(fig,'visible','on'); 
	figure(fig); 
	return; 
      end 
      sc = get(0, 'ScreenSize');
      fig = figure('position',[ 220 max(1,sc(4)-510) 700 462 ],... 
	  'resize','On','tag','lyngby_ui_loadfile',... 
	  'menubar','None','name', 'Lyngby - Load setup',... 
	  'numbertitle','Off','visible','off','color',UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 

      % Default button positions etc...
      x1 = 0.03;  % Left pane labels
      x2 = 0.15;  % Large edit boxes
      x3 = 0.24;  % X, Y, Z labels
      x4 = 0.22;  % 
      x5 = 0.30;  % Small edit boxes
      x6 = 0.385; % Status boxes
      x7 = 0.52;   % Right pane labels
      x8 = 0.68;   % Mid labels
      x9 = 0.64;   % Extract dir edit box
      x10 = 0.74;  % X, Y, Z labels
      x11 = 0.78;  % Main edit boxes
      x12 = 0.88; % Status boxes
      x13 = 0.51;
      x14 = 0.74;

      % Left pane defaults...
      y1 = 0.91;   % File Format
      y2 = 0.86;  % File Path
      y3 = 0.81;  % Browse Path
      y4 = 0.76;  % File Pattern
      y5 = 0.69;  % Start Index
      y6 = 0.64;  % Stop Index
      y7 = 0.57;  % Image Size, X
      y8 = 0.52;  % Image Size, Y
      y9 = 0.47;  % Image Size, Z
      y10 = 0.42; % Word Size
      y11 = 0.37; % Byte Ordering
      y12 = 0.32; % Endian
      y13 = 0.30; 
      y14 = 0.26; % Data Orientation title
      y15 = 0.21; % Data Orientation - coronal
      y16 = 0.16; % Data Orientation - sagittal
      y17 = 0.11; % Data Orientation - transversal

      % Right pane defaults...
      ry1  = 0.95;  % Status Title
      ry2  = 0.91;  % Greyscale Scale
      ry3  = 0.86;  % Greyscale Offset
      ry4  = 0.795;  % Voxel dims, X
      ry5  = 0.745;  % Voxel dims, Y
      ry6  = 0.695;  % Voxel dims, Z
      ry7  = 0.63;  % Origin Voxel, X
      ry8  = 0.58;  % Origin Voxel, Y
      ry9  = 0.53;  % Origin Voxel, Z
      ry10 = 0.48;  %NEW
      ry11 = 0.43;  %NEW
      ry12 = 0.365;   % Offset (bytes)
      ry13 = 0.315;   % Compression
      ry14 = 0.265;   % Extract dir.
      ry15 = 0.20;   % Time Mask
      ry16 = 0.15;   % Voxel Mask
      ry17 = 0.10;   % Volume
      ry18 = 0.05;

      w1 = 0.12;
      w2 = 0.23;
      w3 = 0.16;
      w4 = 0.12;
      w5 = 0.09;
      w6 = 0.10;    % Status boxes
      w7 = 0.16;    % Small edit boxes
      w8 = 0.19;    % Time mask/Volume labels
      w9 = 0.09;    % Right edit boxes
      w10= 0.04;    % Right X, Y, Z labels
      w11= 0.13;    % Edit.. button for masks etc
      w12= 0.205;    % Mask labels

      h1 = 0.045; % Button height
      h2 = 0.030; % Text height
      h3 = 0.035; % Status text box height

      % Frames

      frameLeft1 = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.007 0.75 0.4879 0.24 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameLeft1',... 
	  'UserData',''); 
      frameLeft2 = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.007 0.63 0.4879 0.12 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameLeft2',... 
	  'UserData',''); 
      frameLeft3 = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.007 0.31 0.4879 0.32 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameLeft3',... 
	  'UserData',''); 
      frameLeft4 = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.007 0.09 0.4879 0.22 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameLeft4',... 
	  'UserData',''); 
      
      frameRight1 = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.5017 0.85 0.4879 0.14 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameRight1',... 
	  'UserData',''); 
      frameRight2 = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.5017 0.685 0.4879 0.165 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameRight2',... 
	  'UserData',''); 
      frameRight3 = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.5017 0.42 0.4879 0.265 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameRight3',... 
	  'UserData',''); 
      frameRight4 = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.5017 0.255 0.4879 0.165 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameRight4',... 
	  'UserData',''); 
      frameRight5 = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.5017 0.09 0.4879 0.165 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameRight5',... 
	  'UserData',''); 

      frameBottom = uicontrol(...
	  'Units','normalized',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'Position',[ 0.007 0.01 0.9826 0.07 ],... 
	  'String','',... 
	  'Style','frame',... 
	  'Tag','frameBottom',... 
	  'UserData',''); 


      % Main buttons - bottom pane

      buttonTrySetup = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonTrySetup'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.03 0.023 0.18 0.045 ],... 
	  'String','Try to setup',... 
	  'Style','pushbutton',... 
	  'Tag','buttonTrySetup',... 
	  'UserData',''); 

      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonApply'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.22 0.023 0.18 0.045 ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 

      buttonLoad = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonLoad'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.41 0.023 0.18 0.045 ],... 
	  'String','Load Data!',... 
	  'Style','pushbutton',... 
	  'Tag','buttonLoad',... 
	  'UserData',''); 	    	    

      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonClose'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.60 0.023 0.18 0.045 ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData',''); 

      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonHelp'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ 0.79 0.023 0.18 0.045 ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 

      % Left-hand pane buttons

      textFormat = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textFormat'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y1 w1 h2],... 
	  'HorizontalAlignment','left',...
	  'String','File Format:',... 
	  'Style','text',... 
	  'Tag','textFormat',... 
	  'UserData',''); 

      popupFileFormat = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''popupFileFormat'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x2 y1 w2 h1 ],... 
	  'String', ['Simple|' ...
	    'Lyngby Format|Raw|Analyze|Analyze4d|SDT|VAPET4d'],... 
	  'Style','popupmenu',... 
	  'Tag','popupFileFormat',... 
	  'UserData',''); 

      buttonBrowse = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonBrowse'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x2 y3 w2 h1 ],... 
	  'String','Browse path..',... 
	  'Style','pushbutton',... 
	  'Tag','buttonBrowse',... 
	  'UserData',''); 

      editPath = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editPath'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x2 y2 w2 h1 ],... 
	  'String','',... 
	  'Style','edit',... 
	  'Tag','editPath',... 
	  'UserData',''); 

      textLocation = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''textLocation'');',... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ x1 y2 w1 h2 ],... 
	  'String','Location:',... 
	  'Style','text',... 
	  'Tag','textLocation',... 
	  'HorizontalAlignment','left',...
	  'Visible','on',...
	  'UserData',''); 
      
      textPathMessage = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''textPathMessage'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','on',...
	  'Units','normalized',... 
	  'Position',[ x2+0.01 y2+0.005 w2-0.03 h1-0.015 ],... 
	  'String','Lyngby Starting Dir.',... 
	  'Style','text',... 
	  'Tag','textPathMessage',... 
	  'Visible','off',...
	  'UserData',''); 

      textFilePattern = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textFilePattern'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y4 w1 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','File Pattern:',... 
	  'Style','text',... 
	  'Tag','textFormat',... 
	  'Enable','off',...
	  'UserData',''); 

      editFilePattern = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editFilePattern'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',...
	  'Position',[ x2 y4 w2 h1 ],... 
	  'String','myfile%03d.hdr',... 
	  'Style','edit',... 
	  'Tag','editFilePattern',... 
	  'UserData',''); 

      textStartIndex = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textStartIndex'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y5 0.28 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Start Index (first scan no.):',... 
	  'Style','text',... 
	  'Tag','textStartIndex',... 
	  'Enable','off',...
	  'UserData',''); 

      editStartIndex = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editStartIndex'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x5 y5 0.08 h1 ],... 
	  'String','',... 
	  'Style','edit',... 
	  'Tag','editStartIndex',... 
	  'Enable','off',...
	  'UserData',''); 

      textStopIndex = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''textStopIndex'');',... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y6 0.28 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','No. of Scans (final - first):',... 
	  'Style','text',... 
	  'Tag','textStopIndex',... 
	  'Enable','off',...
	  'UserData',''); 

      editStopIndex = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editStopIndex'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x5 y6 0.08 h1 ],... 
	  'String','',... 
	  'Style','edit',... 
	  'Tag','editStopIndex',... 
	  'Enable','off',...
	  'UserData',''); 

      textImageSize = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textImageSize'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 (y7+y8)/2 0.2 h2*2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Image Dimensions (Voxels):',... 
	  'Style','text',... 
	  'Tag','textImageSize',... 
	  'Enable','off',...
	  'UserData',''); 
      
      textX = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''textX'');',... 
	  'Units','normalized',... 
	  'Position',[ x3 y7 0.045 h2 ],... 
	  'HorizontalAlignment','right',...
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'String','X:',... 
	  'Style','text',... 
	  'Tag','textX',... 
	  'Enable','off',...
	  'UserData',''); 

      editRawX = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editRawX'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x5 y7 0.08 h1 ],... 
	  'Style','edit',... 
	  'Tag','editRawX',... 
	  'UserData',''); 

      textY = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''textY'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'Units','normalized',... 
	  'Position',[ x3 y8 0.047 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','Y:',... 
	  'Style','text',... 
	  'Tag','textY',... 
	  'Enable','off',...
	  'UserData',''); 

      editRawY = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editRawY'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x5 y8 0.08 h1 ],... 
	  'Style','edit',... 
	  'Tag','editRawY',... 
	  'UserData',''); 

      textZ = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''textZ'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'Units','normalized',... 
	  'Position',[ x3 y9 0.047 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','Z:',... 
	  'Style','text',... 
	  'Tag','textY',... 
	  'Enable','off',...
	  'UserData',''); 

      editRawZ = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editRawZ'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x5 y9 0.08 h1 ],... 
	  'Style','edit',... 
	  'Tag','editRawZ',... 
	  'UserData',''); 

      textDataType = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textDataType'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y10 w2 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Image Word Size:',... 
	  'Style','text',... 
	  'Tag','textDataType',... 
	  'Enable','off',...
	  'UserData',''); 

      popupDatatype = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''popupDatatype'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Max',[ 5 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x4 y10 w3 h1 ],... 
	  'String', sDatatype,... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupDatatype',... 
	  'UserData',''); 

      textOrdering = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textOrdering'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y11 w2 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','File Byte Ordering:',... 
	  'Style','text',... 
	  'Tag','textOrdering',... 
	  'Enable','off',...
	  'UserData',''); 

      popupOrderingxyz = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''popupOrderingxyz'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Max',[ 6 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x4 y11 w3 h1 ],... 
	  'String','XYZ|XZY|YZX|YXZ|ZXY|ZYX',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupOrderingxyz',... 
	  'UserData',''); 

      textEndian = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textEndian'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y12 w2 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Data Endian:',... 
	  'Style','text',... 
	  'Tag','textEndian',... 
	  'Enable','off',...
	  'UserData',''); 
      popupEndian = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''popupEndian'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Max',[ 6 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x4 y12 w3 h1 ],... 
	  'String','Big|Little',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupEndian',... 
	  'UserData',''); 

      textOrientation = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textOrientation'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y14 0.455 0.03 ],... 
	  'String','Image Orientation',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textOrientation',... 
	  'Enable','off',...
	  'UserData',''); 

      textOrderingX = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textOrderingX'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y15 w1 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Coronal:',... 
	  'Style','text',... 
	  'Tag','textOrderingX',... 
	  'Enable','off',...
	  'UserData',''); 

      popupOrientationX = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''popupOrientationX'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x2 y15 w2 h1],... 
	  'String','X: Left->Right|X: Right->Left',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupOrientationX',... 
	  'UserData',''); 

      textOrderingY = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textOrderingY'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y16 w1 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Sagittal:',... 
	  'Style','text',... 
	  'Tag','textOrderingY',... 
	  'Enable','off',...
	  'UserData',''); 

      popupOrientationY = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''popupOrientationY'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x2 y16 w2 h1 ],... 
	  'String','Y: Post->Ant|Y: Ant->Post',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupOrientationY',... 
	  'UserData',''); 

      textOrderingZ = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textOrderingZ'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x1 y17 w1 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Transversal:',... 
	  'Style','text',... 
	  'Tag','textOrderingZ',... 
	  'Enable','off',...
	  'UserData',''); 

      popupOrientationZ = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''popupOrientationZ'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'Enable','off',...
	  'Max',[ 2 ],... 
	  'Min',[ 1 ],... 
	  'Units','normalized',... 
	  'Position',[ x2 y17 w2 h1 ],... 
	  'String','Z: Inf->Sup|Z: Sup->Inf',... 
	  'Style','popupmenu',... 
	  'Value',[ 1 ],... 
	  'Tag','popupOrientationZ',... 
	  'UserData',''); 
      
      % Left Status Buttons
       textStatusTitle = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textStatusTitle'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y1+h3+0.005 w6 h3-0.005 ],... 
	  'String','Status',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatusTitle',... 
	  'UserData',''); 

      textStatus01 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus01'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y1 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus01',... 
	  'UserData',''); 
       textStatus02 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus02'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y2 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus02',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus03 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus03'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y3 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus03',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus04 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus04'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y4 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus04',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus05 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus05'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y5 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus05',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus06 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus06'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y6 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus06',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus07 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus07'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y7 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus07',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus08 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus08'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y8 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus08',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus09 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus09'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y9 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus09',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus10 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus10'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y10 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus10',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus11 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus11'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y11 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus11',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus12 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus12'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y12 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus12',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus13 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus13'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y15 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus13',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus14 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus14'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y16 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus14',... 
	  'Enable','off',...
	  'UserData',''); 
       textStatus15 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textStatus15'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x6 y17 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textStatus15',... 
	  'Enable','off',...
	  'UserData',''); 

      % Right hand pane...
      textGreyscale = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textGreyscale'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry2 w6 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Greyscale',... 
	  'Style','text',... 
	  'Tag','textGreyscale',... 
	  'Enable','off',...
	  'UserData',''); 
      textScale = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textScale'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x8 ry2 w6 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','Scale:',... 
	  'Style','text',... 
	  'Tag','textScale',... 
	  'Enable','off',...
	  'UserData',''); 
      textScaleoffset = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textScaleoffset'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x8 ry3 w6 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','Offset:',... 
	  'Style','text',... 
	  'Tag','textScaleoffset',... 
	  'Enable','off',...
	  'UserData',''); 
      editScale = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editScale'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry2 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editScale',... 
	  'UserData',''); 
       editScaleoffset = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editScaleoffset'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry3 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editScaleoffset',... 
	  'UserData',''); 

       textVoxelDimensions = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textVoxelDimensions'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry4 w12 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Voxel Dimensions (m)',... 
	  'Style','text',... 
	  'Tag','textVoxelDimensions',... 
	  'Enable','off',...
	  'UserData',''); 
      textVoxelX = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textVoxelX'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry4 w10 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','X:',... 
	  'Style','text',... 
	  'Tag','textVoxelX',... 
	  'Enable','off',...
	  'UserData',''); 
      editVoxelX = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editVoxelX'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry4 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editVoxelX',... 
	  'UserData',''); 
      textVoxelY = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textVoxelY'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry5 w10 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','Y:',... 
	  'Style','text',... 
	  'Tag','textVoxelY',... 
	  'Enable','off',...
	  'UserData',''); 
      editVoxelY = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editVoxelY'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry5 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editVoxelY',... 
	  'UserData',''); 
      textVoxelZ = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textVoxelZ'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry6 w10 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','Z:',... 
	  'Style','text',... 
	  'Tag','textVoxelZ',... 
	  'Enable','off',...
	  'UserData',''); 
      editVoxelZ = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editVoxelZ'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry6 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editVoxelZ',... 
	  'UserData',''); 

       textOriginVoxel = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textOriginVoxel'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry8 0.24 h2*3 ],... 
	  'HorizontalAlignment','left',...
	  'String','Location of Origin Voxel (Anterior Commissure)',... 
	  'Style','text',... 
	  'Tag','textOriginVoxel',... 
	  'Enable','off',...
	  'UserData',''); 
      textOriginX = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textOriginX'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry7 w10 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','X:',... 
	  'Style','text',... 
	  'Tag','textOriginX',... 
	  'Enable','off',...
	  'UserData',''); 
      editOriginX = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editOriginX'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry7 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editOriginX',... 
	  'UserData',''); 
      textOriginY = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textOriginY'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry8 w10 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','Y:',... 
	  'Style','text',... 
	  'Tag','textOriginY',... 
	  'Enable','off',...
	  'UserData',''); 
      editOriginY = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editOriginY'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry8 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editOriginY',... 
	  'UserData',''); 
      textOriginZ = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textOriginZ'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry9 w10 h2 ],... 
	  'HorizontalAlignment','right',...
	  'String','Z:',... 
	  'Style','text',... 
	  'Tag','textOriginZ',... 
	  'Enable','off',...
	  'UserData',''); 
      editOriginZ = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editOriginZ'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry9 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editOriginZ',... 
	  'UserData',''); 

      textPlaneAngle = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textPlaneAngle'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry10 0.26 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Plane angle to horiz. (deg):',... 
	  'Style','text',... 
	  'Tag','textPlaneAngle',... 
	  'Enable','off',...
	  'UserData',''); 
      editPlaneAngle = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editPlaneAngle'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry10 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editPlaneAngle',... 
	  'UserData',''); 
      textTimeRepeat = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textTimeRepeat'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry11 0.27 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Repeat Period, Tr (seconds):',... 
	  'Style','text',... 
	  'Tag','textTimeRepeat',... 
	  'Enable','off',...
	  'UserData',''); 
      editTimeRepeat = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editTimeRepeat'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry11 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editTimeRepeat',... 
	  'UserData',''); 
      
      
      textDataOffset = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textDataOffset'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry12 w8 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','File Offset (bytes):',... 
	  'Style','text',... 
	  'Tag','textDataOffset',... 
	  'Enable','off',...
	  'UserData',''); 
      editDataOffset = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editDataOffset'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x11 ry12 w9 h1 ],... 
	  'Style','edit',... 
	  'Tag','editDataOffset',... 
	  'UserData',''); 
      
      textCompression = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textCompression'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry13 0.25 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Compression method:',... 
	  'Style','text',... 
	  'Tag','textCompression',... 
	  'Enable','off',...
	  'UserData',''); 
      popupCompression = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''popupCompression'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x10 ry13 0.13 h1 ],... 
	  'String','None|*.gz|*.Z',... 
	  'Style','popupmenu',... 
	  'Tag','popupCompression',... 
	  'UserData',''); 

      textExtractDir = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textExtractDir'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry14 0.3 h2 ],... 
	  'HorizontalAlignment','left',...
	  'String','Extract to dir:',... 
	  'Style','text',... 
	  'Tag','textExtractDir',... 
	  'Enable','off',...
	  'UserData',''); 
      editExtractDir = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''editExtractDir'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Enable','off',...
	  'Units','normalized',... 
	  'Position',[ x10 ry14 0.13 h1 ],... 
	  'Style','edit',... 
	  'Tag','editExtractDir',... 
	  'UserData',''); 
      
      
      % Status boxes
       textRightStatusTitle = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_FRAME,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatusTitle'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry1 w6 h3-0.005 ],... 
	  'String','Status',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatusTitle',... 
	  'UserData',''); 

      textRightStatus01 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus01'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry2 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus01',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus02 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus02'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry3 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus02',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus03 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus03'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry4 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus03',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus04 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus04'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry5 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus04',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus05 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus05'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry6 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus05',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus06 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus06'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry7 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus06',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus07 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus07'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry8 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus07',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus08 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus08'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry9 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus08',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus09 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus09'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry10 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus09',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus10 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus10'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry11 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus10',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus11 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus11'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry12 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus11',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus12 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus12'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry13 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus12',... 
	  'Enable','off',...
	  'UserData',''); 
       textRightStatus13 = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightStatus13'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry14 w6 h3 ],... 
	  'String','<Default>',... 
          'HorizontalAlignment','center',...
	  'Style','text',... 
	  'Tag','textRightStatus13',... 
	  'Enable','off',...
	  'UserData',''); 

      textRightTitle = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRightTitle'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x8 y3 0.43 ((y1+h1)-y3) ],... 
	  'String', [' This pane is used to load, edit ' ...
	    'and/or define the major external influences ' ...
	    'on the data. These include the timing specification ' ...
	    'of different experiment ''trials'' and the removal ' ...
	    'of any unwanted scans'],... 
	  'Style','text',... 
	  'Tag','textRightTitle',... 
	  'Visible', 'off',...
	  'UserData',''); 

      textRun = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textRun'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x8 ry1 w3 h1 ],... 
	  'String','Run',... 
	  'Style','text',... 
	  'Tag','textRun',... 
	  'Visible', 'off',...
	  'UserData',''); 
      buttonRunEdit = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonRunEdit'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x9 ry1 w4 h1 ],... 
	  'String','Edit...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonRunEdit',... 
	  'Visible', 'off',...
	  'UserData','');       
      buttonRunHelp = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonRunHelp'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry2 w5 h1],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonRunHelp',... 
	  'Visible', 'off',...
	  'UserData',''); 
      
      textParadigm = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textParadigm'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x8 ry3 w3 h1 ],... 
	  'String','Paradigm',... 
	  'Style','text',... 
	  'Tag','textParadigm',... 
	  'Visible', 'off',...
	  'UserData',''); 
      buttonParadigmEdit = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonParadigmEdit'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x9 ry3 w4 h1 ],... 
	  'String','Edit...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonParadigmEdit',... 
	  'Visible', 'off',...
	  'UserData','');       
      buttonParadigmHelp = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonParadigmHelp'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry4 w5 h1 ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonParadigmHelp',... 
	  'Visible', 'off',...
	  'UserData',''); 
      
      textTimeMask = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textTimeMask'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry15 w12 h1 ],... 
	  'String','Time Mask',... 
	  'Style','text',... 
	  'Tag','textTimeMask',... 
	  'UserData',''); 
      buttonTimeMaskEdit = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonTimeMaskEdit'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry15 w11 h1 ],... 
	  'String','Edit...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonTimeMaskEdit',... 
	  'UserData','');       
      buttonTimeMaskHelp = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonTimeMaskHelp'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry15 w6 h1 ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonTimeMaskHelp',... 
	  'UserData',''); 

      textVoxelMask = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textVoxelMask'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry16 w12 h1 ],... 
	  'String','Voxel Mask',... 
	  'Style','text',... 
	  'Tag','textVoxelMask',... 
	  'UserData',''); 
      buttonVoxelMaskEdit = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonVoxelMaskEdit'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry16 w11 h1 ],... 
	  'String','Edit...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonVoxelMaskEdit',... 
	  'UserData', 1);       
      buttonVoxelMaskHelp = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonVoxelMaskHelp'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry16 w6 h1 ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonVoxelMaskHelp',... 
	  'UserData',''); 
      
      
      textVolume = uicontrol(... 
	  'BackgroundColor',UI_COLOUR_STATUS,... 
	  'CallBack','lyngby_ui_loadfile(''textVolume'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x7 ry17 w12 h1 ],... 
	  'String','Volume/ROI',... 
	  'Style','text',... 
	  'Tag','textVolume',... 
	  'UserData',''); 
      buttonVolumeEdit = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonVolumeEdit'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x10 ry17 w11 h1 ],... 
	  'String','Edit...',... 
	  'Style','pushbutton',... 
	  'Tag','buttonVolumeEdit',... 
	  'Enable', 'off',...
	  'UserData','');                  
      buttonVolumeHelp = uicontrol(... 
	  'CallBack','lyngby_ui_loadfile(''buttonVolumeHelp'');',... 
	  'BackgroundColor',UI_COLOUR_BUTTON,... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'Units','normalized',... 
	  'Position',[ x12 ry17 w6 h1 ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonVolumeHelp',... 
	  'UserData','');

      % -- Menu Definitions etc --
      % Setup Menu controls
      ver = (version);
      ver = str2num(ver(1:3));
      if ver >= 5.2 
	menuOptions = uimenu( ...
	    'Parent',fig,...
	    'Label','Options',...
	    'Tag','TagMenuOptions',...
	    'Visible','on');
	menuTooltips = uimenu(...
	    'Parent',menuOptions,...
	    'Label','&Toggle Tooltips',...
	    'Checked','on',...
	    'Callback','lyngby_ui_loadfile(''ToggleTooltips'');',...
	    'Tag','TagMenuTooltips',...
	    'Accelerator','T',...
	    'Visible','on');
 	menuResetDefaults = uimenu(...
	    'Parent',menuOptions,...
	    'Label','&Reset Defaults',...
	    'Callback','lyngby_ui_loadfile(''ResetDefaults'');',...
	    'Tag','TagMenuResetDefaults',...
	    'Accelerator','R',...
	    'Visible','on');
      else
	menuOptions = 0;
	menuTooltips = 0;
	menuResetDefaults = 0;
      end
      
      % Test global Tooltips settings and set this window to the same
      if UI_TOOLTIPS == 0  
	eval(ToggleTooltips);
      end

      
      % -- End of GUI definitions --          

      handle_list = [ ...  
	  frameLeft1 frameLeft2 frameLeft3 frameLeft4 ...
	  frameRight1 frameRight2 frameRight3 frameRight4 frameRight5 frameBottom ...
	  buttonClose buttonLoad buttonBrowse ... 
	  popupFileFormat editStopIndex ... 
	  editStartIndex editFilePattern editRawX editRawY  editRawZ ... 
	  textStartIndex textStopIndex textFilePattern textOrdering ... 
	  textY textX textFormat popupOrientationZ ... 
	  popupOrientationY popupOrientationX popupOrderingxyz popupDatatype ... 
	  editPath  ...
	  buttonApply ...
	  textOrientation textOrderingX textOrderingY textOrderingZ ...
	  textRightTitle textRun buttonRunEdit buttonRunHelp ...
	  textParadigm buttonParadigmEdit buttonParadigmHelp textTimeMask ...
	  buttonTimeMaskEdit buttonTimeMaskHelp textVolume buttonVolumeEdit ...
	  buttonVolumeHelp buttonHelp ...
	  textDataType textImageSize ...
	  textPathMessage ...
	  textEndian popupEndian ...
	  textStatusTitle ...
	  textStatus01 textStatus02 textStatus03 textStatus04 ...
	  textStatus05 textStatus06 textStatus07 textStatus08 ...
	  textStatus09 textStatus10 textStatus11 textStatus12 ...
	  textStatus13 textStatus14 textStatus15  ...
	  textRightStatusTitle ...
	  textRightStatus01 textRightStatus02 textRightStatus03 textRightStatus04 ...
	  textRightStatus05 textRightStatus06 textRightStatus07 textRightStatus08 ...
	  textRightStatus09 textRightStatus10 textRightStatus11 ...
	  textGreyscale textScale textScaleoffset ...
	  editScale editScaleoffset ...	  
	  textVoxelDimensions textVoxelX editVoxelX ...
	  textVoxelY editVoxelY textVoxelZ editVoxelZ ...
	  textOriginVoxel textOriginX editOriginX ...
	  textOriginY editOriginY ...
	  textOriginZ editOriginZ ...
	  textDataOffset editDataOffset ...
	  textCompression popupCompression ...
	  textExtractDir editExtractDir ...
	  textZ ...
	  textVoxelMask buttonVoxelMaskEdit buttonVoxelMaskHelp ...
	  buttonTrySetup ...
	  textRightStatus12  textRightStatus13 ...
	  textPlaneAngle editPlaneAngle ...
	  textTimeRepeat editTimeRepeat ...
	  menuOptions ...
	  menuTooltips ...
	  menuResetDefaults ...
	  ]; 

      eval(UpdateDefaults)      
      eval(UpdateValidity)

%%%%%%%%%%%%%%%%%%%%%%% Read globals %%%%%%%%%%%%%%%%%%%%%%%%%%%%%      
      xyz = lower(ORDERING);
      if strcmp(xyz,'xyz'),
	set(popupOrderingxyz,'value',1);
      elseif strcmp(xyz,'xzy'),
	set(popupOrderingxyz,'value',2);
      elseif strcmp(xyz,'yzx'),
	set(popupOrderingxyz,'value',3);
      elseif strcmp(xyz,'yxz'),
	set(popupOrderingxyz,'value',4);
      elseif strcmp(xyz,'zxy'),
	set(popupOrderingxyz,'value',5);
      elseif strcmp(xyz,'zyx'),
	set(popupOrderingxyz,'value',6);
      else
	error('Invalid ORDERING ');
      end 
      % lyngby_ui_loadfile('popupOrderingxyz');
      
      dir = reshape(ORIENTATION',1,6);
      s=lower(dir(1:2));
      if strcmp(s,'lr'),
	set(popupOrientationX,'value',1);
      elseif strcmp(s,'rl'),
	set(popupOrientationX,'value',2);
      else
	error(['Invalid ORIENTATION(1) ' s]);
      end 

      s = lower(dir(3:4));
      if strcmp(s,'pa'),
	set(popupOrientationY,'value',1);
      elseif strcmp(s,'ap'),
	set(popupOrientationY,'value',2);
      else
	error(['Invalid ORIENTATION(2) ' s]);
      end 
      
      s = lower(dir(5:6));
      if strcmp(s,'is'),
	set(popupOrientationZ,'value',1);
      elseif strcmp(s,'si'),
	set(popupOrientationZ,'value',2);
      else
	error(['Invalid ORIENTATION(3) ' s]);
      end 
      
      if isstr(FILE_READING_TYPE)
	if strcmp('analyze', lower(FILE_READING_TYPE))
	  set(popupFileFormat, 'value', 4);   % Set to Analyze
	elseif strcmp('analyze4d', lower(FILE_READING_TYPE))
	  set(popupFileFormat, 'value', 5);   % Set to Analyze 4D
	elseif strcmp('sdt', lower(FILE_READING_TYPE))
	  set(popupFileFormat, 'value', 6);   % Set to SDT
	elseif strcmp('vapet4d', lower(FILE_READING_TYPE))
	  set(popupFileFormat, 'value', 7);   % Set to VAPET 4D
	else
	  warning('Wrong FILE_READING_TYPE')
	  set(popupFileFormat, 'value', 4);   % Set to Analyze
	end
      else
	if FILE_READING_TYPE == 1,
	  set(popupFileFormat, 'value', 1);   % Set to Simple
	elseif FILE_READING_TYPE == 2,
	  set(popupFileFormat, 'value', 2);   % Set to Custom
	elseif FILE_READING_TYPE == 3,
	  set(popupFileFormat, 'value', 3);   % Set to Raw
	else
	  error('Invalid FILE_READING_TYPE');
	end 
      end
      
      eval(UpdateValidity) %%
      
      s = sprintf('%d', FILENAME_STARTINDEX);
      set(editStartIndex, 'string', s);
      set(editStartIndex, 'value', FILENAME_STARTINDEX);
      
      stopindex = NUM_SCANS;
      s = sprintf('%d', stopindex);
      set(editStopIndex, 'string', s);
      set(editStopIndex, 'string', stopindex);
      
      if length(NUM_VOXELS) == 3
	set(editRawX, 'string', NUM_VOXELS(1));
	set(editRawY, 'string', NUM_VOXELS(2));
	set(editRawZ, 'string', NUM_VOXELS(3));
      end
	
      set(editFilePattern,'string', FILENAME_PATTERN);
      
      set(editPath,'string', FILENAME_PATH);
      % lyngby_ui_loadfile('editFilePattern');

      datatype = lower(DATATYPE);
      s = lower(sDatatype);
      value = length(findstr(s(1:findstr(s, datatype)),'|'))+1;
      set(popupDatatype, 'Value', value);
      
      set(editScale, 'String', SCALE);
      set(editScaleoffset, 'String', OFFSET);

      if length(VOXELDIM) == 3
	set(editVoxelX, 'String', VOXELDIM(1));
	set(editVoxelY, 'String', VOXELDIM(2));
	set(editVoxelZ, 'String', VOXELDIM(3));
      end

      if length(ORIGIN) == 3
	set(editOriginX, 'String', ORIGIN(1));
	set(editOriginY, 'String', ORIGIN(2));
	set(editOriginZ, 'String', ORIGIN(3));
      end

      
      
%%%%%%%%%%%%%%%%%%%%%% End read globals %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


      eval(UpdateInitialStatus)      
      eval(UpdateButtonEnabling)      

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 
      

    elseif command == 1 
      % buttonClose
      % Close window - no loading of data

      close(h_fig_list);

    elseif command == 2 
      % buttonLoad

      

      % Close window

      close(h_fig_list);

      % Load data (used to be done by Load Go! button in Main window)

      lyngby_log('Loading data ...');
      X = lyngby_getdata(ROI_VOXELS, VOXEL_MASK, TIME_MASK);
      if isempty(X)
	lyngby_ui_message( [ ...
	      'No data found. ',...
	      'Please specify the location of the data. '...
	      ]);
      end
      lyngby_log('Finished loading data!');

      % Set the dataset-name in the Main window...
      if isempty(FILENAME_PATH)
	current_dir = pwd;
      else
	current_dir = FILENAME_PATH;
      end
      mainfighandle = findobj(get(0,'children'),'flat','tag','lyngby_ui_main');
      set(findobj(mainfighandle,'Tag','textDataset'), 'String', current_dir);

      lyngby_ui_main('UpdateButtonEnabling');
      
    elseif command == 3 
      % disp('buttonBrowse');	 
      
      [file,path] = uigetfile('*', 'Choose a file');
      if file ~= 0, 
	set(editFilePattern, 'string', file);
	set(editPath, 'string', path);
      end
      eval(StatusListString);
      set(StatusList(2), 'String', 'User i/p');
      set(StatusList(1), 'String', 'User i/p');
      
      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');

    elseif command == 4
      % radioRaw - obsolete...

    elseif command == 5 
      % popupFileFormat

      % Set status of fields with no default setting, and where
      % value is carried over from other file format, to 'User I/P'

      
      % Parsing for greying out relevant buttons...
      eval(UpdateInitialStatus);
      eval(UpdateButtonEnabling);
      set(textStatus01, 'String', 'User i/p');
      % Do not allow loading until variables have been stored
      set(buttonLoad, 'Enable', 'off');
      
      % Clear previous inputs which are not kept for the new format
      eval(UpdateDefaults);      
      
      eval(UpdateValidity);
      
      fileFormat = get(popupFileFormat, 'Value');
      if fileFormat == 2 % Lyngby format
	set(textPathMessage, 'String', 'Lyngby Starting Dir.');
	set(textPathMessage, 'Visible', 'on');
      else
	set(textPathMessage, 'Visible', 'off');
      end
      
      if fileFormat ~= 3 % Any format except Raw
	set(editDataOffset, 'String', ''); % Set to null
      end
      
      if any(fileFormat == [5 6 7]) % Analyze4D, STD or VAPET4D format
	set(editStartIndex, 'String', ''); % Set to null
      elseif (fileFormat == 4) % Analyze
	set(editStartIndex, 'String', '1'); % Set to default 1 - hack: should be
                                            % covered by the 'Update Defaults' routine
      end
      
      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 6 
      % radioStandard - obsolete...
      
    elseif command == 7 
      % disp('editStopIndex');
      
      xs = sscanf(get(editStopIndex,'string'),' %d');
      notok = 1;
      if (prod(size(xs)) == 1),
	if xs>=0 & xs<2000, 
	  set(editStopIndex,'userdata', xs);
	  s = sprintf('%d', xs);
	  notok = 0;
	end
      end
      if notok,
	s='';
	udat=get(editStopIndex, 'userdata');
	if udat,
	  s=sprintf('%d',udat);
	end
      end 
      set(editStopIndex,'string',s);
      eval(StatusListString);
      set(StatusList(5), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');      
      
    elseif command == 8 
      % disp('editStartIndex') 
      
      xb = sscanf(get(editStartIndex,'string'),' %d');
      notok = 1;
      if (prod(size(xb)) == 1),
	if xb>=0 & xb<2000, 
	  set(editStartIndex,'userdata', xb);
	  s = sprintf('%d', xb);
	  notok = 0;
	end
      end
      if notok,
	s='';
	udat=get(editStartIndex, 'userdata');
	if udat,
	  s=sprintf('%d',udat);
	end
      end 
      set(editStartIndex,'string',s);
      eval(StatusListString);
      set(StatusList(4), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');      
      
    elseif command == 9 
      % disp('editFilePattern'); 

      p = get(editFilePattern, 'string');
      if length(p)>0,
	if p(length(p))=='.',
	  % Remove erroneous final '.' from file pattern...
	  p = [p(1:length(p)-1)];
	end
      end
      set(editFilePattern, 'string', p);

      eval(StatusListString);
      set(StatusList(3), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 10 
      % editY
      eval(StatusListString);
      set(StatusList(7), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');      
      
    elseif command == 11
      % editX
      eval(StatusListString);
      set(StatusList(6), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 11.5 
      % editZ
      eval(StatusListString);
      set(StatusList(8), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 12 
      % popupOrientationZ
      eval(StatusListString);
      set(StatusList(14), 'String', 'User i/p');      

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 13 
      % popupOrientationY
      eval(StatusListString);
      set(StatusList(13), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 14 
      % popupOrientationX
      eval(StatusListString);
      set(StatusList(12), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 15
      % popupOrderingxyz
      eval(StatusListString);
      set(StatusList(10), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 16
      % popupDatatype
      eval(StatusListString);
      set(StatusList(9), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 17
      % buttonTrySetup
     
      fileFormat = get(popupFileFormat, 'Value');
      filenamePattern = get(editFilePattern,'string');
      filenamePath = get(editPath,'string');

      % Take account of case where first file to be loaded
      % is not the first file defined by the file pattern.
      % i.e. a pattern of XXX_%04d implies the first file is
      % XXX_0001, whereas it could be XXX_0021, as specified
      % by the 'Start Index' field....
      startfilename = sprintf(filenamePattern, FILENAME_STARTINDEX);
      
      % Generate full path to first file:
      filename = [filenamePath startfilename];
      
      lasterr(''); % Reset last error before attempting to load files.
      
      if fileFormat == 2  % Lyngby format
	% Read header info from the data_readinfo.m file, if it exists	
	if exist('data_readinfo') == 2
	  eval('Readinfo = data_readinfo;');     % eval is necessary
	else
	  lyngby_ui_message(['Unable to find/open the data_readinfo.m ' ...
			     'file for the Lyngby format! Ensure ' ...
			     'that the file exists in the correct ' ...
			     'directory and that the permissions ' ...
			     'allow it to be read.']);
        end

	% Check all variables and read into globals
	
	if isfield(Readinfo, 'num_voxels')
	  Num_Voxels = Readinfo.num_voxels;
	  if length(Num_Voxels) == 3
	    set(editRawX, 'string', Num_Voxels(1));
	    set(editRawY, 'string', Num_Voxels(2));
	    set(editRawZ, 'string', Num_Voxels(3));
	    set(textStatus07, 'String', 'Header'); % 6 editX
	    set(textStatus08, 'String', 'Header'); % 7 editY
	    set(textStatus09, 'String', 'Header'); % 8 editZ
	  end
	end
	
	if isfield(Readinfo, 'roi_voxels')
	  Roi_Voxels = Readinfo.roi_voxels;
	end
	
	if isfield(Readinfo, 'origin')
	  Origin = Readinfo.origin;
	  if length(Origin) == 3
	    set(editOriginX, 'string', Origin(1));
	    set(editOriginY, 'string', Origin(2));
	    set(editOriginZ, 'string', Origin(3));
	    set(textRightStatus06, 'String', 'Header'); % 20 editOriginX
	    set(textRightStatus07, 'String', 'Header'); % 21 editOriginY
	    set(textRightStatus08, 'String', 'Header'); % 22 editOriginZ
	  end
	end
	
	if isfield(Readinfo, 'datatype')
	  Datatype = Readinfo.datatype;
	  s = lower(sDatatype);
	  value = length(findstr(s(1:findstr(s, Datatype)),'|'))+1;
	  set(popupDatatype, 'Value', value);
	  set(textStatus10, 'String', 'Header'); % 9 popupDatatype
	end

	if isfield(Readinfo, 'num_scans')
	  Num_Scans = Readinfo.num_scans;
	  set(editStopIndex, 'String', Num_Scans);
	  set(textStatus06, 'String', 'Header'); % 5 editStopIndex
	end

	if isfield(Readinfo, 'num_runs')
	  Num_Runs = Readinfo.num_runs;
	end

	if isfield(Readinfo, 'num_subjects')
	  Num_Subjects = Readinfo.num_subjects;
	end

	if isfield(Readinfo, 'voxel_size')
	  Voxel_Size = Readinfo.voxel_size;
	end

	if isfield(Readinfo, 'discrim_tmask')
	  Discrim_Tmask = Readinfo.discrim_tmask;
	end

	if isfield(Readinfo, 'file_reading_type')
	  File_Reading_Type = Readinfo.file_reading_type;
	end

	if isfield(Readinfo, 'filename_pattern')
	  Filename_Pattern = Readinfo.filename_pattern;
	  set(editFilePattern,'string', Filename_Pattern);
	  set(textStatus04, 'String', 'Header'); % 3 editFilePattern	  
	end

	if isfield(Readinfo, 'filename_path')
	  Filename_Path = Readinfo.filename_path;
	  set(editPath,'string', Filename_Path);
	  set(textStatus02, 'String', 'Header'); % 1 editPath	  
	end

	if isfield(Readinfo, 'filename_startindex')
	  Filename_Startindex = Readinfo.filename_startindex;
	  set(editStartIndex, 'string', Filename_Startindex);
	  set(textStatus05, 'String', 'Header'); % 4 editStartIndex
	end

	if isfield(Readinfo, 'ordering')
	  Ordering = Readinfo.ordering;
	  if strcmp(Ordering,'xyz'),
	    set(popupOrderingxyz,'value',1);
	  elseif strcmp(Ordering,'xzy'),
	    set(popupOrderingxyz,'value',2);
	  elseif strcmp(Ordering,'yzx'),
	    set(popupOrderingxyz,'value',3);
	  elseif strcmp(Ordering,'yxz'),
	    set(popupOrderingxyz,'value',4);
	  elseif strcmp(Ordering,'zxy'),
	    set(popupOrderingxyz,'value',5);
	  elseif strcmp(Ordering,'zyx'),
	    set(popupOrderingxyz,'value',6);
	  else
	    error('Invalid ORDERING ');
	end 
	end

	if isfield(Readinfo, 'orientation')
	  Orientation = Readinfo.orientation;
	  if strcmp(Orientation(1:2), 'rl')
	    set(popupOrientationX, 'Value', 2);
	  else
	    set(popupOrientationX, 'Value', 1);
	  end
	  if strcmp(Orientation(3:4), 'ap')
	    set(popupOrientationY, 'Value', 2);
	  else
	    set(popupOrientationY, 'Value', 1);
	  end
	  if strcmp(Orientation(5:6), 'si')
	    set(popupOrientationZ, 'Value', 2);
	  else
	    set(popupOrientationZ, 'Value', 1);
	  end
	  set(textStatus13, 'String', 'Header'); % 12 popupOrientationX
	  set(textStatus14, 'String', 'Header'); % 13 popupOrientationY
	  set(textStatus15, 'String', 'Header'); % 14 popupOrientationZ 
	end

	if isfield(Readinfo, 'logfilename')
	  Logfilename = Readinfo.logfilename;
	end
	


      elseif fileFormat == 4
	% ANALYZE FORMAT
 	% -----------------------TEMP--------------------------------
 	% Need to add-in code for probing the Endian and setting
        % the field.
 	% Parse filename
 	pos=findstr(filename,'.img');
 	if (~isempty(pos))
 	  Nf=filename(1:(pos(1)-1));
 	end;  
 	pos=findstr(filename,'.hdr');
 	if (~isempty(pos))
 	  Nf=filename(1:(pos(1)-1));
 	end; 
 	FN=sprintf('%s.hdr',Nf);
 	
 	% Try to open file
 	pid=fopen(FN, 'rb', 'ieee-be'); % Try big endian first
	if (pid<0), % In case file doesn't exist or is unreadable 
	  lyngby_ui_message('Unable to open file - check filename, path and file permissions!'); 
	end
	fseek(pid, 0, 'bof');  % Ensure at start
	sizeof_hdr = fread(pid, 1, 'int32'); % Read header length
	if (sizeof_hdr==1543569408),  % Ooops, should be 348! Probably wrong endian
				      % Close and re-open with other endian
	  fclose(pid);
	  pid=fopen(FN, 'rb', 'ieee-le'); % Now try little endian
	  if (pid<0),  % In case file doesn't exist or is unreadable 
	    lyngby_ui_message('Unable to open file - check filename, path and file permissions!');
	  end
	  fseek(pid, 0, 'bof');  % Ensure at start
	  sizeof_hdr = fread(pid, 1, 'int32'); % Read header length
	  if (sizeof_hdr~=348),
	    % Err, dunno what's wrong!
	    lyngby_ui_message('Unable to open file - header maybe corrupted!');
	    HDR_ENDIAN='unknown';
	  end
	  HDR_ENDIAN='little';  
	else
	  HDR_ENDIAN='big';
	end
	fclose(pid);
 	
	% Set popup to correct value
	eval(StatusListString);
	if (strcmp(HDR_ENDIAN, 'big')),
	  set(popupEndian, 'Value', 1); % Big endian
	  set(StatusList(11), 'String', 'Guess');
	elseif (strcmp(HDR_ENDIAN, 'little')),
	  set(popupEndian, 'Value', 2); % Little endian
	  set(StatusList(11), 'String', 'Guess');
	else
	  set(StatusList(11), 'String', ' Error! ');
	end
 	%-----------------------END-TEMP--------------------------------

	try  % Attempt to load in files in Analyze format & catch errors
	% Test what the file pattern is set to and add .hdr if necessary....

	siz = lyngby_read_analyze(filename, 'Output', 'Size');
	set(editRawX, 'String', siz(1));
	set(editRawY, 'String', siz(2));
	set(editRawZ, 'String', siz(3));
	set(textStatus07, 'String', 'Header'); % 6 editX
	set(textStatus08, 'String', 'Header'); % 7 editY
	set(textStatus09, 'String', 'Header'); % 8 editZ
	    
	NoScans = lyngby_read_analyze(filename, 'Output', ...
					  'GuessFileNo');
	set(editStopIndex, 'String', NoScans);
	set(textStatus06, 'String', 'Guess'); % 5 editStopIndex
	    
	datatype = lower(lyngby_read_analyze(filename, 'Output', ...
						 'Datatype'));
	s = lower(sDatatype);
	value = length(findstr(s(1:findstr(s, datatype)),'|'))+1;
	set(popupDatatype, 'Value', value);
	set(textStatus10, 'String', 'Header'); % 9 popupDatatype
	
	set(popupOrderingxyz, 'Value', 1);
	set(textStatus11, 'String', 'Header'); % 10 popupOrderingxyz
	
	scale = lyngby_read_analyze(filename, 'Output', 'scale');%%%%%%%%
	set(editScale, 'String', sprintf('%6.4f',scale));
	set(editScale, 'UserData', scale);
	set(textRightStatus01, 'String', 'Header');
	
	offset = lyngby_read_analyze(filename, 'Output', 'offset');%%%%%%%%
	set(editScaleoffset, 'String', sprintf('%6.4f',offset));
	set(editScaleoffset, 'UserData', offset);
	set(textRightStatus02, 'String', 'Header');

	voxelDim = lyngby_read_analyze(filename, 'Output', 'voxeldim');
	set(editVoxelX, 'String', voxelDim(1));
	set(editVoxelY, 'String', voxelDim(2));
	set(editVoxelZ, 'String', voxelDim(3));
	set(textRightStatus03, 'String', 'Header');
	set(textRightStatus04, 'String', 'Header');
	set(textRightStatus05, 'String', 'Header');
	
	origin = lyngby_read_analyze(filename, 'Output', 'origin');
	set(editOriginX, 'String', origin(1));
	set(editOriginY, 'String', origin(2));
	set(editOriginZ, 'String', origin(3));
	set(textRightStatus06, 'String', 'Header');
	set(textRightStatus07, 'String', 'Header');
	set(textRightStatus08, 'String', 'Header');
	
	catch % Catch errors and act appropriately
	  l = lasterr;
	  test01 = findstr(l,'Files could not be opened:'); 
	  if ~isempty(test01) % If string test01 is in error message
	    attemptedfilename=sprintf(filename);
	    lyngby_ui_message(sprintf(['Cannot open the Analyze'...
		' files. Check that there are files with .hdr'...
		' extensions are in the correct directory.'...
		' Currently trying to load from:- \n %s.hdr'...
		' \n The current file settings are:-\n File Name'...
		' Pattern:-   %s \n Path:-   %s \n Maybe you have'...
		' set the File Pattern incorrectly -'...
		' remember to use standard pattern'...
		' identifiers. For example, to load all'...
		' the files from fmri_0001.img to'...
		' fmri_1234.img, your pattern would be \n'...
		' fmri_%%04d \n Remember to leave off'...
		' the file extension. The File Pattern only'...
		' specifies the area of the filename'...
		' that is to be incremented - the'...
		' Start Index and Number Of Scans are used to specify'...
		' the range.'],attemptedfilename,filenamePattern, filenamePath));
	  else
	    lyngby_ui_message(['Error: ' l]);
	  end 
	end

	% Check here to ensure it isn't a 4D Analyze file
	tmp_siz = lyngby_read_analyze(filename, 'Output', 'Size');
	tmp_x = tmp_siz(1);
	tmp_y = tmp_siz(2);
	tmp_z = tmp_siz(3);
	
      elseif fileFormat == 5
	% 4D ANALYZE FORMAT

	try  % Attempt to load in files in Analyze 4D format & catch errors
	siz = lyngby_read_ana4d(filename, 'Output', 'Size');
	set(editRawX, 'String', siz(1));
	set(editRawY, 'String', siz(2));
	set(editRawZ, 'String', siz(3));
	set(textStatus07, 'String', 'Header'); % 6 editX
	set(textStatus08, 'String', 'Header'); % 7 editY
	set(textStatus09, 'String', 'Header'); % 8 editZ
	
	NoScans = lyngby_read_ana4d(filename, 'Output', ...
	    'scans');
	set(editStopIndex, 'String', NoScans);
	set(textStatus06, 'String', 'Header'); % 5 editStopIndex
		
	datatype = lower(lyngby_read_ana4d(filename, 'Output', ...
	    'Datatype'));
	s = lower(sDatatype);
	value = length(findstr(s(1:findstr(s, datatype)),'|'))+1;
	set(popupDatatype, 'Value', value);
	set(popupOrderingxyz, 'Value', 1);
	set(textStatus10, 'String', 'Header'); % 9 popupDatatype
	set(textStatus11, 'String', 'Header'); % 10 popupOrderingxyz
	catch % Catch errors and act appropriately
	  l = lasterr;
	  test01 = findstr(l,'Files could not be opened:'); 
	  if ~isempty(test01) % If string test01 is in error message
	    lyngby_ui_message(['Cannot open the Analyze 4D files. ' ...
			       'Check that there are files with .hdr ' ...
			       'extensions are in the correct directory. ']);
	  else
	    lyngby_ui_message(sprintf('Some file error loading files. Error message was: %s', l));
	  end 
	end

	% Check here to ensure it really is a 4D file
	tmp_siz = lyngby_read_ana4d(filename, 'Output', 'Size');
	tmp_x = tmp_siz(1);
	tmp_y = tmp_siz(2);
	tmp_z = tmp_siz(3);
	tmp_t = lyngby_read_ana4d(filename, 'Output', 'scans');
	if ((tmp_x<=1)|(tmp_y<=1)|(tmp_z<=1)|(tmp_t<=1)),
	  lyngby_ui_message(sprintf(['File does not appear to be a 4D Analyze' ...
		    ' file!! The number of time-points appears to be' ...
		    ' %d. The volume appears to be of size: %d x' ...
		    ' %d x %d. Maybe you could try the other Analyze' ...
		    ' format.'], tmp_t, tmp_x, tmp_y, tmp_z));
	end

      elseif fileFormat == 6
	try  % Attempt to load in files in SDT format & catch errors
	siz = lyngby_read_sdt(filename, 'Output', 'Size');
	set(editRawX, 'String', siz(1));
	set(editRawY, 'String', siz(2));
	set(editRawZ, 'String', siz(3));
	set(textStatus07, 'String', 'Header'); % 6 editX
	set(textStatus08, 'String', 'Header'); % 7 editY
	set(textStatus09, 'String', 'Header'); % 8 editZ
	
	NoScans = lyngby_read_sdt(filename, 'Output', ...
	    'scans');
	set(editStopIndex, 'String', NoScans);
	set(textStatus06, 'String', 'Header'); % 5 editStopIndex
	
	datatype = lower(lyngby_read_sdt(filename, 'Output', ...
	    'Datatype'));
	s = lower(sDatatype);
	value = length(findstr(s(1:findstr(s, datatype)),'|'))+1;
	set(popupDatatype, 'Value', value);	
	set(popupOrderingxyz, 'Value', 1);
	set(textStatus10, 'String', 'Header'); % 9 popupDatatype
	set(textStatus11, 'String', 'Header'); % 10 popupOrderingxyz
	catch % Catch errors and act appropriately
	  l = lasterr;
	  test01 = findstr(l,'Files could not be opened:'); 
	  if ~isempty(test01) % If string test01 is in error message
	    lyngby_ui_message(['Cannot open the SDT files. ' ...
			       'Check that there are files with .spr ' ...
			       'extensions are in the correct directory. ']);
	  else
	    lyngby_ui_message('Some file error loading files');
	  end 
	end

      elseif fileFormat == 7
	try  % Attempt to load in files in VAPET 4D format & catch errors
	siz = lyngby_read_vapet4d(filename, 'Output', 'Size');
	set(editRawX, 'String', siz(1));
	set(editRawY, 'String', siz(2));
	set(editRawZ, 'String', siz(3));
	set(textStatus07, 'String', 'Header'); % 6 editX
	set(textStatus08, 'String', 'Header'); % 7 editY
	set(textStatus09, 'String', 'Header'); % 8 editZ
	
	NoScans = lyngby_read_vapet4d(filename, 'Output', ...
	    'scans');
	set(editStopIndex, 'String', NoScans);
	set(textStatus06, 'String', 'Header'); % 5 editStopIndex
	
	datatype = lower(lyngby_read_vapet4d(filename, 'Output', ...
	    'Datatype'));
	s = lower(sDatatype);
	value = length(findstr(s(1:findstr(s, datatype)),'|'))+1;
	set(popupDatatype, 'Value', value);
	set(textStatus10, 'String', 'Header'); % 9 popupDatatype
	
	orientation = lower(lyngby_read_vapet4d(filename, 'Output', ...
	    'Orientation'));
	if strcmp(orientation(1:2), 'rl')
	  set(popupOrientationX, 'Value', 2);
	else
	  set(popupOrientationX, 'Value', 1);
	end
	if strcmp(orientation(3:4), 'ap')
	  set(popupOrientationY, 'Value', 2);
	else
	  set(popupOrientationY, 'Value', 1);
	end
	if strcmp(orientation(5:6), 'si')
	  set(popupOrientationZ, 'Value', 2);
	else
	  set(popupOrientationZ, 'Value', 1);
	end
	set(textStatus13, 'String', 'Header'); % 12 popupOrientationX
	set(textStatus14, 'String', 'Header'); % 13 popupOrientationY
	set(textStatus15, 'String', 'Header'); % 14 popupOrientationZ 
	
	voxelMask = lyngby_read_vapet4d(filename, 'Output', ...
	    'VoxelMask');
	set(buttonVoxelMaskEdit, 'UserData', voxelMask);
	
	catch % Catch errors and act appropriately
	  l = lasterr;
	  test01 = findstr(l,'Files could not be opened:');
	  test02 = findstr(l,'Could not open file:');
	  test03 = findstr(l,'file%02d'); 
	  if (~isempty(test01)|(~isempty(test02))) % If string test01 or
                                                   % test02 is in
                                                   % the error message
	    lyngby_ui_message(['Cannot open the VAPET 4D files. ' ...
			       'Check that there are files with the VAPET 4D ' ...
			       'extensions are in the correct directory. ']);
	  elseif ~isempty(test03) % If string test02 is in error message
	    lyngby_ui_message(['Cannot open the VAPET 4D files. ' ...
			       'Specify the file pattern. ']);
	  else
	    lyngby_ui_message(sprintf('File error loading files: \n%s', l));
	  end 
	end
					       
      end
     
      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 18
      % buttonApply
      % Need to put in code here to check whether buttons are
      % valid before assigning values from the input fields.
      % Reqd to prevent settings from one filetype being passed
      % to another. Latest additions have trailing %

      % Moved up a bit so that can use NUM_SCANS in error checking....
      if (get(editStopIndex, 'UserData')~=0) % "User Data" field is 
                                             % also used for other stuff?
	si = sscanf(get(editStopIndex,'string'), '%d', 1);
	NUM_SCANS = si;
      else %
	NUM_SCANS = 1; %
      end %       
      
      if (get(editFilePattern, 'UserData')==1) %
	FILENAME_PATTERN = get(editFilePattern,'string');
	% Handle possible incorrect filename pattern specification
	%  (Only valid for certain file formats)
	value=get(popupFileFormat, 'value');
	test1=any(value==[1 3 4 6]);
	test2=isempty(findstr('%', FILENAME_PATTERN));
	test3=(NUM_SCANS<=1);
	if (test1&test2), 
	  lyngby_ui_message(sprintf(['You have specified a File' ...
		    ' Pattern without a numerical pattern identifier.' ...
		    ' If you don''t specify a pattern,'...
		    ' then the same volume will be loaded for each time'...
		    ' frame. For example, to load all'...
		    ' the files from fmri_0001.img to'...
		    ' fmri_1234.img, your pattern would be \n'...
		    ' fmri_%%04d \n Remember to leave off'...
		    ' the file extension. The File Pattern only'...
		    ' specifies the area of the filename'...
		    ' that is to be incremented - the'...
		    ' Start Index and Number Of Scans are used to specify'...
		    ' the range.']));
	end
	if (test1 & test3),
	  lyngby_ui_message(['Check the range of scans specified in' ...
			     ' the ''No. of Scans'' field - you' ...
			     ' probably need to specify multiple' ...
			     ' files for this format (one for each' ...
			     ' time-point)! Otherwise, if all your' ...
			     ' data (volume and time) is in one file,' ...
			     ' then maybe try using one of the 4D formats.']);
	end
      else %
	FILENAME_PATTERN = ''; %
      end %
      
      if (get(editPath, 'UserData')==1) %
	FILENAME_PATH = get(editPath,'string');
      else %
	FILENAME_PATH = ''; %
      end %

      % if (get(editStartIndex, 'UserData') == 1) %
      % 'UserData' for editStartIndex is both used to Validity and to
      % store a proper startindex!
      si = sscanf(get(editStartIndex,'string'), '%d', 1);
      if ~isempty(si)
	FILENAME_STARTINDEX = si;
      else %
	FILENAME_STARTINDEX = 1; %
      end %
     
      
      if (get(popupDatatype, 'UserData')==1) %
	value = get(popupDatatype, 'value');
	indices = [ 0 findstr(sDatatype, '|') length(sDatatype)+1 ];
	DATATYPE = sDatatype(indices(value)+1:indices(value+1)-1);
      else %
	DATATYPE = 'float32'; %
      end %
      
      fileReadingType = get(popupFileFormat, 'value');
      if any(fileReadingType == [1 2 3])
	FILE_READING_TYPE = fileReadingType;
      elseif fileReadingType == 4
	FILE_READING_TYPE = 'Analyze';
      elseif fileReadingType == 5
	FILE_READING_TYPE = 'Analyze4d';
      elseif fileReadingType == 6
	FILE_READING_TYPE = 'SDT';
      elseif fileReadingType == 7
	FILE_READING_TYPE = 'VAPET4D';
      else
	error(sprintf('Internal error: %d', fileReadingType));
      end

      % Size of the volume
      n1 = sscanf(get(editRawX, 'string'), '%d',1);
      n2 = sscanf(get(editRawY, 'string'), '%d',1);
      n3 = sscanf(get(editRawZ, 'string'), '%d',1);
      NUM_VOXELS = [n1 n2 n3];
      
      % Set the endian
      %  The endian popup shows the guessed endian of the *header*
      %  file if the 'Try to Setup' button has been used (for 
      %  Analyze files, at least). This is because guessing from
      %  the header file is reasonably robust, and *usually* the
      %  header and data files are stored with the same endian.
      %  However, upon loading, the value of the endian popup is 
      %  used for the *data* files, allowing the user to change
      %  the value of the endian from that of the header file if
      %  they do actually know that they're different endians, or
      %  that the guess was incorrect...
      if (get(popupEndian, 'Value')==1) % Big endian
	DATA_ENDIAN='ieee-be';
      else
	DATA_ENDIAN='ieee-le'; % Little endian
      end
            
      %	ORDERING
      xyz = get(popupOrderingxyz,'value');
      orderings = ['xyz'; 'xzy'; 'yzx'; 'yxz'; 'zxy'; 'zyx'];
      ORDERING = orderings(xyz,:);

      ox = get(popupOrientationX,'value');
      oy = get(popupOrientationY,'value');
      oz = get(popupOrientationZ,'value');
      if ox==2, 
	d = 'rl';
      else
	d = 'lr';
      end 
      if oy==2, 
	d = [d,'ap'];
      else
	d = [d,'pa'];
      end 
      if oz==2, 
	d = [d,'si'];
      else
	d = [d,'is'];
      end
      ORIENTATION = d;

%      SCALE = sscanf(get(editScale, 'UserData'), '%f', 1),%%%%%%%%
%      OFFSET = sscanf(get(editScaleoffset, 'UserData'), '%f', 1),%%%%%%%
      SCALE = get(editScale, 'UserData');%%%%%%%%
      OFFSET = get(editScaleoffset, 'UserData');%%%%%%%
      
      VOXELDIM(1) = sscanf(get(editVoxelX, 'String'), '%f', 1);
      VOXELDIM(2) = sscanf(get(editVoxelY, 'String'), '%f', 1);
      VOXELDIM(3) = sscanf(get(editVoxelZ, 'String'), '%f', 1);

      originX = sscanf(get(editOriginX, 'String'), '%f', 1);
      originY = sscanf(get(editOriginY, 'String'), '%f', 1);
      originZ = sscanf(get(editOriginZ, 'String'), '%f', 1);
      ORIGIN = [ originX originY originZ ];
      
      % Allow loading and ROI editing once variables have been stored
      set(buttonLoad, 'Enable', 'on');
      set(buttonVolumeEdit, 'Enable', 'on');
            
    elseif command == 19 
      % buttonRunEdit
      lyngby_log('Calling run ...');
      lyngby_ui_run;
      lyngby_log('Run called!');

    elseif command == 20 
      % buttonRunHelp
      S1 = [...
	    'Press ''Edit'' to define the RUN global variable. This is ',...
	    'used to specify, in time, the seperate experiment trials.',...
	    ];
      helpdlg(sprintf('%s', S1), 'Run Help');

    elseif command == 21 
      % buttonParadigmEdit
      lyngby_log('Calling paradigm ...');
      lyngby_ui_paradigm;
      lyngby_log('Paradigm called!');


    elseif command == 22 
      % buttonParadigmHelp
      S1 = [...
	    'Press ''Edit'' to define the PARADIGM global variable. This is ',...
	    'used to define the time-based correlation with the experimental stimulus ',...
	    ];
      helpdlg(sprintf('%s', S1), 'Paradigm Help');

    elseif command == 23 
      % buttonTimeMaskEdit
      lyngby_log('Calling time mask setup ...');
      lyngby_ui_time;
      lyngby_log('Time mask setup called!');


    elseif command == 24 
      % buttonTimeMaskHelp
      S1 = [...
	    'Press ''Edit'' to define the TIME MASK global variable. This is ',...
	    'used to discard any unwanted scans (e.g. initial or transient scans)',...
	    ];
      helpdlg(sprintf('%s', S1), 'Time Mask Help');

    elseif command == 25 
      % buttonVolumeEdit
      lyngby_log('Calling volume ...');
      lyngby_ui_volume;
      lyngby_log('Volume called!');


    elseif command == 26 
      % buttonVolumeHelp
      S1 = [...
	    'Press ''Edit'' to define the Region of Interest (ROI) and examine ',...
	    'a whole (spatial only) volume of data. No time information is used.',...
	    ];
      helpdlg(sprintf('%s', S1), 'Volume Help');

    elseif command == 27 
      % buttonHelp

      helpwin('lyngby_ui_loadfile');
      
    elseif command == 28 
      % textPathMessage

    elseif command == 30
      % editPath
      p = get(editPath, 'string');
      if length(p)>0,
	if p(length(p)) ~= filesep
	  p = [ p filesep ];
	end
      end
      set(editPath, 'string', p);
      
      eval(StatusListString);
      set(StatusList(1), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 31
      % popupEndian
      eval(StatusListString);
      set(StatusList(11), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 32
      % editScale
      eval(StatusListString);
      set(StatusList(15), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 33
      % editScaleoffset
      eval(StatusListString);
      set(StatusList(16), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 34
      % editVoxelX
      eval(StatusListString);
      set(StatusList(17), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 35 
      % editVoxelY
      eval(StatusListString);
      set(StatusList(18), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 36 
      % editVoxelZ
      eval(StatusListString);
      set(StatusList(19), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 37 
      % editOriginX
      eval(StatusListString);
      set(StatusList(20), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 38 
      % editOriginY
      eval(StatusListString);
      set(StatusList(21), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 39 
      % editOriginZ
      eval(StatusListString);
      set(StatusList(22), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 40 
      % editPlaneAngle
      eval(StatusListString);
      set(StatusList(23), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 41 
      % editTimeRepeat
      eval(StatusListString);
      set(StatusList(24), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 42 
      % editDataOffset
      eval(StatusListString);
      set(StatusList(25), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 43 
      % popupCompression
      eval(StatusListString);
      set(StatusList(26), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 44 
      % editExtractDir
      eval(StatusListString);
      set(StatusList(27), 'String', 'User i/p');

      % Reset 'Load' button to disabled - must press 'Apply' before 
      % loading to ensure new changes are included...
      set(buttonLoad, 'Enable', 'off');
      
    elseif command == 45 
      % buttonVoxelMaskEdit
      lyngby_ui_voxelmask

    elseif command == 46 
      helpwin('lyngby_ui_voxelmask')
      
    elseif command == 100
      % Toggle the state of the Tooltips help (on/off)
      eval(ToggleTooltips);
       
    elseif command == 120
      % Reset global variables to defaults settings from lyngby_init.m
      lyngby_init;


      % Set the popupFileFormat to that given in the data_init.m file.
      eval(UpdateDefaults)      
      eval(UpdateValidity)

      %%%%%%%%%%%%%%%%%%%%%%% Read globals %%%%%%%%%%%%%%%%%%%%%%%%%%%%%      
      xyz = lower(ORDERING);
      if strcmp(xyz,'xyz'),
	set(popupOrderingxyz,'value',1);
      elseif strcmp(xyz,'xzy'),
	set(popupOrderingxyz,'value',2);
      elseif strcmp(xyz,'yzx'),
	set(popupOrderingxyz,'value',3);
      elseif strcmp(xyz,'yxz'),
	set(popupOrderingxyz,'value',4);
      elseif strcmp(xyz,'zxy'),
	set(popupOrderingxyz,'value',5);
      elseif strcmp(xyz,'zyx'),
	set(popupOrderingxyz,'value',6);
      else
	error('Invalid ORDERING ');
      end 
      % lyngby_ui_loadfile('popupOrderingxyz');
      
      dir = reshape(ORIENTATION',1,6);
      s=lower(dir(1:2));
      if strcmp(s,'lr'),
	set(popupOrientationX,'value',1);
      elseif strcmp(s,'rl'),
	set(popupOrientationX,'value',2);
      else
	error(['Invalid ORIENTATION(1) ' s]);
      end 

      s = lower(dir(3:4));
      if strcmp(s,'pa'),
	set(popupOrientationY,'value',1);
      elseif strcmp(s,'ap'),
	set(popupOrientationY,'value',2);
      else
	error(['Invalid ORIENTATION(2) ' s]);
      end 
      
      s = lower(dir(5:6));
      if strcmp(s,'is'),
	set(popupOrientationZ,'value',1);
      elseif strcmp(s,'si'),
	set(popupOrientationZ,'value',2);
      else
	error(['Invalid ORIENTATION(3) ' s]);
      end 
      
      if isstr(FILE_READING_TYPE)
	if strcmp('analyze', lower(FILE_READING_TYPE))
	  set(popupFileFormat, 'value', 4);   % Set to Analyze
	elseif strcmp('analyze4d', lower(FILE_READING_TYPE))
	  set(popupFileFormat, 'value', 5);   % Set to Analyze 4D
	elseif strcmp('sdt', lower(FILE_READING_TYPE))
	  set(popupFileFormat, 'value', 6);   % Set to SDT
	elseif strcmp('vapet4d', lower(FILE_READING_TYPE))
	  set(popupFileFormat, 'value', 7);   % Set to VAPET 4D
	else
	  warning('Wrong FILE_READING_TYPE')
	  set(popupFileFormat, 'value', 4);   % Set to Analyze
	end
      else
	if FILE_READING_TYPE == 1,
	  set(popupFileFormat, 'value', 1);   % Set to Simple
	elseif FILE_READING_TYPE == 2,
	  set(popupFileFormat, 'value', 2);   % Set to Custom
	elseif FILE_READING_TYPE == 3,
	  set(popupFileFormat, 'value', 3);   % Set to Raw
	else
	  error('Invalid FILE_READING_TYPE');
	end 
      end
      
      s = sprintf('%d', FILENAME_STARTINDEX);
      set(editStartIndex, 'string', s);
      set(editStartIndex, 'value', FILENAME_STARTINDEX);
      
      stopindex = NUM_SCANS;
      s = sprintf('%d', stopindex);
      set(editStopIndex, 'string', s);
      set(editStopIndex, 'string', stopindex);
      
      if length(NUM_VOXELS) == 3
	set(editRawX, 'string', NUM_VOXELS(1));
	set(editRawY, 'string', NUM_VOXELS(2));
	set(editRawZ, 'string', NUM_VOXELS(3));
      end
	
      set(editFilePattern,'string', FILENAME_PATTERN);
      
      set(editPath,'string', FILENAME_PATH);
      % lyngby_ui_loadfile('editFilePattern');

      datatype = lower(DATATYPE);
      s = lower(sDatatype);
      value = length(findstr(s(1:findstr(s, datatype)),'|'))+1;
      set(popupDatatype, 'Value', value);
      %%%%%%%%%%%%%%%%%%%%%% End read globals %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

      eval(UpdateInitialStatus)      
      eval(UpdateButtonEnabling)      

      % Re-evaluate the window settings based on the data_init
      % format, and update validity, grey-outs, status etc...
      lyngby_ui_loadfile('popupFileFormat');
      lyngby_ui_loadfile('buttonTrySetup');
      
      
    else 
      error('Error: lyngby_ui_loadfile.m called with incorrect command.') 
    end 
