function lyngby_ui_lz_init(command,parameter1) 

% lyngby_ui_lz_init    - Lange-Zeger GUI init of parameters
%   
%       function lyngby_ui_lz_init(command,parameter1) 
%   
%       See also: lyngby_lz_main, lyngby_ui_main
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_lz_init.m,v 1.12 1997/09/03 11:57:46 fnielsen Exp $
%       $Revision: 1.12 $;    


    lyngby_lz_global;
    lyngby_ui_option;

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editLowTheta1')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editHighTheta1')) 
	command = 5; 
      elseif strcmp(lower(command),lower('editNoTheta1')) 
	command = 6; 
      elseif strcmp(lower(command),lower('editLowSlope')) 
	command = 7; 
      elseif strcmp(lower(command),lower('editHighSlope')) 
	command = 8; 
      elseif strcmp(lower(command),lower('editNoSlope')) 
	command = 9; 
      elseif strcmp(lower(command),lower('editAlpha')) 
	command = 10; 
      elseif strcmp(lower(command),lower('editZoom')) 
	command = 11; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_lz_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_lz_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	buttonApply = handle_list(1); 
	buttonHelp = handle_list(2); 
	buttonClose = handle_list(3); 
	editLowTheta1 = handle_list(4); 
	editHighTheta1 = handle_list(5); 
	editNoTheta1 = handle_list(6);
	editLowSlope = handle_list(7); 
	editHighSlope = handle_list(8); 
	editNoSlope = handle_list(9); 
	editAlpha = handle_list(10); 
	editZoom = handle_list(11); 
	textLowTheta1 = handle_list(12); 
	textHighTheta1 = handle_list(13); 
	textNoTheta1 = handle_list(14);
	textLowSlope = handle_list(15); 
	textHighSlope = handle_list(16); 
	textNoSlope = handle_list(17); 
	textAlpha = handle_list(18); 
	textZoom = handle_list(19); 
      end 
    end

    if command == 0 

      fig = figure('position',[ 100 100 450 200 ],... 
	  'resize','On','tag','lyngby_ui_lz_init',... 
	  'menubar','Figure','name','lyngby - LZ init filter analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOR_BACK); 

      %  Uicontrol Object Creation 

      x1 = 0.02;
      x3 = 0.34;
      x5 = 0.67;
      x2 = 0.18;
      x4 = 0.5;
      x6 = 0.83;
      y1 = 0.8;
      y2 = 0.6;
      y3 = 0.4;
      h1 = 0.12;
      h2 = 0.12;

      w1 = 0.1556; % width of buttons
      w2 = 0.15;   % width of text
      w3 = 0.15;   % width of edit
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.15 0.10 w1 h1 ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.4 0.10 w1 h1 ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData','');
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ 0.65 0.10 w1 h1 ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      
      editLowTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''editLowTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x2 y1 w3 h2 ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editLowTheta1',... 
	  'UserData','');
      editHighTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''editHighTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x2 y2 w3 h2 ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editHighTheta1',... 
	  'UserData','');
      editNoTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''editNoTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x2 y3 w3 h2 ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editNoTheta1',... 
	  'UserData','');
      editLowSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''editLowSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x4 y1 w3 h2 ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editLowSlope',... 
	  'UserData','');
      editHighSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''editHighSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x4 y2 w3 h2 ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editHighSlope',... 
	  'UserData','');
      editNoSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''editNoSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x4 y3 w3 h2 ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editNoSlope',... 
	  'UserData','');
      editAlpha = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''editAlpha'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x6 y1 w3 h2 ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editAlpha',... 
	  'UserData','');
      editZoom = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''editZoom'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x6 y2 w3 h2],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editZoom',... 
	  'UserData','');
      
      textLowTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''textLowTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 y1 w2 h2 ],... 
	  'String','Min Theta1:',... 
	  'Style','text',... 
	  'Tag','textOrder',... 
	  'UserData','');  
      textHighTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''textHighTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 y2 w2 h2 ],... 
	  'String','Max Theta1:',... 
	  'Style','text',... 
	  'Tag','textHighTheta1',... 
	  'UserData','');  
      textNoTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''textNoTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 y3 w2 h2 ],... 
	  'String','No Theta1:',... 
	  'Style','text',... 
	  'Tag','textNoTheta1',... 
	  'UserData','');  
      textLowSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''textLowSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x3 y1 w2 h2 ],... 
	  'String','Min Slope:',... 
	  'Style','text',... 
	  'Tag','textLowSlope',... 
	  'UserData','');  
      textHighSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''textHighSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x3 y2 w2 h2 ],... 
	  'String','Max Slope:',... 
	  'Style','text',... 
	  'Tag','textHighSlope',... 
	  'UserData','');  
      textNoSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''textNoSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x3 y3 w2 h2 ],... 
	  'String','No Slope:',... 
	  'Style','text',... 
	  'Tag','textNoSlope',... 
	  'UserData','');  
      textAlpha = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''textAlpha'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x5 y1 w2 h2 ],... 
	  'String','Alpha:',... 
	  'Style','text',... 
	  'Tag','textAlpha',... 
	  'UserData','');  
      textZoom = uicontrol(... 
	  'CallBack','lyngby_ui_lz_init(''textZoom'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_BACK,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x5 y2 w2 h2 ],... 
	  'String','Zoom level:',... 
	  'Style','text',... 
	  'Tag','textZoom',... 
	  'UserData','');  

      
      set(editLowTheta1, 'String', num2str(LZ_LOWTHETA1));
      set(editHighTheta1, 'String', num2str(LZ_HIGHTHETA1));
      set(editNoTheta1, 'String', num2str(LZ_NOTHETA1));
      set(editLowSlope, 'String', num2str(LZ_LOWSLOPE));
      set(editHighSlope, 'String', num2str(LZ_HIGHSLOPE));
      set(editNoSlope, 'String', num2str(LZ_NOSLOPE));
      set(editZoom, 'String', num2str(LZ_ZOOM));
      set(editAlpha, 'String', num2str(LZ_ALPHA));



      handle_list = [ ...  
	    buttonApply buttonHelp buttonClose ... 
	    editLowTheta1 editHighTheta1 editNoTheta1 ...
	    editLowSlope editHighSlope editNoSlope ...
	    editAlpha editZoom ...
	    textLowTheta1 textHighTheta1 textNoTheta1 ...
	    textLowSlope textHighSlope textNoSlope ...
	    textAlpha textZoom ...
	    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 

      count=ones(1,8);

      [lowtheta1, count(1)] = sscanf(get(editLowTheta1, 'String'), '%e'); 
      [hightheta1, count(2)] = sscanf(get(editHighTheta1, 'String'), '%e'); 
      [notheta1, count(3)] = sscanf(get(editNoTheta1, 'String'), '%d'); 
      [lowslope, count(4)] = sscanf(get(editLowSlope, 'String'), '%e'); 
      [highslope, count(5)] = sscanf(get(editHighSlope, 'String'), '%e'); 
      [noslope, count(6)] = sscanf(get(editNoSlope, 'String'), '%d'); 
      [zoom, count(7)] = sscanf(get(editZoom, 'String'), '%d'); 
      [alpha, count(8)] = sscanf(get(editAlpha, 'String'), '%e'); 
      
      if count==ones(1,8)
	LZ_LOWTHETA1=lowtheta1;
	LZ_HIGHTHETA1=hightheta1;    
	LZ_NOTHETA1=notheta1;     
	LZ_LOWSLOPE=lowslope;
	LZ_HIGHSLOPE=highslope;
	LZ_NOSLOPE=noslope;
	LZ_ZOOM=zoom;
	LZ_ALPHA=alpha;
      else 
	error('A parameter had a bad format'); 
      end 

	
    elseif command==2 
      
      s1 = [...
	    'In this window you can choose the parameters used for' ...
	    ' estimation of the grid search Lange Zeger filter:'...
	    ];
      s2 = [...
	    '   * Min theta1: Minimal value of theta 1' ...
	    ];
      s3 = [...
	    '   * Max theta1: Maximal value of theta 1' ...
	    ];
      s4 = [...
	    '   * No theta1: Number of grid values of theta 1' ...
	    ];
      s5 = [...
	    '   * Min slope: Minimal value of slope (slope is (theta1-1)/theta2)' ...
	    ];
      s6 = [...
	    '   * Max slope: Maximal value of slope (slope is (theta1-1)/theta2)' ...
	    ];
      s7 = [...
	    '   * No slope: Number of grid values of the slope (slope is (theta1-1)/theta2)' ...
	    ];
      s8 = [...
	    '   * Alpha: The regularization weight on Beta squared in the cost function' ...
	    ];
      s9 = [...
	    '   * Zoom level: Number of times that the zoom window is reposition' ...
	    ];
      s10 = [...
	    'Function: lyngby_ui_lz_init' ...
	    ];
      
  
      
      helpdlg(sprintf('%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n\n%s', s1, ...
	  s2, s3, s4, s5, s6, s7, s8, s9, s10), ...
	  'Initialization of Grid Search Lange-Zeger parameters')
	
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command>3 & command<=11 
      %%
    else 
      error('Error: lyngby_ui_lz_init.m called with incorrect command.') 
    end 





