function lyngby_ui_lzgs_init(command,parameter1) 

% lyngby_ui_lzgs_init  - Lange-Zeger GUI init of parameters
%   
%       function lyngby_ui_lzgs_init(command,parameter1) 
%   
%       See also: lyngby_lzit_main, lyngby_ui_main
%
%	Made with:	GUI Maker Ver 2.1 by Patrick Marchand 

%  Using  : GUI Maker Ver 2.1 by Patrick Marchand 
%                         (PRMarchand@aol.com) 
%
%  Copyright (c)   
%       Permission is granted to modify and re-distribute this 
%	code in any manner as long as this notice is preserved. 
%	All standard disclaimers apply. 

% cvs : $Id: lyngby_ui_lzgs_init.m,v 1.5 1999/06/08 15:37:16 mgl Exp $
%       $Revision: 1.5 $;    


    lyngby_lzgs_global;
    lyngby_ui_option;

    if nargin == 0 
      command = 'new'; 
    end 

    if isstr(command) 
      if strcmp(lower(command),'initialize') | strcmp(lower(command),'new') 
	command = 0; 
      elseif strcmp(lower(command),lower('buttonApply')) 
	command = 1; 
      elseif strcmp(lower(command),lower('buttonHelp')) 
	command = 2; 
      elseif strcmp(lower(command),lower('buttonClose')) 
	command = 3; 
      elseif strcmp(lower(command),lower('editLowTheta1')) 
	command = 4; 
      elseif strcmp(lower(command),lower('editHighTheta1')) 
	command = 5; 
      elseif strcmp(lower(command),lower('editNoTheta1')) 
	command = 6; 
      elseif strcmp(lower(command),lower('editLowSlope')) 
	command = 7; 
      elseif strcmp(lower(command),lower('editHighSlope')) 
	command = 8; 
      elseif strcmp(lower(command),lower('editNoSlope')) 
	command = 9; 
      elseif strcmp(lower(command),lower('editAlpha')) 
	command = 10; 
      elseif strcmp(lower(command),lower('editZoom')) 
	command = 11; 
      end 
    end 

    if command ~= 0 
      h_fig_list = findobj(get(0,'children'),'flat',... 
	  'tag','lyngby_ui_lzgs_init'); 
      if length(h_fig_list) > 1 
	h_fig_list = gcf; 
      elseif length(h_fig_list) == 0 
	error('There are no figures with Tag = lyngby_ui_lzgs_init.'); 
      end 
      handle_list = get(h_fig_list,'userdata'); 
      if length(handle_list) > 0 
	frameEdit = handle_list(1);
	frameControl = handle_list(2);
	textTitle = handle_list(3);
	buttonApply = handle_list(4); 
	buttonHelp = handle_list(5); 
	buttonClose = handle_list(6); 
	editLowTheta1 = handle_list(7); 
	editHighTheta1 = handle_list(8); 
	editNoTheta1 = handle_list(9);
	editLowSlope = handle_list(10); 
	editHighSlope = handle_list(11); 
	editNoSlope = handle_list(12); 
	editAlpha = handle_list(13); 
	editZoom = handle_list(14); 
	textLowTheta1 = handle_list(15); 
	textHighTheta1 = handle_list(16); 
	textNoTheta1 = handle_list(17);
	textLowSlope = handle_list(18); 
	textHighSlope = handle_list(19); 
	textNoSlope = handle_list(20); 
	textAlpha = handle_list(21); 
	textZoom = handle_list(22); 
      end 
    end

    if command == 0 

      fig = figure('position',[ 300 400 450 200 ],... 
	  'resize','On','tag','lyngby_ui_lzgs_init',... 
	  'menubar','Figure','name','lyngby - Grid Search LZ init filter analysis',... 
	  'numbertitle','Off','visible','off',...
	  'Color', UI_COLOUR_WINBACK); 

      %  Uicontrol Object Creation 

      x1 = 0.06;
      x3 = 0.36;
      x5 = 0.66;
      x2 = 0.20;
      x4 = 0.5;
      x6 = 0.80;


      ButtonWidth = 0.20;
      ButtonHeight = 0.10;
      FrameWidth = 0.98;
      FrameColumn = 0.01;
      Row1 = 0.04; % Window controls
      Row2 = 0.21; % Lower buttons
      Row3 = 0.39; % Middle buttons
      Row4 = 0.57; % Upper buttons
      Row5 = 0.68; % Lower title
      Row6 = 0.75; % Upper title
      Column1 = 0.10; % Left window button
      Column2 = 0.40; % Middle window button
      Column3 = 0.70; % Right window button
      Column4 = Column1+ButtonWidth/2; % Labels/titles
      Column5 = 0.50; % Edit boxes
      TextWidth = 0.14; % Text box width
      EditWidth = 0.15; % Edit box width
      LabelWidth = 0.50 - (Column1+ButtonWidth/2); % Label/title width

      frameEdit = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.16 FrameWidth 0.82 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','frameedit',... 
          'UserData',''); 
      frameControl = uicontrol(...
          'Units','normalized',... 
          'ForegroundColor',UI_COLOR_FRONT,... 
          'BackgroundColor',UI_COLOUR_FRAME,...
          'Position',[ FrameColumn 0.02 FrameWidth 0.14 ],... 
          'String','',... 
          'Style','frame',... 
          'Tag','framecontrol',... 
          'UserData',''); 

      textTitle = uicontrol(... 
	  'CallBack','lyngby_ui_lzit_init(''textTitle'');',... 
	  'HorizontalAlignment','center',... 
	  'ForegroundColor', UI_COLOR_FRONT,...
	  'BackgroundColor', UI_COLOUR_STATUS,... 
	  'String','The parameters of the Grid-Search Lange-Zeger algorithm can be specified in this window.',... 
	  'Style','text',... 
	  'Units','normalized',... 
	  'Position',[ 0.05 Row6 0.9 0.18 ],... 
	  'Tag','textTitle',... 
	  'UserData',''); 
      
      buttonApply = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''buttonApply'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column1 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Apply',... 
	  'Style','pushbutton',... 
	  'Tag','buttonApply',... 
	  'UserData',''); 
      buttonClose = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''buttonClose'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column2 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Close',... 
	  'Style','pushbutton',... 
	  'Tag','buttonClose',... 
	  'UserData','');
      buttonHelp = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''buttonHelp'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ Column3 Row1 ButtonWidth ButtonHeight ],... 
	  'String','Help',... 
	  'Style','pushbutton',... 
	  'Tag','buttonHelp',... 
	  'UserData',''); 
      
      editLowTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''editLowTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x2 Row4 EditWidth ButtonHeight ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editLowTheta1',... 
	  'UserData','');
      editHighTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''editHighTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x2 Row3 EditWidth ButtonHeight ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editHighTheta1',... 
	  'UserData','');
      editNoTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''editNoTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x2 Row2 EditWidth ButtonHeight ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editNoTheta1',... 
	  'UserData','');
      editLowSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''editLowSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x4 Row4 EditWidth ButtonHeight ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editLowSlope',... 
	  'UserData','');
      editHighSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''editHighSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x4 Row3 EditWidth ButtonHeight ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editHighSlope',... 
	  'UserData','');
      editNoSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''editNoSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x4 Row2 EditWidth ButtonHeight ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editNoSlope',... 
	  'UserData','');
      editAlpha = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''editAlpha'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x6 Row4 EditWidth ButtonHeight ],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editAlpha',... 
	  'UserData','');
      editZoom = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''editZoom'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOR_CONTROL,...
	  'Units','normalized',... 
	  'Position',[ x6 Row3 EditWidth ButtonHeight],... 
	  'String','7',... 
	  'Style','edit',... 
	  'Tag','editZoom',... 
	  'UserData','');
      
      textLowTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''textLowTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 Row4 TextWidth ButtonHeight ],... 
	  'String','Min Theta1:',... 
	  'Style','text',... 
	  'Tag','textOrder',... 
	  'UserData','');  
      textHighTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''textHighTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 Row3 TextWidth ButtonHeight ],... 
	  'String','Max Theta1:',... 
	  'Style','text',... 
	  'Tag','textHighTheta1',... 
	  'UserData','');  
      textNoTheta1 = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''textNoTheta1'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x1 Row2 TextWidth ButtonHeight ],... 
	  'String','No Theta1:',... 
	  'Style','text',... 
	  'Tag','textNoTheta1',... 
	  'UserData','');  
      textLowSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''textLowSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x3 Row4 TextWidth ButtonHeight ],... 
	  'String','Min Slope:',... 
	  'Style','text',... 
	  'Tag','textLowSlope',... 
	  'UserData','');  
      textHighSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''textHighSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x3 Row3 TextWidth ButtonHeight ],... 
	  'String','Max Slope:',... 
	  'Style','text',... 
	  'Tag','textHighSlope',... 
	  'UserData','');  
      textNoSlope = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''textNoSlope'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x3 Row2 TextWidth ButtonHeight ],... 
	  'String','No Slope:',... 
	  'Style','text',... 
	  'Tag','textNoSlope',... 
	  'UserData','');  
      textAlpha = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''textAlpha'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x5 Row4 TextWidth ButtonHeight ],... 
	  'String','Alpha:',... 
	  'Style','text',... 
	  'Tag','textAlpha',... 
	  'UserData','');  
      textZoom = uicontrol(... 
	  'CallBack','lyngby_ui_lzgs_init(''textZoom'');',... 
	  'ForegroundColor',UI_COLOR_FRONT,... 
	  'BackgroundColor',UI_COLOUR_FRAME,...
	  'HorizontalAlignment','right',... 
	  'Units','normalized',... 
	  'Position',[ x5 Row3 TextWidth ButtonHeight ],... 
	  'String','Zoom level:',... 
	  'Style','text',... 
	  'Tag','textZoom',... 
	  'UserData','');  

      
      set(editLowTheta1, 'String', num2str(LZGS_MINTHETA1));
      set(editHighTheta1, 'String', num2str(LZGS_MAXTHETA1));
      set(editNoTheta1, 'String', num2str(LZGS_NUMTHETA1));
      set(editLowSlope, 'String', num2str(LZGS_MINSLOPE));
      set(editHighSlope, 'String', num2str(LZGS_MAXSLOPE));
      set(editNoSlope, 'String', num2str(LZGS_NUMSLOPE));
      set(editZoom, 'String', num2str(LZGS_ZOOM));
      set(editAlpha, 'String', num2str(LZGS_REG));



      handle_list = [ ...  
	  frameEdit frameControl textTitle ...
	  buttonApply buttonHelp buttonClose ... 
	  editLowTheta1 editHighTheta1 editNoTheta1 ...
	  editLowSlope editHighSlope editNoSlope ...
	  editAlpha editZoom ...
	  textLowTheta1 textHighTheta1 textNoTheta1 ...
	  textLowSlope textHighSlope textNoSlope ...
	  textAlpha textZoom ...
		    ]; 

      set(gcf,'userdata',handle_list); 
      drawnow;pause(.1); 
      set(gcf,'visible','on'); 


    elseif command == 1 

      count=ones(1,8);

      [lowtheta1, count(1)] = sscanf(get(editLowTheta1, 'String'), '%e'); 
      [hightheta1, count(2)] = sscanf(get(editHighTheta1, 'String'), '%e'); 
      [notheta1, count(3)] = sscanf(get(editNoTheta1, 'String'), '%d'); 
      [lowslope, count(4)] = sscanf(get(editLowSlope, 'String'), '%e'); 
      [highslope, count(5)] = sscanf(get(editHighSlope, 'String'), '%e'); 
      [noslope, count(6)] = sscanf(get(editNoSlope, 'String'), '%d'); 
      [zoom, count(7)] = sscanf(get(editZoom, 'String'), '%d'); 
      [alpha, count(8)] = sscanf(get(editAlpha, 'String'), '%e'); 
      
      if count==ones(1,8)
	LZGS_MINTHETA1 = lowtheta1;
	LZGS_MAXTHETA1 = hightheta1;    
	LZGS_NUMTHETA1 = notheta1;     
	LZGS_MINSLOPE = lowslope;
	LZGS_MAXSLOPE = highslope;
	LZGS_NUMSLOPE = noslope;
	LZGS_ZOOM = zoom;
	LZGS_REG = alpha;
      else 
	error('A parameter had a bad format'); 
      end 

	
    elseif command==2 
      
      s1 = [...
	    'This window allows you to choose the parameters used for ' ...
	    'the grid-search Lange-Zeger filter: '...
	    ];
      s2 = [...
	    '* Min theta 1: Minimal value of theta 1' ...
	    ];
      s3 = [...
	    '* Max theta 1: Maximal value of theta 1' ...
	    ];
      s4 = [...
	    '* No. theta 1: Number of grid values of theta 1' ...
	    ];
      s5 = [...
	    '* Min slope: Minimal value of the slope ' ...
	    ];
      s6 = [...
	    '* Max slope: Maximal value of the slope ' ...
	    ];
      s7 = [...
	    '* No. slope: Number of grid values of the slope ' ...
	    ];
      s8 = [...
	    '* Alpha: The regularization weight on Beta squared in the cost function' ...
	    ];
      s9 = [...
	    '* Zoom level: Number of times that the zoom window is repositioned' ...
	    ];
      s95 = [...
	    'Note that the slope is defined as (theta1-1)/theta2) ' ...
	    ];
      s10 = [...
	    'Function: lyngby_ui_lzgs_init' ...
	    ];
      s11 = [...
	    'See also: lyngby_lzgs_main' ...
	    ];
      
  
      
      helpdlg(sprintf('%s\n\n%s\n%s\n%s\n\n%s\n%s\n%s\n\n%s\n%s\n\n%s\n\n%s\n%s', s1, ...
	  s2, s3, s4, s5, s6, s7, s8, s9, s95, s10, s11), ...
	  'Initialization of Grid Search Lange-Zeger parameters')
	
    elseif command == 3 
      %disp('buttonClose selected.') 
      
      close(gcf); 
      
    elseif command>3 & command<=11 
      %%
    else 
      error('Error: lyngby_ui_lzgs_init.m called with incorrect command.') 
    end 





